/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.GetRequestChecker;
import com.google.appengine.api.search.proto.SearchServicePb;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GetRequest {
    private final String startId;
    private final boolean includeStart;
    private final int limit;
    private final boolean returningIdsOnly;

    protected GetRequest(Builder builder) {
        this.startId = builder.startId;
        this.includeStart = this.startId == null ? Boolean.FALSE.booleanValue() : Util.defaultIfNull(builder.includeStart, Boolean.TRUE).booleanValue();
        this.limit = Util.defaultIfNull(builder.limit, 100);
        this.returningIdsOnly = Util.defaultIfNull(builder.returningIdsOnly, Boolean.FALSE);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final Builder newBuilder(GetRequest request) {
        return new Builder(request);
    }

    public String getStartId() {
        return this.startId;
    }

    public boolean isIncludeStart() {
        return this.includeStart;
    }

    public int getLimit() {
        return this.limit;
    }

    public Boolean isReturningIdsOnly() {
        return this.returningIdsOnly;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.includeStart ? 1 : 0);
        result = 31 * result + (this.returningIdsOnly ? 1 : 0);
        result = 31 * result + this.limit;
        result = 31 * result + (this.startId == null ? 0 : this.startId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetRequest other = (GetRequest)obj;
        return this.includeStart == other.includeStart && this.returningIdsOnly == other.returningIdsOnly && this.limit == other.limit && Util.equalObjects(this.startId, other.startId);
    }

    public String toString() {
        return "GetRequest(includeStart=" + this.includeStart + ", startId=" + this.startId + ", limit=" + this.limit + ", returningIdsOnly=" + this.returningIdsOnly + ")";
    }

    SearchServicePb.ListDocumentsParams.Builder copyToProtocolBuffer() {
        SearchServicePb.ListDocumentsParams.Builder builder = SearchServicePb.ListDocumentsParams.newBuilder();
        if (this.isReturningIdsOnly().booleanValue()) {
            builder.setKeysOnly(true);
        }
        if (this.getStartId() != null) {
            builder.setStartDocId(this.getStartId());
        }
        if (!this.isIncludeStart()) {
            builder.setIncludeStartDoc(false);
        }
        builder.setLimit(this.getLimit());
        return builder;
    }

    public static class Builder {
        private @Nullable String startId;
        private @Nullable Boolean includeStart;
        private @Nullable Integer limit;
        private @Nullable Boolean returningIdsOnly;

        protected Builder() {
            this.includeStart = true;
            this.returningIdsOnly = false;
        }

        private Builder(GetRequest request) {
            this.startId = request.getStartId();
            this.includeStart = request.isIncludeStart();
            this.limit = request.getLimit();
            this.returningIdsOnly = request.isReturningIdsOnly();
        }

        public Builder setStartId(String startId) {
            this.startId = GetRequestChecker.checkStartDocId(startId);
            return this;
        }

        public Builder setIncludeStart(boolean includeStart) {
            this.includeStart = includeStart;
            return this;
        }

        public Builder setLimit(Integer limit) {
            this.limit = GetRequestChecker.checkLimit(limit);
            return this;
        }

        public Builder setReturningIdsOnly(boolean returningIdsOnly) {
            this.returningIdsOnly = returningIdsOnly;
            return this;
        }

        public GetRequest build() {
            return new GetRequest(this);
        }
    }
}

