/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.mail;

import com.google.appengine.api.mail.MailService;
import com.google.appengine.api.mail.MailServicePb;
import com.google.apphosting.api.ApiProxy;
import com.google.protobuf.ByteString;
import java.io.IOException;

class MailServiceImpl
implements MailService {
    static final String PACKAGE = "mail";

    MailServiceImpl() {
    }

    @Override
    public void sendToAdmins(MailService.Message message) throws IllegalArgumentException, IOException {
        this.doSend(message, true);
    }

    @Override
    public void send(MailService.Message message) throws IllegalArgumentException, IOException {
        this.doSend(message, false);
    }

    private void doSend(MailService.Message message, boolean toAdmin) throws IllegalArgumentException, IOException {
        MailServicePb.MailMessage.Builder msgProto = MailServicePb.MailMessage.newBuilder();
        if (message.getSender() != null) {
            msgProto.setSender(message.getSender());
        }
        if (message.getTo() != null) {
            msgProto.addAllTo(message.getTo());
        }
        if (message.getCc() != null) {
            msgProto.addAllCc(message.getCc());
        }
        if (message.getBcc() != null) {
            msgProto.addAllBcc(message.getBcc());
        }
        if (message.getReplyTo() != null) {
            msgProto.setReplyTo(message.getReplyTo());
        }
        if (message.getSubject() != null) {
            msgProto.setSubject(message.getSubject());
        }
        if (message.getTextBody() != null) {
            msgProto.setTextBody(message.getTextBody());
        }
        if (message.getHtmlBody() != null) {
            msgProto.setHtmlBody(message.getHtmlBody());
        }
        if (message.getAmpHtmlBody() != null) {
            msgProto.setAmpHtmlBody(message.getAmpHtmlBody());
        }
        if (message.getAttachments() != null) {
            for (MailService.Attachment attach : message.getAttachments()) {
                MailServicePb.MailAttachment.Builder attachProto = MailServicePb.MailAttachment.newBuilder();
                attachProto.setFileName(attach.getFileName());
                attachProto.setData(ByteString.copyFrom((byte[])attach.getData()));
                String contentId = attach.getContentID();
                if (contentId != null) {
                    attachProto.setContentID(contentId);
                }
                msgProto.addAttachment(attachProto);
            }
        }
        if (message.getHeaders() != null) {
            for (MailService.Header header : message.getHeaders()) {
                msgProto.addHeader(MailServicePb.MailHeader.newBuilder().setName(header.getName()).setValue(header.getValue()));
            }
        }
        byte[] msgBytes = msgProto.buildPartial().toByteArray();
        try {
            if (toAdmin) {
                ApiProxy.makeSyncCall((String)PACKAGE, (String)"SendToAdmins", (byte[])msgBytes);
            } else {
                ApiProxy.makeSyncCall((String)PACKAGE, (String)"Send", (byte[])msgBytes);
            }
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (MailServicePb.MailServiceError.ErrorCode.forNumber((int)ex.getApplicationError())) {
                case BAD_REQUEST: {
                    throw new IllegalArgumentException("Bad Request: " + ex.getErrorDetail());
                }
                case UNAUTHORIZED_SENDER: {
                    throw new IllegalArgumentException("Unauthorized Sender: " + ex.getErrorDetail());
                }
                case INVALID_ATTACHMENT_TYPE: {
                    throw new IllegalArgumentException("Invalid Attachment Type: " + ex.getErrorDetail());
                }
                case INVALID_HEADER_NAME: {
                    throw new IllegalArgumentException("Invalid Header Name: " + ex.getErrorDetail());
                }
            }
            throw new IOException(ex.getErrorDetail());
        }
    }
}

