/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class UploadOptions {
    private @Nullable Long maxUploadSizeBytesPerBlob;
    private @Nullable Long maxUploadSizeBytes;
    private String gsBucketName;

    private UploadOptions() {
    }

    public UploadOptions maxUploadSizeBytesPerBlob(long maxUploadSizeBytesPerBlob) {
        if (maxUploadSizeBytesPerBlob < 1L) {
            throw new IllegalArgumentException("maxUploadSizeBytesPerBlob must be positive.");
        }
        this.maxUploadSizeBytesPerBlob = maxUploadSizeBytesPerBlob;
        return this;
    }

    public boolean hasMaxUploadSizeBytesPerBlob() {
        return this.maxUploadSizeBytesPerBlob != null;
    }

    public long getMaxUploadSizeBytesPerBlob() {
        if (this.maxUploadSizeBytesPerBlob == null) {
            throw new IllegalStateException("maxUploadSizeBytesPerBlob has not been set.");
        }
        return this.maxUploadSizeBytesPerBlob;
    }

    public UploadOptions maxUploadSizeBytes(long maxUploadSizeBytes) {
        if (maxUploadSizeBytes < 1L) {
            throw new IllegalArgumentException("maxUploadSizeBytes must be positive.");
        }
        this.maxUploadSizeBytes = maxUploadSizeBytes;
        return this;
    }

    public boolean hasMaxUploadSizeBytes() {
        return this.maxUploadSizeBytes != null;
    }

    public long getMaxUploadSizeBytes() {
        if (this.maxUploadSizeBytes == null) {
            throw new IllegalStateException("maxUploadSizeBytes has not been set.");
        }
        return this.maxUploadSizeBytes;
    }

    public UploadOptions googleStorageBucketName(String bucketName) {
        this.gsBucketName = bucketName;
        return this;
    }

    public boolean hasGoogleStorageBucketName() {
        return this.gsBucketName != null;
    }

    public String getGoogleStorageBucketName() {
        if (this.gsBucketName == null) {
            throw new IllegalStateException("gsBucketName has not been set.");
        }
        return this.gsBucketName;
    }

    public int hashCode() {
        int hash = 17;
        if (this.maxUploadSizeBytesPerBlob != null) {
            hash = hash * 37 + this.maxUploadSizeBytesPerBlob.hashCode();
        }
        if (this.maxUploadSizeBytes != null) {
            hash = hash * 37 + this.maxUploadSizeBytes.hashCode();
        }
        if (this.gsBucketName != null) {
            hash = hash * 37 + this.gsBucketName.hashCode();
        }
        return hash;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof UploadOptions) {
            UploadOptions key = (UploadOptions)object;
            return Objects.equals(this.maxUploadSizeBytesPerBlob, key.maxUploadSizeBytesPerBlob) && Objects.equals(this.maxUploadSizeBytes, key.maxUploadSizeBytes) && Objects.equals(this.gsBucketName, key.gsBucketName);
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("UploadOptions: maxUploadSizeBytes=");
        if (this.maxUploadSizeBytes != null) {
            buffer.append(this.maxUploadSizeBytes);
        } else {
            buffer.append("unlimited");
        }
        buffer.append(", maxUploadSizeBytesPerBlob=");
        if (this.maxUploadSizeBytesPerBlob != null) {
            buffer.append(this.maxUploadSizeBytesPerBlob);
        } else {
            buffer.append("unlimited");
        }
        buffer.append(", gsBucketName=");
        if (this.gsBucketName != null) {
            buffer.append(this.gsBucketName);
        } else {
            buffer.append("None");
        }
        buffer.append(".");
        return buffer.toString();
    }

    public static final class Builder {
        public static UploadOptions withMaxUploadSizeBytes(long maxUploadSizeBytes) {
            return Builder.withDefaults().maxUploadSizeBytes(maxUploadSizeBytes);
        }

        public static UploadOptions withMaxUploadSizeBytesPerBlob(long maxUploadSizeBytesPerBlob) {
            return Builder.withDefaults().maxUploadSizeBytesPerBlob(maxUploadSizeBytesPerBlob);
        }

        public static UploadOptions withGoogleStorageBucketName(String gsBucketName) {
            return Builder.withDefaults().googleStorageBucketName(gsBucketName);
        }

        public static UploadOptions withDefaults() {
            return new UploadOptions();
        }

        private Builder() {
        }
    }
}

