/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobInfoFactory;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreFailureException;
import com.google.appengine.api.blobstore.BlobstoreService;
import com.google.appengine.api.blobstore.BlobstoreServiceFactory;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BlobstoreInputStream
extends InputStream {
    private final BlobKey blobKey;
    private final BlobInfo blobInfo;
    private long blobOffset;
    private byte @Nullable [] buffer;
    private int bufferOffset;
    private boolean markSet = false;
    private long markOffset;
    private final BlobstoreService blobstoreService;
    private boolean isClosed = false;

    public BlobstoreInputStream(BlobKey blobKey, long offset) throws IOException {
        this(blobKey, offset, new BlobInfoFactory(), BlobstoreServiceFactory.getBlobstoreService());
    }

    public BlobstoreInputStream(BlobKey blobKey) throws IOException {
        this(blobKey, 0L);
    }

    BlobstoreInputStream(BlobKey blobKey, long offset, BlobInfoFactory blobInfoFactory, BlobstoreService blobstoreService) throws IOException {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset " + offset + " is less than 0");
        }
        this.blobKey = blobKey;
        this.blobOffset = offset;
        this.blobstoreService = blobstoreService;
        BlobInfo maybeBlobInfo = blobInfoFactory.loadBlobInfo(blobKey);
        if (maybeBlobInfo == null) {
            throw new BlobstoreIOException("BlobstoreInputStream received an invalid blob key: " + blobKey.getKeyString());
        }
        this.blobInfo = maybeBlobInfo;
    }

    private boolean atEndOfBuffer() {
        Preconditions.checkState((this.buffer == null || this.bufferOffset <= this.buffer.length ? 1 : 0) != 0, (Object)"Buffer offset is past the end of the buffer. This should never happen.");
        return this.buffer == null || this.bufferOffset == this.buffer.length;
    }

    private void checkClosedStream() throws ClosedStreamException {
        if (this.isClosed) {
            throw new ClosedStreamException("Stream is closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.buffer = null;
    }

    @Override
    public int read() throws IOException {
        this.checkClosedStream();
        if (!this.ensureDataInBuffer()) {
            return -1;
        }
        Objects.requireNonNull(this.buffer);
        return this.buffer[this.bufferOffset++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosedStream();
        Preconditions.checkNotNull((Object)b);
        Preconditions.checkElementIndex((int)off, (int)b.length);
        Preconditions.checkPositionIndex((int)(off + len), (int)b.length);
        if (len == 0) {
            return 0;
        }
        if (!this.ensureDataInBuffer()) {
            return -1;
        }
        Objects.requireNonNull(this.buffer);
        int amountToCopy = Integer.min(this.buffer.length - this.bufferOffset, len);
        System.arraycopy(this.buffer, this.bufferOffset, b, off, amountToCopy);
        this.bufferOffset += amountToCopy;
        return amountToCopy;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.markSet = true;
        this.markOffset = this.blobOffset;
        if (this.buffer != null) {
            this.markOffset += (long)(this.bufferOffset - this.buffer.length);
        }
    }

    @Override
    public void reset() throws IOException {
        this.checkClosedStream();
        if (!this.markSet) {
            throw new IOException("Attempted to reset on un-mark()ed BlobstoreInputStream");
        }
        this.blobOffset = this.markOffset;
        this.buffer = null;
        this.bufferOffset = 0;
        this.markSet = false;
    }

    private boolean ensureDataInBuffer() throws IOException {
        if (!this.atEndOfBuffer()) {
            return true;
        }
        long fetchSize = Math.min(this.blobInfo.getSize() - this.blobOffset, 1015808L);
        if (fetchSize <= 0L) {
            this.buffer = null;
            return false;
        }
        try {
            this.buffer = this.blobstoreService.fetchData(this.blobKey, this.blobOffset, this.blobOffset + fetchSize - 1L);
            this.blobOffset += (long)this.buffer.length;
            this.bufferOffset = 0;
            return true;
        }
        catch (BlobstoreFailureException bfe) {
            throw new BlobstoreIOException("Error reading data from Blobstore", bfe);
        }
    }

    public static final class BlobstoreIOException
    extends IOException {
        private static final long serialVersionUID = 3160441042922394772L;

        public BlobstoreIOException(String message) {
            super(message);
        }

        public BlobstoreIOException(String message, Throwable cause) {
            super(message);
            this.initCause(cause);
        }
    }

    public static final class ClosedStreamException
    extends IOException {
        private static final long serialVersionUID = 3251292840204787108L;

        public ClosedStreamException(String message) {
            super(message);
        }

        public ClosedStreamException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

