/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.checkers.CursorChecker;
import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.appengine.api.search.checkers.SortExpressionChecker;
import com.google.appengine.api.search.checkers.SortOptionsChecker;
import com.google.appengine.api.search.proto.SearchServicePb;
import com.google.common.base.Preconditions;
import java.util.List;

public final class QueryOptionsChecker {
    public static int checkLimit(int limit) {
        Preconditions.checkArgument((limit >= 1 && limit <= 1000 ? 1 : 0) != 0, (String)"The limit %s must be between 1 and %s", (int)limit, (int)1000);
        return limit;
    }

    public static Integer checkOffset(Integer offset) {
        if (offset != null) {
            Preconditions.checkArgument((offset >= 0 && offset <= 1000 ? 1 : 0) != 0, (String)"The offset %s must be between 0 and %s", (Object)offset, (int)1000);
        }
        return offset;
    }

    public static int checkNumberFoundAccuracy(int numberFoundAccuracy) {
        Preconditions.checkArgument((numberFoundAccuracy >= 1 && numberFoundAccuracy <= 25000 ? 1 : 0) != 0, (String)"The number found accuracy %s must be between 1 and %s", (int)numberFoundAccuracy, (int)25000);
        return numberFoundAccuracy;
    }

    public static List<String> checkFieldNames(List<String> fieldNames) {
        QueryOptionsChecker.checkNumberOfFields(fieldNames.size());
        for (String fieldName : fieldNames) {
            FieldChecker.checkFieldName(fieldName);
        }
        return fieldNames;
    }

    private static List<SearchServicePb.FieldSpec.Expression> checkExpressions(List<SearchServicePb.FieldSpec.Expression> expressions) {
        QueryOptionsChecker.checkNumberOfFields(expressions.size());
        for (SearchServicePb.FieldSpec.Expression expression : expressions) {
            FieldChecker.checkFieldName(expression.getName());
            FieldChecker.checkExpression(expression.getExpression());
        }
        return expressions;
    }

    private static void checkNumberOfFields(int numberOfFields) {
        Preconditions.checkArgument((numberOfFields <= 1000 ? 1 : 0) != 0, (String)"number of fields to return %s greater than %s", (int)numberOfFields, (int)1000);
    }

    public static SearchServicePb.SearchParams checkValid(SearchServicePb.SearchParams params) {
        if (params.hasCursor()) {
            CursorChecker.checkCursor(params.getCursor());
        }
        QueryOptionsChecker.checkOffset(params.getOffset());
        QueryOptionsChecker.checkLimit(params.getLimit());
        if (params.hasMatchedCountAccuracy()) {
            QueryOptionsChecker.checkNumberFoundAccuracy(params.getMatchedCountAccuracy());
        }
        for (SearchServicePb.SortSpec sortSpec : params.getSortSpecList()) {
            SortExpressionChecker.checkValid(sortSpec);
        }
        if (params.hasScorerSpec()) {
            SortOptionsChecker.checkValid(params.getScorerSpec());
        }
        if (params.getKeysOnly()) {
            Preconditions.checkArgument((params.getFieldSpec().getExpressionCount() == 0 ? 1 : 0) != 0, (Object)"if IDs only is requested expression to return must be empty");
            Preconditions.checkArgument((params.getFieldSpec().getNameCount() == 0 ? 1 : 0) != 0, (Object)"if IDs only is requested fields to return must be empty");
        }
        QueryOptionsChecker.checkFieldNames((List<String>)params.getFieldSpec().getNameList());
        QueryOptionsChecker.checkExpressions(params.getFieldSpec().getExpressionList());
        return params;
    }
}

