/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseQueryResultsSource;
import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.Projection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.datastore.v1.EntityOrBuilder;
import com.google.datastore.v1.EntityResult;
import com.google.datastore.v1.QueryResultBatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class WrappedQueryResultCloudDatastoreV1
implements BaseQueryResultsSource.WrappedQueryResult {
    private final QueryResultBatch batch;

    WrappedQueryResultCloudDatastoreV1(QueryResultBatch batch) {
        this.batch = batch;
    }

    @Override
    public Cursor getEndCursor() {
        Preconditions.checkState((!this.batch.getEndCursor().isEmpty() ? 1 : 0) != 0, (Object)"Batch contained no end cursor.");
        return new Cursor(this.batch.getEndCursor());
    }

    @Override
    public List<Entity> getEntities(Collection<Projection> projections) {
        ArrayList entityList = Lists.newArrayListWithCapacity((int)this.batch.getEntityResultsCount());
        if (projections.isEmpty()) {
            for (EntityResult entityResult : this.batch.getEntityResultsList()) {
                entityList.add(DataTypeTranslator.toEntity((EntityOrBuilder)entityResult.getEntity()));
            }
        } else {
            for (EntityResult entityResult : this.batch.getEntityResultsList()) {
                entityList.add(DataTypeTranslator.toEntity((EntityOrBuilder)entityResult.getEntity(), projections));
            }
        }
        return entityList;
    }

    @Override
    public List<Cursor> getResultCursors() {
        ArrayList cursors = Lists.newArrayListWithCapacity((int)this.batch.getEntityResultsCount());
        for (EntityResult result : this.batch.getEntityResultsList()) {
            cursors.add(result.getCursor().isEmpty() ? null : new Cursor(result.getCursor()));
        }
        return cursors;
    }

    @Override
    public Cursor getSkippedResultsCursor() {
        return this.batch.getSkippedCursor().isEmpty() ? null : new Cursor(this.batch.getSkippedCursor());
    }

    @Override
    public boolean hasMoreResults() {
        return this.batch.getMoreResults() == QueryResultBatch.MoreResultsType.NOT_FINISHED;
    }

    @Override
    public int numSkippedResults() {
        return this.batch.getSkippedResults();
    }

    @Override
    public List<Index> getIndexInfo(Collection<Index> monitoredIndexBuffer) {
        return ImmutableList.of();
    }

    @Override
    public boolean madeProgress(BaseQueryResultsSource.WrappedQueryResult previousResult) {
        if (!this.hasMoreResults()) {
            return true;
        }
        return !this.getEndCursor().equals(previousResult.getEndCursor());
    }

    QueryResultBatch getBatch() {
        return this.batch;
    }
}

