/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.InQuerySplitter;
import com.google.appengine.api.datastore.MultiQueryBuilder;
import com.google.appengine.api.datastore.NotEqualQuerySplitter;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QuerySplitter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

final class QuerySplitHelper {
    private static final int MAX_PARALLEL_QUERIES = 30;
    private static final Collection<QuerySplitter> QUERY_SPLITTERS = Collections.synchronizedCollection(Arrays.asList(new NotEqualQuerySplitter(), new InQuerySplitter()));

    private QuerySplitHelper() {
    }

    static List<MultiQueryBuilder> splitQuery(Query query) {
        return QuerySplitHelper.splitQuery(query, QUERY_SPLITTERS);
    }

    static List<MultiQueryBuilder> splitQuery(Query query, Collection<QuerySplitter> splitters) {
        ArrayList result;
        if (query.getFilter() == null) {
            result = Collections.singletonList(QuerySplitHelper.splitQuery(query.getFilterPredicates(), query, splitters));
        } else {
            Set<Set<Query.FilterPredicate>> dnf = QuerySplitHelper.getDisjunctiveNormalForm(query.getFilter());
            result = Lists.newArrayListWithCapacity((int)dnf.size());
            for (Set<Query.FilterPredicate> filters : dnf) {
                result.add(QuerySplitHelper.splitQuery(filters, query, splitters));
            }
        }
        int totalParallelQueries = 0;
        for (MultiQueryBuilder builder : result) {
            totalParallelQueries += builder.getParallelQuerySize();
        }
        Preconditions.checkArgument((totalParallelQueries <= 30 ? 1 : 0) != 0, (Object)"Splitting the provided query requires that too many subqueries are merged in memory.");
        return result;
    }

    static MultiQueryBuilder splitQuery(Collection<Query.FilterPredicate> filters, Query baseQuery, Collection<QuerySplitter> splitters) {
        LinkedList remainingFilters = Lists.newLinkedList(filters);
        ArrayList components = Lists.newArrayList();
        for (QuerySplitter splitter : splitters) {
            components.addAll(splitter.split(remainingFilters, baseQuery.getSortPredicates()));
        }
        return new MultiQueryBuilder((List<Query.FilterPredicate>)remainingFilters, components, !baseQuery.getSortPredicates().isEmpty());
    }

    static Set<Set<Query.FilterPredicate>> getDisjunctiveNormalForm(Query.Filter filter) {
        if (filter instanceof Query.CompositeFilter) {
            return QuerySplitHelper.getDisjunctiveNormalForm((Query.CompositeFilter)filter);
        }
        if (filter instanceof Query.FilterPredicate) {
            return Collections.singleton(Sets.newLinkedHashSet((Iterable)ImmutableSet.of((Object)((Query.FilterPredicate)filter))));
        }
        throw new IllegalArgumentException("Unknown expression type: " + filter.getClass());
    }

    static Set<Set<Query.FilterPredicate>> getDisjunctiveNormalForm(Query.CompositeFilter filter) {
        switch (filter.getOperator()) {
            case AND: {
                return QuerySplitHelper.getDisjunctiveNormalFormAnd(filter.getSubFilters());
            }
            case OR: {
                return QuerySplitHelper.getDisjunctiveNormalFormOr(filter.getSubFilters());
            }
        }
        throw new IllegalArgumentException("Unknown expression operator: " + (Object)((Object)filter.getOperator()));
    }

    static Set<Set<Query.FilterPredicate>> getDisjunctiveNormalFormAnd(Collection<Query.Filter> subFilter) {
        LinkedHashSet predicates = Sets.newLinkedHashSetWithExpectedSize((int)subFilter.size());
        LinkedHashSet result = null;
        for (Query.Filter subExp : subFilter) {
            if (subExp instanceof Query.FilterPredicate) {
                predicates.add((Query.FilterPredicate)subExp);
                continue;
            }
            if (subExp instanceof Query.CompositeFilter) {
                LinkedHashSet dnf = QuerySplitHelper.getDisjunctiveNormalForm((Query.CompositeFilter)subExp);
                if (result == null) {
                    result = dnf;
                    continue;
                }
                LinkedHashSet combinedDnf = Sets.newLinkedHashSetWithExpectedSize((int)(dnf.size() * result.size()));
                for (Set<Query.FilterPredicate> rhs : result) {
                    for (Set lhs : dnf) {
                        LinkedHashSet combined = Sets.newLinkedHashSetWithExpectedSize((int)(rhs.size() + lhs.size()));
                        combined.addAll(rhs);
                        combined.addAll(lhs);
                        combinedDnf.add(combined);
                    }
                }
                result = combinedDnf;
                continue;
            }
            throw new IllegalArgumentException("Unknown expression type: " + subExp.getClass());
        }
        if (result == null) {
            return Collections.singleton(predicates);
        }
        if (!predicates.isEmpty()) {
            for (Set clause : result) {
                clause.addAll(predicates);
            }
        }
        return result;
    }

    static Set<Set<Query.FilterPredicate>> getDisjunctiveNormalFormOr(Collection<Query.Filter> subFilters) {
        LinkedHashSet result = Sets.newLinkedHashSetWithExpectedSize((int)subFilters.size());
        for (Query.Filter subExp : subFilters) {
            result.addAll(QuerySplitHelper.getDisjunctiveNormalForm(subExp));
        }
        return result;
    }
}

