/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.AppEngineInternal;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@AppEngineInternal
public final class FutureHelper {
    public static <T> T quietGet(Future<T> future) {
        try {
            return FutureHelper.getInternal(future);
        }
        catch (ExecutionException e) {
            throw FutureHelper.propagateAsRuntimeException(e);
        }
    }

    public static <T, E extends Exception> T quietGet(Future<T> future, Class<E> exceptionClass) throws E {
        try {
            return FutureHelper.getInternal(future);
        }
        catch (ExecutionException e) {
            if (e.getCause().getClass().equals(exceptionClass)) {
                Exception exception = (Exception)e.getCause();
                throw exception;
            }
            throw FutureHelper.propagateAsRuntimeException(e);
        }
    }

    private static <T> T getInternal(Future<T> future) throws ExecutionException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (ApiProxy.getCurrentEnvironment().getRemainingMillis() <= 0L) {
                throw new DatastoreFailureException("The thread has been interrupted and the request has timed out", e);
            }
            throw new DatastoreFailureException("The thread has been interrupted", e);
        }
    }

    private static RuntimeException propagateAsRuntimeException(ExecutionException ee) {
        if (ee.getCause() instanceof RuntimeException) {
            throw (RuntimeException)ee.getCause();
        }
        if (ee.getCause() instanceof Error) {
            throw (Error)ee.getCause();
        }
        throw new UndeclaredThrowableException(ee.getCause());
    }

    static class FakeFuture<T>
    implements Future<T> {
        private final T result;

        FakeFuture(T result) {
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws ExecutionException {
            return this.result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) {
            return this.result;
        }
    }

    static final class TxnAwareFuture<T>
    implements Future<T> {
        private final Future<T> future;
        private final Transaction txn;
        private final TransactionStack txnStack;

        TxnAwareFuture(Future<T> future, Transaction txn, TransactionStack txnStack) {
            this.future = future;
            this.txn = txn;
            this.txnStack = txnStack;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            this.txnStack.getFutures(this.txn).remove(this.future);
            return this.future.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.txnStack.getFutures(this.txn).remove(this.future);
            return this.future.get(timeout, unit);
        }
    }

    static abstract class MultiFuture<K, V>
    implements Future<V> {
        protected final Iterable<Future<K>> futures;

        public MultiFuture(Iterable<Future<K>> futures) {
            this.futures = futures;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result = true;
            for (Future<K> future : this.futures) {
                result &= future.cancel(mayInterruptIfRunning);
            }
            return result;
        }

        @Override
        public boolean isCancelled() {
            boolean result = true;
            for (Future<K> future : this.futures) {
                result &= future.isCancelled();
            }
            return result;
        }

        @Override
        public boolean isDone() {
            boolean result = true;
            for (Future<K> future : this.futures) {
                result &= future.isDone();
            }
            return result;
        }
    }
}

