/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.tools.info.AppengineSdk;
import com.google.appengine.tools.info.LocalVersionFactory;
import com.google.appengine.tools.info.RemoteVersionFactory;
import com.google.appengine.tools.info.UpdateCheckResults;
import com.google.appengine.tools.info.Version;
import com.google.apphosting.utils.config.ApplicationXml;
import com.google.apphosting.utils.config.ApplicationXmlReader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class UpdateCheck {
    private static final Logger logger = Logger.getLogger(UpdateCheck.class.getName());
    private static final long MAX_NAG_FREQUENCY = 604800L;
    private static final String OPT_OUT_FILE = ".appcfg_no_nag";
    private static final ApplicationXmlReader APPLICATION_XML_READER = new ApplicationXmlReader();
    private final String server;
    private final File appDirectory;
    private final Preferences prefs;
    private final boolean secure;

    public UpdateCheck(String server) {
        this(server, null, false);
    }

    public UpdateCheck(String server, File appDirectory, boolean secure) {
        this.server = server;
        this.appDirectory = appDirectory;
        this.secure = secure;
        this.prefs = Preferences.userNodeForPackage(UpdateCheck.class);
    }

    public boolean allowedToCheckForUpdates() {
        File optOutFile = new File(System.getProperty("user.home"), OPT_OUT_FILE);
        return !optOutFile.exists();
    }

    @Deprecated
    public UpdateCheckResults checkForUpdates() {
        Version localVersion = UpdateCheck.getWarVersion(this.appDirectory);
        logger.fine("Local Version: " + localVersion);
        Version remoteVersion = new RemoteVersionFactory(localVersion, this.server, this.secure).getVersion();
        logger.fine("Remote Version: " + remoteVersion);
        return new UpdateCheckResults(localVersion, remoteVersion);
    }

    @VisibleForTesting
    static Version makeCombinedLocalVersion(List<VersionWithWarPath> localVersionWithPaths) {
        if (localVersionWithPaths.isEmpty()) {
            throw new IllegalArgumentException("localVersionWithPaths may not be empty.");
        }
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (VersionWithWarPath localVersionWithPath : localVersionWithPaths) {
            setBuilder.addAll(localVersionWithPath.getVersion().getApiVersions());
        }
        Version localVersion0 = localVersionWithPaths.get(0).getVersion();
        return new Version(localVersion0.getRelease(), localVersion0.getTimestamp(), (Set<String>)setBuilder.build());
    }

    ApplicationVersionInfo getApplicationVersionInfo() {
        List<VersionWithWarPath> localVersionWithWarPaths = UpdateCheck.getLocalVersions(this.appDirectory);
        logger.fine("Local Versions: " + localVersionWithWarPaths);
        Version remoteVersion = new RemoteVersionFactory(UpdateCheck.makeCombinedLocalVersion(localVersionWithWarPaths), this.server, this.secure).getVersion();
        logger.fine("Remote Version: " + remoteVersion);
        return new ApplicationVersionInfo(localVersionWithWarPaths, remoteVersion);
    }

    static boolean isWar(File maybeWarPath) {
        if (maybeWarPath == null) {
            return false;
        }
        File webInf = new File(maybeWarPath, "WEB-INF");
        File appengineWebXml = new File(webInf, "appengine-web.xml");
        File webXml = new File(webInf, "web.xml");
        File libDir = new File(webInf, "lib");
        return appengineWebXml.isFile() && webXml.isFile() && libDir.isDirectory();
    }

    static boolean isEar(File maybeEarPath) {
        if (maybeEarPath == null) {
            return false;
        }
        File metaInf = new File(maybeEarPath, "META-INF");
        File appengineApplicationXml = new File(metaInf, "appengine-application.xml");
        File applicationXml = new File(metaInf, "application.xml");
        return appengineApplicationXml.isFile() && applicationXml.isFile();
    }

    static Version getWarVersion(File warPath) {
        File[] libFiles;
        File libDir;
        if (warPath != null && (libDir = new File(new File(warPath, "WEB-INF"), "lib")).isDirectory() && (libFiles = libDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String lowercasePath = file.getPath().toLowerCase();
                return lowercasePath.endsWith(".jar") || lowercasePath.endsWith(".zip");
            }
        })) != null) {
            return new LocalVersionFactory(Arrays.asList(libFiles)).getVersion();
        }
        return AppengineSdk.getSdk().getLocalVersion();
    }

    static List<VersionWithWarPath> getEarVersions(File earDirectory) {
        File metaInf = new File(earDirectory, "META-INF");
        File applicationXmlFile = new File(metaInf, "application.xml");
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        try {
            ApplicationXml applicationXml = APPLICATION_XML_READER.processXml((InputStream)new FileInputStream(applicationXmlFile));
            for (ApplicationXml.Modules.Web web : applicationXml.getModules().getWeb()) {
                File warDirectory = new File(earDirectory, web.getWebUri());
                if (!UpdateCheck.isWar(warDirectory)) continue;
                resultBuilder.add((Object)new VersionWithWarPath(warDirectory, UpdateCheck.getWarVersion(warDirectory)));
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalStateException("File should exist - '" + applicationXmlFile + "'");
        }
        return resultBuilder.build();
    }

    static List<VersionWithWarPath> getLocalVersions(File applicationDirectory) {
        ImmutableList result = null;
        if (UpdateCheck.isEar(applicationDirectory)) {
            result = UpdateCheck.getEarVersions(applicationDirectory);
        }
        if (result == null || result.isEmpty()) {
            result = ImmutableList.of((Object)new VersionWithWarPath(applicationDirectory, UpdateCheck.getWarVersion(applicationDirectory)));
        }
        return result;
    }

    public boolean maybePrintNagScreen(PrintStream out) {
        ApplicationVersionInfo applicationVersionInfo = this.getApplicationVersionInfo();
        if (!this.canNagUser()) {
            return false;
        }
        if (UpdateCheck.doNagScreen(applicationVersionInfo, out)) {
            this.prefs.putLong("lastNagTime", System.currentTimeMillis());
            try {
                this.prefs.flush();
            }
            catch (BackingStoreException ex) {
                logger.log(Level.WARNING, "Could not update last nag time.");
            }
            return true;
        }
        return false;
    }

    private boolean canNagUser() {
        try {
            this.prefs.sync();
        }
        catch (BackingStoreException ex) {
            logger.log(Level.WARNING, "Could not sync last nag time.");
        }
        long lastNagTime = this.prefs.getLong("lastNagTime", 0L);
        return System.currentTimeMillis() - lastNagTime > 604800L;
    }

    static boolean doNagScreen(ApplicationVersionInfo applicationVersionInfo, PrintStream out) {
        UpdateCheckResults checkResults;
        for (VersionWithWarPath versionWithWarPath : applicationVersionInfo.getLocalVersions()) {
            checkResults = new UpdateCheckResults(versionWithWarPath.getVersion(), applicationVersionInfo.getRemoteVersion());
            if (!checkResults.isLocalApiVersionNoLongerSupported()) continue;
            String apiVersionComparisonMessage = checkResults.isNewerReleaseAvailable() ? "no longer" : "not yet";
            UpdateCheck.printNagMessage("The API version in this SDK is " + apiVersionComparisonMessage + " supported on the server!", out, checkResults);
            logger.fine("Unsupported API version detected for " + versionWithWarPath);
            return true;
        }
        for (VersionWithWarPath versionWithWarPath : applicationVersionInfo.getLocalVersions()) {
            checkResults = new UpdateCheckResults(versionWithWarPath.getVersion(), applicationVersionInfo.getRemoteVersion());
            if (!checkResults.isNewerReleaseAvailable()) continue;
            if (checkResults.isNewerApiVersionAvailable()) {
                UpdateCheck.printNagMessage("You are using a deprecated API version.  Please upgrade.", out, checkResults);
                logger.fine("Deprecated API version detected for " + versionWithWarPath);
                return true;
            }
            UpdateCheck.printNagMessage("There is a new version of the SDK available.", out, checkResults);
            logger.fine("Deprecated SDK version detected for " + versionWithWarPath);
            return true;
        }
        return false;
    }

    private static void printNagMessage(String message, PrintStream out, UpdateCheckResults results) {
        out.println("********************************************************");
        out.println(message);
        out.println("-----------");
        out.println("Latest SDK:");
        out.println(results.getRemoteVersion());
        out.println("-----------");
        out.println("Your SDK:");
        out.println(results.getLocalVersion());
        out.println("-----------");
        out.println("Please visit https://cloud.google.com/sdk/gcloud/reference/components/update ");
        out.println("to see how to get the latest version.");
        out.println("********************************************************");
    }

    static boolean validateVersion(String version, PrintStream out) {
        String[] versions;
        if (version != null && (versions = version.split("\\.")).length >= 2 && versions[0].equals("1")) {
            try {
                int minor = Integer.parseInt(versions[1]);
                if (minor < 6) {
                    out.println("********************************************************");
                    out.println("Warning: Future versions of the Dev App Server will require Java 1.6 or later. Please upgrade your JRE.");
                    out.println("********************************************************");
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean checkJavaVersion(PrintStream out) {
        return UpdateCheck.validateVersion(System.getProperty("java.specification.version"), out);
    }

    @VisibleForTesting
    static class ApplicationVersionInfo {
        final List<VersionWithWarPath> localVersions;
        final Version remoteVersion;

        ApplicationVersionInfo(List<VersionWithWarPath> localVersions, Version remoteVersion) {
            this.localVersions = localVersions;
            this.remoteVersion = remoteVersion;
        }

        final List<VersionWithWarPath> getLocalVersions() {
            return this.localVersions;
        }

        final Version getRemoteVersion() {
            return this.remoteVersion;
        }

        public String toString() {
            return "ApplicationVersionInfo: localVersions=" + this.localVersions + " remoteVersion=" + this.remoteVersion;
        }
    }

    @VisibleForTesting
    static class VersionWithWarPath {
        private final File warPath;
        private final Version version;

        VersionWithWarPath(File warPath, Version version) {
            this.warPath = warPath;
            this.version = version;
        }

        File getWarPath() {
            return this.warPath;
        }

        Version getVersion() {
            return this.version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            result = 31 * result + (this.warPath == null ? 0 : this.warPath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            VersionWithWarPath other = (VersionWithWarPath)obj;
            if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
                return false;
            }
            return !(this.warPath == null ? other.warPath != null : !this.warPath.equals(other.warPath));
        }

        public String toString() {
            return "VersionWithWarPath: warPath=" + this.warPath + " version=" + this.version;
        }
    }
}

