/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.modules.ModulesException;
import com.google.appengine.api.modules.ModulesService;
import com.google.appengine.api.modules.ModulesServiceFactory;
import com.google.appengine.tools.development.AbstractBackendServers;
import com.google.appengine.tools.development.BackendServers;
import com.google.appengine.tools.development.LocalEnvironment;
import com.google.appengine.tools.development.Modules;
import com.google.appengine.tools.development.ModulesFilterHelper;
import com.google.apphosting.api.ApiProxy;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DevAppServerModulesFilter
implements Filter {
    static final String BACKEND_REDIRECT_ATTRIBUTE = "com.google.appengine.backend.BackendName";
    static final String BACKEND_INSTANCE_REDIRECT_ATTRIBUTE = "com.google.appengine.backend.BackendInstance";
    @VisibleForTesting
    static final String MODULE_INSTANCE_REDIRECT_ATTRIBUTE = "com.google.appengine.module.ModuleInstance";
    static final int INSTANCE_BUSY_ERROR_CODE = 500;
    static final int MODULE_STOPPED_ERROR_CODE = 404;
    static final int MODULE_MISSING_ERROR_CODE = 502;
    private final AbstractBackendServers backendServersManager;
    private final ModulesService modulesService;
    private final Logger logger = Logger.getLogger(DevAppServerModulesFilter.class.getName());

    @VisibleForTesting
    DevAppServerModulesFilter(AbstractBackendServers backendServers, ModulesService modulesService) {
        this.backendServersManager = backendServers;
        this.modulesService = modulesService;
    }

    public DevAppServerModulesFilter() {
        this(BackendServers.getInstance(), ModulesServiceFactory.getModulesService());
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = (HttpServletResponse)response;
        RequestType requestType = this.getRequestType(hrequest);
        switch (requestType) {
            case DIRECT_MODULE_REQUEST: {
                this.doDirectModuleRequest(hrequest, hresponse, chain);
                break;
            }
            case REDIRECT_REQUESTED: {
                this.doRedirect(hrequest, hresponse);
                break;
            }
            case DIRECT_BACKEND_REQUEST: {
                this.doDirectBackendRequest(hrequest, hresponse, chain);
                break;
            }
            case REDIRECTED_BACKEND_REQUEST: {
                this.doRedirectedBackendRequest(hrequest, hresponse, chain);
                break;
            }
            case REDIRECTED_MODULE_REQUEST: {
                this.doRedirectedModuleRequest(hrequest, hresponse, chain);
                break;
            }
            case STARTUP_REQUEST: {
                this.doStartupRequest(hrequest, hresponse, chain);
            }
        }
    }

    @VisibleForTesting
    RequestType getRequestType(HttpServletRequest hrequest) {
        int instancePort = hrequest.getServerPort();
        String backendServerName = this.backendServersManager.getServerNameFromPort(instancePort);
        if (hrequest.getRequestURI().equals("/_ah/start") && this.expectsGeneratedStartRequests(backendServerName, instancePort)) {
            return RequestType.STARTUP_REQUEST;
        }
        if (hrequest.getAttribute(BACKEND_REDIRECT_ATTRIBUTE) instanceof String) {
            return RequestType.REDIRECTED_BACKEND_REQUEST;
        }
        if (hrequest.getAttribute(MODULE_INSTANCE_REDIRECT_ATTRIBUTE) instanceof Integer) {
            return RequestType.REDIRECTED_MODULE_REQUEST;
        }
        if (backendServerName != null) {
            int backendInstance = this.backendServersManager.getServerInstanceFromPort(instancePort);
            if (backendInstance == -1) {
                return RequestType.REDIRECT_REQUESTED;
            }
            return RequestType.DIRECT_BACKEND_REQUEST;
        }
        String serverRedirectHeader = DevAppServerModulesFilter.getHeaderOrParameter(hrequest, "X-AppEngine-BackendName");
        if (serverRedirectHeader == null && !this.isLoadBalancingRequest()) {
            return RequestType.DIRECT_MODULE_REQUEST;
        }
        return RequestType.REDIRECT_REQUESTED;
    }

    private boolean isLoadBalancingRequest() {
        ModulesFilterHelper modulesFilterHelper = this.getModulesFilterHelper();
        String module = this.modulesService.getCurrentModule();
        int instance = this.getCurrentModuleInstance();
        return modulesFilterHelper.isLoadBalancingInstance(module, instance);
    }

    private boolean expectsGeneratedStartRequests(String backendName, int requestPort) {
        String moduleOrBackendName = backendName;
        if (moduleOrBackendName == null) {
            moduleOrBackendName = this.modulesService.getCurrentModule();
        }
        int instance = backendName == null ? this.getCurrentModuleInstance() : this.backendServersManager.getServerInstanceFromPort(requestPort);
        ModulesFilterHelper modulesFilterHelper = this.getModulesFilterHelper();
        return modulesFilterHelper.expectsGeneratedStartRequests(moduleOrBackendName, instance);
    }

    private int getCurrentModuleInstance() {
        String instance = "-1";
        try {
            instance = this.modulesService.getCurrentInstanceId();
        }
        catch (ModulesException me) {
            this.logger.log(Level.FINEST, "Ignoring Exception getting module instance and continuing", me);
        }
        return Integer.parseInt(instance);
    }

    private ModulesFilterHelper getModulesFilterHelper() {
        Map attributes = ApiProxy.getCurrentEnvironment().getAttributes();
        return (ModulesFilterHelper)attributes.get("com.google.appengine.tools.development.modules_filter_helper");
    }

    private boolean tryToAcquireServingPermit(String moduleOrBackendName, int instance, HttpServletResponse hresponse) throws IOException {
        ModulesFilterHelper modulesFilterHelper = this.getModulesFilterHelper();
        if (!modulesFilterHelper.checkInstanceExists(moduleOrBackendName, instance)) {
            String msg = String.format("Got request to non-configured instance: %d.%s", instance, moduleOrBackendName);
            this.logger.warning(msg);
            hresponse.sendError(502, msg);
            return false;
        }
        if (modulesFilterHelper.checkInstanceStopped(moduleOrBackendName, instance)) {
            String msg = String.format("Got request to stopped instance: %d.%s", instance, moduleOrBackendName);
            this.logger.warning(msg);
            hresponse.sendError(404, msg);
            return false;
        }
        if (!modulesFilterHelper.acquireServingPermit(moduleOrBackendName, instance, true)) {
            String msg = String.format("Got request to module %d.%s but the instance is busy.", instance, moduleOrBackendName);
            this.logger.finer(msg);
            hresponse.sendError(500, msg);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRedirect(HttpServletRequest hrequest, HttpServletResponse hresponse) throws IOException, ServletException {
        String moduleOrBackendName = this.backendServersManager.getServerNameFromPort(hrequest.getServerPort());
        if (moduleOrBackendName == null) {
            moduleOrBackendName = DevAppServerModulesFilter.getHeaderOrParameter(hrequest, "X-AppEngine-BackendName");
        }
        boolean isLoadBalancingModuleInstance = false;
        if (moduleOrBackendName == null) {
            ModulesService modulesService = ModulesServiceFactory.getModulesService();
            moduleOrBackendName = modulesService.getCurrentModule();
            isLoadBalancingModuleInstance = true;
        }
        ModulesFilterHelper modulesFilterHelper = this.getModulesFilterHelper();
        int instance = DevAppServerModulesFilter.getInstanceIdFromRequest(hrequest);
        this.logger.finest(String.format("redirect request to module: %d.%s", instance, moduleOrBackendName));
        if (instance != -1) {
            if (!this.tryToAcquireServingPermit(moduleOrBackendName, instance, hresponse)) {
                return;
            }
        } else {
            if (!modulesFilterHelper.checkModuleExists(moduleOrBackendName)) {
                String msg = String.format("Got request to non-configured module: %s", moduleOrBackendName);
                this.logger.warning(msg);
                hresponse.sendError(502, msg);
                return;
            }
            if (modulesFilterHelper.checkModuleStopped(moduleOrBackendName)) {
                String msg = String.format("Got request to stopped module: %s", moduleOrBackendName);
                this.logger.warning(msg);
                hresponse.sendError(404, msg);
                return;
            }
            instance = modulesFilterHelper.getAndReserveFreeInstance(moduleOrBackendName);
            if (instance == -1) {
                String msg = String.format("all instances of module %s are busy", moduleOrBackendName);
                this.logger.finest(msg);
                hresponse.sendError(500, msg);
                return;
            }
        }
        try {
            if (isLoadBalancingModuleInstance) {
                this.logger.finer(String.format("forwarding request to module: %d.%s", instance, moduleOrBackendName));
                hrequest.setAttribute(MODULE_INSTANCE_REDIRECT_ATTRIBUTE, (Object)instance);
            } else {
                this.logger.finer(String.format("forwarding request to backend: %d.%s", instance, moduleOrBackendName));
                hrequest.setAttribute(BACKEND_REDIRECT_ATTRIBUTE, (Object)moduleOrBackendName);
                hrequest.setAttribute(BACKEND_INSTANCE_REDIRECT_ATTRIBUTE, (Object)instance);
            }
            modulesFilterHelper.forwardToInstance(moduleOrBackendName, instance, hrequest, hresponse);
        }
        finally {
            modulesFilterHelper.returnServingPermit(moduleOrBackendName, instance);
        }
    }

    private void doDirectBackendRequest(HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        int instancePort = hrequest.getServerPort();
        String requestedBackend = this.backendServersManager.getServerNameFromPort(instancePort);
        int requestedInstance = this.backendServersManager.getServerInstanceFromPort(instancePort);
        this.injectApiInfo(requestedBackend, requestedInstance);
        this.doDirectRequest(requestedBackend, requestedInstance, hrequest, hresponse, chain);
    }

    private void doDirectModuleRequest(HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        String requestedModule = this.modulesService.getCurrentModule();
        int requestedInstance = this.getCurrentModuleInstance();
        this.injectApiInfo(null, -1);
        this.doDirectRequest(requestedModule, requestedInstance, hrequest, hresponse, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDirectRequest(String moduleOrBackendName, int instance, HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        this.logger.finest("request to specific module instance: " + instance + "." + moduleOrBackendName);
        if (!this.tryToAcquireServingPermit(moduleOrBackendName, instance, hresponse)) {
            return;
        }
        try {
            this.logger.finest("Acquired serving permit for: " + instance + "." + moduleOrBackendName);
            this.injectApiInfo(null, -1);
            chain.doFilter((ServletRequest)hrequest, (ServletResponse)hresponse);
        }
        finally {
            ModulesFilterHelper modulesFilterHelper = this.getModulesFilterHelper();
            modulesFilterHelper.returnServingPermit(moduleOrBackendName, instance);
        }
    }

    private void doRedirectedBackendRequest(HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        String backendServer = (String)hrequest.getAttribute(BACKEND_REDIRECT_ATTRIBUTE);
        Integer instance = (Integer)hrequest.getAttribute(BACKEND_INSTANCE_REDIRECT_ATTRIBUTE);
        ModulesFilterHelper modulesFilterHelper = this.getModulesFilterHelper();
        int port = modulesFilterHelper.getPort(backendServer, instance);
        LocalEnvironment.setPort(ApiProxy.getCurrentEnvironment().getAttributes(), port);
        this.injectApiInfo(backendServer, instance);
        this.logger.finest("redirected request to backend server instance: " + instance + "." + backendServer);
        chain.doFilter((ServletRequest)hrequest, (ServletResponse)hresponse);
    }

    private void doRedirectedModuleRequest(HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        Integer instance = (Integer)hrequest.getAttribute(MODULE_INSTANCE_REDIRECT_ATTRIBUTE);
        ModulesFilterHelper modulesFilterHelper = this.getModulesFilterHelper();
        String moduleName = this.modulesService.getCurrentModule();
        int port = modulesFilterHelper.getPort(moduleName, instance);
        LocalEnvironment.setInstance(ApiProxy.getCurrentEnvironment().getAttributes(), instance);
        LocalEnvironment.setPort(ApiProxy.getCurrentEnvironment().getAttributes(), port);
        this.injectApiInfo(null, -1);
        this.logger.finest("redirected request to module instance: " + instance + "." + ApiProxy.getCurrentEnvironment().getModuleId() + " " + ApiProxy.getCurrentEnvironment().getVersionId());
        chain.doFilter((ServletRequest)hrequest, (ServletResponse)hresponse);
    }

    private void doStartupRequest(HttpServletRequest hrequest, HttpServletResponse hresponse, FilterChain chain) throws IOException, ServletException {
        int instancePort = hrequest.getServerPort();
        String backendServer = this.backendServersManager.getServerNameFromPort(instancePort);
        int instance = this.backendServersManager.getServerInstanceFromPort(instancePort);
        this.logger.finest("startup request to: " + instance + "." + backendServer);
        this.injectApiInfo(backendServer, instance);
        chain.doFilter((ServletRequest)hrequest, (ServletResponse)hresponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private void injectApiInfo(String backendName, int instance) {
        Map<String, String> portMapping = this.backendServersManager.getPortMapping();
        if (portMapping == null) {
            throw new IllegalStateException("backendServersManager.getPortMapping() is null");
        }
        DevAppServerModulesFilter.injectBackendServiceCurrentApiInfo(backendName, instance, portMapping);
        Map threadLocalAttributes = ApiProxy.getCurrentEnvironment().getAttributes();
        if (!portMapping.isEmpty()) {
            threadLocalAttributes.put("com.google.appengine.dev.backend_controller", this.backendServersManager);
        }
        threadLocalAttributes.put("com.google.appengine.dev.modules_controller", Modules.getInstance());
    }

    public static void injectBackendServiceCurrentApiInfo(String backendName, int backendInstance, Map<String, String> portMapping) {
        Map threadLocalAttributes = ApiProxy.getCurrentEnvironment().getAttributes();
        if (backendInstance != -1) {
            threadLocalAttributes.put("com.google.appengine.instance.id", backendInstance + "");
        }
        if (backendName != null) {
            threadLocalAttributes.put("com.google.appengine.backend.id", backendName);
        }
        threadLocalAttributes.put("com.google.appengine.devappserver.portmapping", portMapping);
    }

    @VisibleForTesting
    static String getHeaderOrParameter(HttpServletRequest request, String key) {
        String value = request.getHeader(key);
        if (value != null) {
            return value;
        }
        if ("GET".equals(request.getMethod())) {
            return request.getParameter(key);
        }
        return null;
    }

    @VisibleForTesting
    static int getInstanceIdFromRequest(HttpServletRequest request) {
        try {
            return Integer.parseInt(DevAppServerModulesFilter.getHeaderOrParameter(request, "X-AppEngine-BackendInstance"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @VisibleForTesting
    static enum RequestType {
        DIRECT_MODULE_REQUEST,
        REDIRECT_REQUESTED,
        DIRECT_BACKEND_REQUEST,
        REDIRECTED_BACKEND_REQUEST,
        REDIRECTED_MODULE_REQUEST,
        STARTUP_REQUEST;

    }
}

