/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.datastore.core.names.ProjectIdAppIdResolver;
import com.google.cloud.datastore.core.names.ProjectIds;
import com.google.cloud.datastore.core.rep.DatabaseRef;

public class SamePartitionAppIdResolver
extends ProjectIdAppIdResolver.ProjectIdResolver {
    private final DatabaseRef databaseRef;

    public SamePartitionAppIdResolver(DatabaseRef databaseRef) {
        this.databaseRef = (DatabaseRef)Preconditions.checkNotNull((Object)databaseRef);
    }

    @Override
    public String toAppId(String projectId) {
        if (projectId.equals(this.databaseRef.projectId())) {
            return this.databaseRef.appId();
        }
        if (this.databaseRef.hasAppPartition()) {
            return ProjectIds.projectIdToApp(this.databaseRef.partitionId(), projectId);
        }
        return projectId;
    }
}

