/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.RepHelper;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.cloud.datastore.core.rep.converter.LegacyMapValueConverterHelper;
import com.google.cloud.datastore.core.rep.converter.UserIdObfuscator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class LegacyMapValueToValueConverter {
    private final UserIdObfuscator userIdObfuscator;

    public LegacyMapValueToValueConverter(UserIdObfuscator userIdObfuscator) {
        this.userIdObfuscator = (UserIdObfuscator)Preconditions.checkNotNull((Object)userIdObfuscator);
    }

    public Value convertValue(Value value) throws InvalidConversionException {
        return this.convertValueHelper(false, value);
    }

    private Value convertValueHelper(boolean isInLegacyMapValue, Value value) throws InvalidConversionException {
        if (value.type() != Value.Type.MAP) {
            return value;
        }
        ImmutableMap<String, Value> map = value.asMap();
        Value typeValue = (Value)map.get((Object)ReservedName.TYPE.asString());
        if (typeValue == null) {
            return value;
        }
        InvalidConversionException.checkConversion(typeValue.type() == Value.Type.STRING, "Field %s is not a string.", new Object[]{ReservedName.TYPE});
        String type = typeValue.asString();
        if (LegacyMapValueConverterHelper.LEGACY_MEANING_WRAPPER_TYPE_NAME_VALUE.asString().equals(type)) {
            InvalidConversionException.checkConversion(!isInLegacyMapValue, "Legacy value map's value is another legacy value map.");
            return this.convertLegacyMeaningWrapperMap(map);
        }
        if (LegacyMapValueConverterHelper.LEGACY_ENTITY_TYPE_NAME_VALUE.asString().equals(type)) {
            return this.convertLegacyEntityMap(map);
        }
        if (LegacyMapValueConverterHelper.LEGACY_USER_TYPE_NAME_VALUE.asString().equals(type)) {
            return this.convertLegacyUserMap(map);
        }
        if (LegacyMapValueConverterHelper.LEGACY_TIMESTAMP_MICROSECONDS_TYPE_NAME_VALUE.asString().equals(type)) {
            return this.convertLegacyTimestampMicrosecondsMap(map);
        }
        return value;
    }

    private Value convertLegacyMeaningWrapperMap(ImmutableMap<String, Value> legacyMeaningWrapperMap) throws InvalidConversionException {
        int numMapEntries = legacyMeaningWrapperMap.size();
        --numMapEntries;
        Value value = (Value)legacyMeaningWrapperMap.get((Object)"value");
        InvalidConversionException.checkConversion(value != null, "Legacy value map has no value for key \"%s\".", "value");
        --numMapEntries;
        value = this.convertValueHelper(true, value);
        Long longMeaning = this.legacyMapGetLongValueRequired("value", (Map<String, Value>)legacyMeaningWrapperMap, "meaning");
        InvalidConversionException.checkConversion(--numMapEntries == 0, "Legacy value map has extraneous entries.");
        return ConverterHelper.valueAddLongMeaning(value, longMeaning);
    }

    private Value convertLegacyEntityMap(ImmutableMap<String, Value> legacyEntityMap) throws InvalidConversionException {
        EntityRef entityRef = this.legacyMapGetEntityRefValueRequired("entity", (Map<String, Value>)legacyEntityMap, ReservedName.NAME.asString());
        HashMap<String, Value> propertyMap = new HashMap<String, Value>((Map<String, Value>)legacyEntityMap);
        propertyMap.remove(ReservedName.NAME.asString());
        propertyMap.remove(ReservedName.TYPE.asString());
        return Value.createEntity(Entity.create(entityRef, (ImmutableMap<String, Value>)ImmutableMap.copyOf(propertyMap)));
    }

    private Value convertLegacyUserMap(ImmutableMap<String, Value> legacyUserMap) throws InvalidConversionException {
        String federatedProvider;
        int numMapEntries = legacyUserMap.size();
        --numMapEntries;
        String email = this.legacyMapGetStringValueRequired("user", (Map<String, Value>)legacyUserMap, "email");
        --numMapEntries;
        String authDomain = this.legacyMapGetStringValueRequired("user", (Map<String, Value>)legacyUserMap, "auth_domain");
        --numMapEntries;
        String obfuscatedGaiaId = this.legacyMapGetStringValueRequired("user", (Map<String, Value>)legacyUserMap, "gaia_id");
        --numMapEntries;
        String federatedIdentity = this.legacyMapGetStringValue("user", (Map<String, Value>)legacyUserMap, "federated_identity");
        if (federatedIdentity != null) {
            --numMapEntries;
        }
        if ((federatedProvider = this.legacyMapGetStringValue("user", (Map<String, Value>)legacyUserMap, "federated_provider")) != null) {
            --numMapEntries;
        }
        InvalidConversionException.checkConversion(numMapEntries == 0, "Legacy user map has extraneous entries.");
        this.userIdObfuscator.checkValidObfuscatedId(obfuscatedGaiaId);
        return Value.createLegacyUser(Value.LegacyUser.create(email, authDomain, obfuscatedGaiaId, federatedIdentity, federatedProvider));
    }

    private Value convertLegacyTimestampMicrosecondsMap(ImmutableMap<String, Value> legacyTimestampMicrosecondsMap) throws InvalidConversionException {
        int numMapEntries = legacyTimestampMicrosecondsMap.size();
        --numMapEntries;
        Long microseconds = this.legacyMapGetLongValueRequired("legacy timestamp", (Map<String, Value>)legacyTimestampMicrosecondsMap, "microseconds");
        InvalidConversionException.checkConversion(--numMapEntries == 0, "Legacy timestamp map has extraneous entries.");
        InvalidConversionException.checkConversion(!RepHelper.isMicrosecondsInTimestampBounds(microseconds), "Legacy timestamp microseconds map represents a time representable by a timestamp.");
        return Value.createLegacyTimestampMicroseconds(microseconds);
    }

    private long legacyMapGetLongValueRequired(String mapFlavor, Map<String, Value> map, String key) throws InvalidConversionException {
        Long boxedLong = this.legacyMapGetLongValue(mapFlavor, map, key);
        InvalidConversionException.checkConversion(boxedLong != null, "Legacy %s map is missing value for key \"%s\".", mapFlavor, key);
        return boxedLong;
    }

    @Nullable
    private Long legacyMapGetLongValue(String mapFlavor, Map<String, Value> map, String key) throws InvalidConversionException {
        Value value = map.get(key);
        if (value == null) {
            return null;
        }
        InvalidConversionException.checkConversion(value.type() == Value.Type.LONG, "Legacy %s map key \"%s\" value is not a integer.", mapFlavor, key);
        return value.asLong();
    }

    private String legacyMapGetStringValueRequired(String mapFlavor, Map<String, Value> map, String key) throws InvalidConversionException {
        String string = this.legacyMapGetStringValue(mapFlavor, map, key);
        InvalidConversionException.checkConversion(string != null, "Legacy %s map is missing value for key \"%s\".", mapFlavor, key);
        return string;
    }

    @Nullable
    private String legacyMapGetStringValue(String mapFlavor, Map<String, Value> map, String key) throws InvalidConversionException {
        Value value = map.get(key);
        if (value == null) {
            return null;
        }
        InvalidConversionException.checkConversion(value.type() == Value.Type.STRING, "Legacy %s map key \"%s\" value is not a string.", mapFlavor, key);
        return value.asString();
    }

    @Nullable
    private EntityRef legacyMapGetEntityRefValueRequired(String mapFlavor, Map<String, Value> map, String key) throws InvalidConversionException {
        Value value = map.get(key);
        InvalidConversionException.checkConversion(value != null, "Legacy %s map is missing value for key \"%s\".", mapFlavor, key);
        InvalidConversionException.checkConversion(value.type() == Value.Type.ENTITY_REF, "Legacy %s map key \"%s\" value type \"%s\" is not an entity key.", new Object[]{mapFlavor, key, value.type()});
        return value.asEntityRef();
    }
}

