/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.EntityRefConverter;
import com.google.cloud.datastore.core.rep.converter.ValueConverter;
import java.util.Map;

public class EntityConverter {
    private EntityConverter() {
    }

    public static com.google.cloud.datastore.core.rep.proto.Entity toProto(Entity rep) {
        return com.google.cloud.datastore.core.rep.proto.Entity.newBuilder().setRef(EntityRefConverter.toProto(rep.ref())).putAllProperties(Maps.transformValues(rep.propertyMap(), ValueConverter::toProto)).build();
    }

    public static Entity toRep(com.google.cloud.datastore.core.rep.proto.Entity proto) {
        Preconditions.checkArgument((boolean)proto.hasRef());
        EntityRef ref = EntityRefConverter.toRep(proto.getRef());
        ImmutableMap.Builder properties = ImmutableMap.builderWithExpectedSize((int)proto.getPropertiesCount());
        for (Map.Entry<String, com.google.cloud.datastore.core.rep.proto.Value> entry : proto.getPropertiesMap().entrySet()) {
            properties.put((Object)entry.getKey(), (Object)ValueConverter.toRep(entry.getValue()));
        }
        return Entity.create(ref, (ImmutableMap<String, Value>)properties.build());
    }
}

