/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.appengine.repackaged.com.google.common.time.Instants;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityChange;
import com.google.cloud.datastore.core.rep.converter.EntityConverter;
import com.google.cloud.datastore.core.rep.proto.EntityChange;
import java.time.Instant;
import javax.annotation.Nullable;

public class EntityChangeConverter {
    private EntityChangeConverter() {
    }

    public static com.google.cloud.datastore.core.rep.proto.EntityChange toProto(EntityChange rep) {
        return EntityChangeConverter.toProto(rep, EntityChangeConverter.toMetadataProto(rep));
    }

    public static com.google.cloud.datastore.core.rep.proto.EntityChange toProto(EntityChange.CommittedEntityChange rep) {
        return EntityChangeConverter.toProto(rep.change(), EntityChangeConverter.toMetadataProto(rep));
    }

    private static com.google.cloud.datastore.core.rep.proto.EntityChange toProto(EntityChange entityChange, EntityChange.Metadata metadataProto) {
        EntityChange.Builder builder = com.google.cloud.datastore.core.rep.proto.EntityChange.newBuilder().setMetadata(metadataProto);
        switch (entityChange.type()) {
            case INSERT: {
                return builder.setAfter(EntityConverter.toProto(entityChange.insert())).build();
            }
            case DELETE: {
                return builder.setBefore(EntityConverter.toProto(entityChange.delete().entity())).build();
            }
            case UPDATE: {
                return builder.setBefore(EntityConverter.toProto(entityChange.update().before().entity())).setAfter(EntityConverter.toProto(entityChange.update().after())).build();
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static EntityChange.Metadata toMetadataProto(EntityChange entityChange) {
        EntityChange.Metadata.Builder builder = EntityChange.Metadata.newBuilder();
        entityChange.createTime().ifPresent(t -> builder.setCreateTime(Instants.toEpochMicros((Instant)t)));
        entityChange.beforeUpdateTime().ifPresent(t -> builder.setBeforeUpdateTime(Instants.toEpochMicros((Instant)t)));
        return builder.build();
    }

    private static EntityChange.Metadata toMetadataProto(EntityChange.CommittedEntityChange committedChange) {
        EntityChange.Metadata.Builder builder = EntityChange.Metadata.newBuilder();
        committedChange.createTime().ifPresent(t -> builder.setCreateTime(Instants.toEpochMicros((Instant)t)));
        committedChange.change().beforeUpdateTime().ifPresent(t -> builder.setBeforeUpdateTime(Instants.toEpochMicros((Instant)t)));
        return builder.setAfterUpdateTime(Instants.toEpochMicros((Instant)committedChange.commitTime())).build();
    }

    public static EntityChange toRep(com.google.cloud.datastore.core.rep.proto.EntityChange proto) {
        if (!proto.hasBefore() && proto.hasAfter()) {
            Entity after = EntityConverter.toRep(proto.getAfter());
            return EntityChange.ofInsert(after);
        }
        if (proto.hasBefore() && proto.hasAfter()) {
            Entity before = EntityConverter.toRep(proto.getBefore());
            Entity after = EntityConverter.toRep(proto.getAfter());
            return EntityChange.of(EntityChangeConverter.toBefore(before, proto.getMetadata()), after);
        }
        if (proto.hasBefore() && !proto.hasAfter()) {
            Entity before = EntityConverter.toRep(proto.getBefore());
            return EntityChange.of(EntityChangeConverter.toBefore(before, proto.getMetadata()), null);
        }
        throw new IllegalArgumentException("EntityChange must have either `before` or `after` set");
    }

    private static EntityChange.VersionedEntity toBefore(Entity before, EntityChange.Metadata metadata) {
        return EntityChange.VersionedEntity.of(before, EntityChangeConverter.nullEpochTime(metadata.getCreateTime()), EntityChangeConverter.nullEpochTime(metadata.getBeforeUpdateTime()));
    }

    @Nullable
    private static Instant nullEpochTime(long time) {
        return time == 0L ? null : Instants.ofEpochMicros((long)time);
    }
}

