/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.appengine.repackaged.com.google.protobuf.Timestamp;
import com.google.appengine.repackaged.com.google.protobuf.util.JavaTimeConversions;
import com.google.cloud.datastore.core.rep.backups.Backup;
import com.google.cloud.datastore.core.rep.converter.BackupRefConverter;
import com.google.cloud.datastore.core.rep.converter.EntityRefConverter;
import com.google.cloud.datastore.core.rep.proto.Backup;
import java.time.Instant;

public final class BackupConverter {
    private BackupConverter() {
    }

    private static Backup.Stats toProto(Backup.Stats stats) {
        return Backup.Stats.newBuilder().setSizeBytes(stats.sizeBytes()).setEntityCount(stats.entityCount()).build();
    }

    private static Backup.State toProto(Backup.State state) {
        switch (state) {
            case INITIALIZED: {
                return Backup.State.INITIALIZED;
            }
            case UPLOADING: {
                return Backup.State.UPLOADING;
            }
            case FINALIZED: {
                return Backup.State.FINALIZED;
            }
        }
        throw new AssertionError((Object)"Unreachable code.");
    }

    public static Backup toProto(com.google.cloud.datastore.core.rep.backups.Backup backup) {
        Backup.Builder builder = Backup.newBuilder().setRef(BackupRefConverter.toProto(backup.ref())).setDatabaseRef(EntityRefConverter.toProto(backup.databaseRef())).setCreateTime(JavaTimeConversions.toProtoTimestamp((Instant)backup.createTime())).setExpireTime(JavaTimeConversions.toProtoTimestamp((Instant)backup.expireTime())).setEtag(backup.etag()).setState(BackupConverter.toProto(backup.state()));
        if (backup.stats() != null) {
            builder.setStats(BackupConverter.toProto(backup.stats()));
        }
        if (backup.metadataBlobPath() != null) {
            builder.setMetadataBlobPath(backup.metadataBlobPath());
        }
        return builder.build();
    }

    private static Backup.Stats toRep(Backup.Stats proto) {
        return Backup.Stats.builder().entityCount(proto.getEntityCount()).sizeBytes(proto.getSizeBytes()).build();
    }

    private static Backup.State toRep(Backup.State proto) {
        switch (proto) {
            case INITIALIZED: {
                return Backup.State.INITIALIZED;
            }
            case FINALIZED: {
                return Backup.State.FINALIZED;
            }
            case UPLOADING: {
                return Backup.State.UPLOADING;
            }
            case BACKUP_STATE_UNSPECIFIED: 
            case UNRECOGNIZED: {
                throw new IllegalArgumentException("Unspecified or unrecognized backup state.");
            }
        }
        throw new AssertionError((Object)"Unreachable code.");
    }

    public static com.google.cloud.datastore.core.rep.backups.Backup toRep(Backup proto) {
        Backup.Builder builder = com.google.cloud.datastore.core.rep.backups.Backup.builder().ref(BackupRefConverter.toRep(proto.getRef())).databaseRef(EntityRefConverter.toRep(proto.getDatabaseRef())).createTime(JavaTimeConversions.toJavaInstant((Timestamp)proto.getCreateTime())).expireTime(JavaTimeConversions.toJavaInstant((Timestamp)proto.getExpireTime())).etag(proto.getEtag()).state(BackupConverter.toRep(proto.getState()));
        if (proto.hasStats()) {
            builder.stats(BackupConverter.toRep(proto.getStats()));
        }
        if (!proto.getMetadataBlobPath().isEmpty()) {
            builder.metadataBlobPath(proto.getMetadataBlobPath());
        }
        return builder.build();
    }
}

