/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.cloud.datastore.core.rep.AutoValue_SingleFieldIndexingRule;
import com.google.cloud.datastore.core.rep.SingleFieldIndex;
import com.google.cloud.datastore.core.rep.SingleFieldRef;
import com.google.cloud.datastore.core.rep.WorkflowState;
import java.time.Instant;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class SingleFieldIndexingRule {
    private static final long DATABASE_RULE_ID = 0L;
    public static final SingleFieldIndexingRule EMPTY_DATABASE_RULE = SingleFieldIndexingRule.createDatabaseRule((Map<SingleFieldIndex.Mode, WorkflowState>)ImmutableMap.of(), Instant.EPOCH);

    public abstract SingleFieldRef ref();

    @Nullable
    public abstract Long id();

    public abstract WorkflowState state();

    @Nullable
    public abstract Instant updateTime();

    public abstract ImmutableMap<SingleFieldIndex.Mode, SingleFieldIndex> indexes();

    public abstract boolean error();

    @Memoized
    public ImmutableMap<SingleFieldIndex.Mode, WorkflowState> indexStates() {
        ImmutableMap.Builder results = ImmutableMap.builder();
        for (SingleFieldIndex index : this.indexes().values()) {
            results.put((Object)index.mode(), (Object)index.workflowState());
        }
        return results.build();
    }

    public static SingleFieldIndexingRule createDatabaseRule(Map<SingleFieldIndex.Mode, WorkflowState> modes, @Nullable Instant updateTime) {
        ImmutableMap.Builder indexes = ImmutableMap.builder();
        for (Map.Entry<SingleFieldIndex.Mode, WorkflowState> entry : modes.entrySet()) {
            SingleFieldIndex.Mode mode = entry.getKey();
            WorkflowState state = entry.getValue();
            indexes.put((Object)mode, (Object)SingleFieldIndex.createDatabaseIndex(mode, state, updateTime));
        }
        return SingleFieldIndexingRule.create(SingleFieldRef.database(), 0L, WorkflowState.SERVING, updateTime, (ImmutableMap<SingleFieldIndex.Mode, SingleFieldIndex>)indexes.build());
    }

    public static SingleFieldIndexingRule createDatabaseRuleFromIndexes(Map<SingleFieldIndex.Mode, SingleFieldIndex> indexes, @Nullable Instant updateTime) {
        return SingleFieldIndexingRule.create(SingleFieldRef.database(), 0L, WorkflowState.SERVING, updateTime, (ImmutableMap<SingleFieldIndex.Mode, SingleFieldIndex>)ImmutableMap.copyOf(indexes));
    }

    public static SingleFieldIndexingRule create(SingleFieldRef ref, @Nullable Long id, WorkflowState state, @Nullable Instant updateTime, ImmutableMap<SingleFieldIndex.Mode, SingleFieldIndex> indexes) {
        return SingleFieldIndexingRule.create(ref, id, state, updateTime, indexes, false);
    }

    public static SingleFieldIndexingRule create(SingleFieldRef ref, @Nullable Long id, WorkflowState state, @Nullable Instant updateTime, ImmutableMap<SingleFieldIndex.Mode, SingleFieldIndex> indexes, boolean error) {
        Preconditions.checkArgument((!error || state.finalizing() ? 1 : 0) != 0, (Object)"rules must not have errors unless they are in a finalizing state");
        if (ref.isDatabase()) {
            Preconditions.checkArgument(((Long)Preconditions.checkNotNull((Object)id) == 0L ? 1 : 0) != 0, (Object)"database-level rule must have id set to 0");
            Preconditions.checkArgument((state == WorkflowState.SERVING ? 1 : 0) != 0, (Object)"database-level rule must be in SERVING state");
            for (SingleFieldIndex index : indexes.values()) {
                Preconditions.checkArgument(((Long)Preconditions.checkNotNull((Object)index.id()) == index.mode().idWhenDatabaseDefault ? 1 : 0) != 0, (Object)"database-level rule must use fixed IDs for indexes");
            }
        }
        for (Map.Entry entry : indexes.entrySet()) {
            Preconditions.checkArgument((entry.getKey() == ((SingleFieldIndex)entry.getValue()).mode() ? 1 : 0) != 0, (Object)"incorrect index map key");
            Preconditions.checkArgument((boolean)((SingleFieldIndex)entry.getValue()).ref().equals(ref), (Object)"incorrect index field ref");
        }
        return new AutoValue_SingleFieldIndexingRule(ref, id, state, updateTime, indexes, error);
    }

    public SingleFieldIndexingRule withIndexes(ImmutableMap<SingleFieldIndex.Mode, SingleFieldIndex> indexes) {
        return SingleFieldIndexingRule.create(this.ref(), this.id(), this.state(), this.updateTime(), indexes, this.error());
    }

    @Nullable
    @Memoized
    public Instant lastUpdated() {
        Instant maxUpdateTime = Instant.EPOCH;
        if (this.updateTime() == null || this.updateTime().equals(Instant.EPOCH)) {
            return null;
        }
        if (this.updateTime().isAfter(maxUpdateTime)) {
            maxUpdateTime = this.updateTime();
        }
        for (SingleFieldIndex index : this.indexes().values()) {
            if (index.updateTime() == null) {
                return null;
            }
            if (!index.updateTime().isAfter(maxUpdateTime)) continue;
            maxUpdateTime = index.updateTime();
        }
        return maxUpdateTime;
    }
}

