/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_ReadResult;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.time.Instant;
import javax.annotation.Nullable;

@AutoValue
public abstract class ReadResult {
    public static ReadResult create(Entity repEntity, @Nullable Cursor cursor, long createVersion, long updateVersion) {
        return ReadResult.create(repEntity, cursor, createVersion, updateVersion, null);
    }

    public static ReadResult create(Entity entity, @Nullable Cursor cursor, long createVersion, long updateVersion, @Nullable Instant readTime) {
        return ReadResult.builder().entityRef(entity.ref()).repEntity(entity).cursor(cursor).createVersion(createVersion).updateVersion(updateVersion).readTime(readTime).build();
    }

    public static ReadResult createNoVersion(Entity repEntity, @Nullable Cursor cursor) {
        return ReadResult.create(repEntity, cursor, -1L, -1L);
    }

    public static ReadResult createLegacy(EntityRef entityRef, @Nullable Entity repEntity, @Nullable Cursor cursor, long createVersion, long updateVersion) {
        return ReadResult.builder().entityRef((EntityRef)Preconditions.checkNotNull((Object)entityRef)).repEntity(repEntity).cursor(cursor).createVersion(createVersion).updateVersion(updateVersion).readTime(null).build();
    }

    public static ReadResult createNoVersionLegacy(EntityRef entityRef, @Nullable Entity repEntity, @Nullable Cursor cursor) {
        return ReadResult.createLegacy(entityRef, repEntity, cursor, -1L, -1L);
    }

    public static ReadResult createCursor(Cursor cursor) {
        return ReadResult.createCursor(cursor, -1L, -1L);
    }

    public static ReadResult createCursor(Cursor cursor, long createVersion, long updateVersion) {
        return ReadResult.builder().cursor((Cursor)Preconditions.checkNotNull((Object)cursor)).createVersion(createVersion).updateVersion(updateVersion).build();
    }

    public static ReadResult createMissing(EntityRef entityRef, long version) {
        return ReadResult.createMissing(entityRef, version, null);
    }

    public static ReadResult createMissing(EntityRef entityRef, long version, @Nullable Instant readTime) {
        return ReadResult.builder().entityRef((EntityRef)Preconditions.checkNotNull((Object)entityRef)).missingEntityReason(MissingEntityReason.MISSING).createVersion(-1L).updateVersion(version).readTime(readTime).build();
    }

    public static ReadResult createMissingNoVersion(EntityRef entityRef) {
        return ReadResult.createMissing(entityRef, -1L);
    }

    public static ReadResult createDeferred(EntityRef entityRef) {
        return ReadResult.builder().entityRef((EntityRef)Preconditions.checkNotNull((Object)entityRef)).createVersion(-1L).updateVersion(-1L).missingEntityReason(MissingEntityReason.DEFERRED).build();
    }

    public ReadResult withMask(PropertyMask propertyMask) {
        Preconditions.checkState((boolean)this.exists());
        if (propertyMask.equals(PropertyMask.FULL)) {
            return this;
        }
        Preconditions.checkNotNull((Object)this.repEntity());
        Entity repEntity = this.repEntity() == null ? null : propertyMask.mask(this.repEntity());
        return this.toBuilder().sideChannelEntityProto(null).repEntity(repEntity).build();
    }

    public ReadResult withSideChannelEntity(OnestoreEntity.EntityProto sideChannelEntity) {
        return this.toBuilder().sideChannelEntityProto(sideChannelEntity).build();
    }

    @Nullable
    public abstract EntityRef entityRef();

    @Nullable
    public abstract OnestoreEntity.EntityProto sideChannelEntityProto();

    public boolean exists() {
        return this.repEntity() != null || this.sideChannelEntityProto() != null;
    }

    @Nullable
    public abstract Entity repEntity();

    @Nullable
    public abstract MissingEntityReason missingEntityReason();

    public abstract long createVersion();

    public abstract long updateVersion();

    @Nullable
    public abstract Instant readTime();

    @Nullable
    public abstract Cursor cursor();

    static Builder builder() {
        return new AutoValue_ReadResult.Builder();
    }

    abstract Builder toBuilder();

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        public abstract ReadResult build();

        public abstract Builder entityRef(@Nullable EntityRef var1);

        public abstract Builder sideChannelEntityProto(@Nullable OnestoreEntity.EntityProto var1);

        public abstract Builder repEntity(@Nullable Entity var1);

        public abstract Builder missingEntityReason(@Nullable MissingEntityReason var1);

        public abstract Builder createVersion(long var1);

        public abstract Builder updateVersion(long var1);

        public abstract Builder readTime(@Nullable Instant var1);

        public abstract Builder cursor(@Nullable Cursor var1);
    }

    public static enum MissingEntityReason {
        MISSING,
        DEFERRED;

    }
}

