/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoOneOf_EntityDiff_PropertyDiff;
import com.google.cloud.datastore.core.rep.AutoValue_EntityDiff;
import com.google.cloud.datastore.core.rep.AutoValue_EntityDiff_ValueDiff;
import com.google.cloud.datastore.core.rep.Value;
import javax.annotation.Nullable;

@AutoValue
public abstract class EntityDiff {
    public abstract ImmutableMap<String, PropertyDiff> propertyDiffs();

    @Nullable
    public static EntityDiff create(ImmutableMap<String, PropertyDiff> propertyDiffs) {
        return propertyDiffs.isEmpty() ? null : new AutoValue_EntityDiff(propertyDiffs);
    }

    static EntityDiff empty() {
        return new AutoValue_EntityDiff((ImmutableMap<String, PropertyDiff>)ImmutableMap.of());
    }

    @AutoValue
    public static abstract class ValueDiff {
        @Nullable
        public abstract Value before();

        @Nullable
        public abstract Value after();

        public static ValueDiff create(Value newValue) {
            return new AutoValue_EntityDiff_ValueDiff(null, (Value)Preconditions.checkNotNull((Object)newValue));
        }

        public static ValueDiff update(Value oldValue, Value newValue) {
            return new AutoValue_EntityDiff_ValueDiff((Value)Preconditions.checkNotNull((Object)oldValue), (Value)Preconditions.checkNotNull((Object)newValue));
        }

        public static ValueDiff delete(Value oldValue) {
            return new AutoValue_EntityDiff_ValueDiff((Value)Preconditions.checkNotNull((Object)oldValue), null);
        }
    }

    @AutoOneOf(value=Type.class)
    public static abstract class PropertyDiff {
        public abstract Type type();

        public abstract ValueDiff value();

        public abstract EntityDiff nested();

        public static PropertyDiff ofValue(ValueDiff diff) {
            return AutoOneOf_EntityDiff_PropertyDiff.value(diff);
        }

        public static PropertyDiff ofNested(EntityDiff diff) {
            return AutoOneOf_EntityDiff_PropertyDiff.nested(diff);
        }

        public static PropertyDiff create(Value newValue) {
            return PropertyDiff.ofValue(ValueDiff.create(newValue));
        }

        public static PropertyDiff update(Value oldValue, Value newValue) {
            return PropertyDiff.ofValue(ValueDiff.update(oldValue, newValue));
        }

        public static PropertyDiff delete(Value oldValue) {
            return PropertyDiff.ofValue(ValueDiff.delete(oldValue));
        }

        public static enum Type {
            VALUE,
            NESTED;

        }
    }
}

