/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.cloud.datastore.admininternal.Filter;
import com.google.cloud.datastore.core.rep.$AutoValue_CompositeIndex;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.IndexState;
import com.google.cloud.datastore.core.rep.WorkflowState;
import java.time.Instant;
import javax.annotation.Nullable;

@AutoValue
public abstract class CompositeIndex {
    public static final ImmutableMultimap<Filter.StateFilter, WorkflowState> STATE_FILTER_VISIBILITY = new ImmutableMultimap.Builder().putAll((Object)Filter.StateFilter.USER_VISIBLE, (Object[])new WorkflowState[]{WorkflowState.CREATED, WorkflowState.ENABLING, WorkflowState.SERVING}).putAll((Object)Filter.StateFilter.SHOW_NON_SERVING, (Object[])new WorkflowState[]{WorkflowState.CREATED, WorkflowState.ENABLING, WorkflowState.SERVING, WorkflowState.NON_SERVING}).putAll((Object)Filter.StateFilter.ALL, (Object[])WorkflowState.values()).putAll((Object)Filter.StateFilter.STATE_FILTER_UNSPECIFIED, (Object[])WorkflowState.values()).build();
    private static final ImmutableSet<WorkflowState> WRITING_STATES = ImmutableSet.of((Object)((Object)WorkflowState.ENABLING), (Object)((Object)WorkflowState.SERVING), (Object)((Object)WorkflowState.NON_SERVING));

    public abstract IndexDef definition();

    public abstract long id();

    @Nullable
    public abstract Instant updateTime();

    public abstract WorkflowState workflowState();

    public abstract boolean error();

    @Memoized
    public IndexState state() {
        return IndexState.create(this.workflowState(), this.error());
    }

    public boolean writing() {
        return WRITING_STATES.contains((Object)this.workflowState());
    }

    public abstract StorageVersion storageVersion();

    public CompositeIndex withState(IndexState indexState) {
        if (indexState.equals(this.state())) {
            return this;
        }
        if (!indexState.workflowState().equals((Object)this.state().workflowState())) {
            return this.toBuilder().indexState(indexState).updateTime(null).build();
        }
        return this.toBuilder().indexState(indexState).build();
    }

    public CompositeIndex withId(long id) {
        return this.toBuilder().id(id).build();
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.NONE)
    public CompositeIndex withDefinition(IndexDef indexDef) {
        return this.toBuilder().definition(indexDef).build();
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.NONE)
    public CompositeIndex withStorageVersion(StorageVersion storageVersion) {
        return this.toBuilder().storageVersion(storageVersion).build();
    }

    public CompositeIndex withUpdateTime(Instant updateTime) {
        return this.toBuilder().updateTime(updateTime).build();
    }

    public CompositeIndex withoutUpdateTime() {
        return this.toBuilder().updateTime(null).build();
    }

    protected abstract Builder toBuilder();

    public static Builder builder() {
        return new $AutoValue_CompositeIndex.Builder().storageVersion(StorageVersion.V1).error(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder definition(IndexDef var1);

        public abstract Builder id(long var1);

        protected abstract Builder error(boolean var1);

        protected abstract Builder workflowState(WorkflowState var1);

        public Builder workflowState(WorkflowState workflowState, boolean error) {
            return this.workflowState(workflowState).error(error);
        }

        public Builder indexState(IndexState indexState) {
            return this.workflowState(indexState.workflowState()).error(indexState.error());
        }

        public abstract Builder storageVersion(StorageVersion var1);

        public abstract Builder updateTime(@Nullable Instant var1);

        abstract CompositeIndex autoBuild();

        public CompositeIndex build() {
            CompositeIndex index = this.autoBuild();
            Preconditions.checkState((!index.error() || index.state().workflowState().finalizing() ? 1 : 0) != 0, (Object)"indexes must not have errors unless they are in a finalizing state");
            return index;
        }
    }

    public static enum StorageVersion {
        V1,
        V2;

    }

    @Deprecated
    public static enum State {
        ENABLING,
        ENABLED,
        DELETING,
        DISABLING,
        DISABLED,
        ERROR,
        CREATED,
        NON_SERVING;

    }
}

