/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.config;

import com.google.appengine.repackaged.com.google.common.base.Suppliers;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.config.proto1api.DatastoreCustomizableConfigPb;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class DatastoreCustomizableConfigUtils {
    private static final int UNBOUNDED = 0;
    public static final Supplier<DatastoreCustomizableConfigPb.DatastoreCustomizableConfig> PERMISSIVE_INSTANCE = Suppliers.memoize(DatastoreCustomizableConfigUtils::createPermissiveInstance);
    public static final Supplier<DatastoreCustomizableConfigPb.DatastoreCustomizableConfig> STRICT_VALIDATION_INSTANCE = Suppliers.memoize(DatastoreCustomizableConfigUtils::createStrictValidationInstance);

    private DatastoreCustomizableConfigUtils() {
    }

    public static DatastoreCustomizableConfigPb.DatastoreCustomizableConfig getCustomizableConfig(Config.DatastoreConfig config, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) {
        if (configOverrides == null) {
            return config.getCustomizableConfig();
        }
        return config.getCustomizableConfig().toBuilder().mergeFrom(configOverrides).build();
    }

    public static boolean getEnableAppEngV3ValidateUnindexedValueEntityProto(Config.DatastoreConfig config, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) {
        if (configOverrides != null && configOverrides.hasOverrideAppEngV3ValidateUnindexedValueEntityProto()) {
            return configOverrides.getOverrideAppEngV3ValidateUnindexedValueEntityProto();
        }
        return config.getEnableAppEngV3ValidateUnindexedValueEntityProto();
    }

    private static DatastoreCustomizableConfigPb.DatastoreCustomizableConfig createPermissiveInstance() {
        return DatastoreCustomizableConfigPb.DatastoreCustomizableConfig.newBuilder().setAllowCollectionGroupUpdateField(true).setEnableAppEngV3ValidateEntityRefIntraPartition(false).setEnableAppEngV3ValidateGeoPoint(false).setEnableAppEngV3ValidateKeyNameUtf8(false).setEnableAppEngV3ValidateKindUtf8(false).setEnableAppEngV3ValidateValueStringUtf8(false).setEnableAppEngV3ValidateValueStringUtf8WithMeaning(false).setEnableAppEngV3ValidatorValidateValueMeaningMatchesType(false).setEnableMegastoreEntityV3SideChannelRead(true).setEnableValidateGeoPointSameMeaning(false).setDisableV1ProjectAppIdResolution(false).setMaxEntityKeySizeBytes(0).setMaxIndexEntriesCountPerEntity(0).setMaxIndexEntriesBytesPerEntity(0).setMaxNaturalEntitySizeBytes(0).setQueryExhaustionSchedulingDelayMs(0).setQueryExhaustionSchedulingDelayLinearBackoffMultiplier(0.0).setQuerySeekLimit(Integer.MAX_VALUE).setQuerySeekThreshold(Integer.MAX_VALUE).setOverrideAppEngV3ValidateUnindexedValueEntityProto(false).build();
    }

    private static DatastoreCustomizableConfigPb.DatastoreCustomizableConfig createStrictValidationInstance() {
        return DatastoreCustomizableConfigPb.DatastoreCustomizableConfig.newBuilder().setAllowCollectionGroupUpdateField(false).setEnableAppEngV3ValidateEntityRefIntraPartition(true).setEnableAppEngV3ValidateGeoPoint(true).setEnableAppEngV3ValidateKeyNameUtf8(true).setEnableAppEngV3ValidateKindUtf8(true).setEnableAppEngV3ValidateValueStringUtf8(true).setEnableAppEngV3ValidateValueStringUtf8WithMeaning(true).setEnableAppEngV3ValidatorValidateValueMeaningMatchesType(true).setEnableValidateGeoPointSameMeaning(true).setEnableMegastoreEntityV3SideChannelRead(true).setDisableV1ProjectAppIdResolution(false).setOverrideAppEngV3ValidateUnindexedValueEntityProto(true).build();
    }
}

