/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.base.Utf8;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.primitives.Booleans;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.type.LatLng;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.names.ProjectIds;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.cloud.datastore.core.rep.converter.UserIdObfuscator;
import com.google.cloud.datastore.logs.ProblemCode;
import com.google.storage.onestore.v3.OnestoreEntity;

public class AppEngV3IndexValueToRepConverter {
    private final Config.DatastoreConfig config;
    private final UserIdObfuscator obfuscator;

    public AppEngV3IndexValueToRepConverter(Config.DatastoreConfig config, UserIdObfuscator obfuscator) {
        this.config = config;
        this.obfuscator = obfuscator;
    }

    public IndexValue convertIndexValue(String propertyName, OnestoreEntity.PropertyValue v3Value) throws InvalidConversionException {
        this.validateV3PropertyValueUnion(propertyName, v3Value);
        if (v3Value.hasBooleanValue()) {
            return IndexValue.createBoolean(v3Value.isBooleanValue());
        }
        if (v3Value.hasInt64Value()) {
            return IndexValue.createNumberLong(v3Value.getInt64Value());
        }
        if (v3Value.hasDoubleValue()) {
            return IndexValue.createNumberDouble(v3Value.getDoubleValue());
        }
        if (v3Value.hasStringValue()) {
            return IndexValue.createDatastoreUntruncatedBytesWithStringNaturalSize(ByteString.copyFrom((byte[])v3Value.getStringValueAsBytes()));
        }
        if (v3Value.hasUserValue()) {
            return IndexValue.createLegacyUser(this.convertLegacyUserValue(v3Value.getUserValue()));
        }
        if (v3Value.hasPointValue()) {
            return IndexValue.createGeoPoint(LatLng.newBuilder().setLatitude(v3Value.getPointValue().getX()).setLongitude(v3Value.getPointValue().getY()).build());
        }
        if (v3Value.hasReferenceValue()) {
            return IndexValue.createDatastoreEntityRef(this.convertReferenceValue(v3Value.getReferenceValue()));
        }
        return IndexValue.NULL;
    }

    private Value.LegacyUser convertLegacyUserValue(OnestoreEntity.PropertyValue.UserValue user) throws InvalidConversionException {
        this.validateUserValue(user);
        return Value.LegacyUser.create(user.getEmail(), user.getAuthDomain(), user.getGaiaid() == 0L ? user.getObfuscatedGaiaid() : this.obfuscator.obfuscate(user.getGaiaid()), user.hasFederatedIdentity() ? user.getFederatedIdentity() : null, user.hasFederatedProvider() ? user.getFederatedProvider() : null);
    }

    private IndexValue.EntityRef convertReferenceValue(OnestoreEntity.PropertyValue.ReferenceValue v3Ref) throws InvalidConversionException {
        this.validateAppId(v3Ref.getApp());
        DatabaseRef dbRef = DatabaseRef.createForApp(v3Ref.getApp(), v3Ref.getDatabaseId());
        IndexValue namespaceId = IndexValue.EMPTY_STRING;
        if (!Strings.isNullOrEmpty((String)v3Ref.getNameSpace())) {
            namespaceId = IndexValue.createString(false, v3Ref.getNameSpace());
        }
        ImmutableList.Builder segments = ImmutableList.builder();
        for (OnestoreEntity.PropertyValue.ReferenceValuePathElement element : v3Ref.pathElements()) {
            segments.add((Object)IndexValue.createString(false, ConverterHelper.convertBytesToStringUnchecked(element.getTypeAsBytes())));
            if (element.hasId()) {
                segments.add((Object)IndexValue.createNumberLong(element.getId()));
                continue;
            }
            if (!element.hasName()) continue;
            segments.add((Object)IndexValue.createString(false, ConverterHelper.convertBytesToStringUnchecked(element.getNameAsBytes())));
        }
        return IndexValue.EntityRef.create(dbRef, namespaceId, IndexValue.createArray(false, (ImmutableList<IndexValue>)segments.build()));
    }

    private void validateV3PropertyValueUnion(String propertyName, OnestoreEntity.PropertyValue value) throws InvalidConversionException {
        int numValues = Booleans.countTrue((boolean[])new boolean[]{value.hasInt64Value(), value.hasStringValue(), value.hasBooleanValue(), value.hasDoubleValue(), value.hasPointValue(), value.hasUserValue(), value.hasReferenceValue()});
        InvalidConversionException.checkConversion(numValues <= 1, "The value \"%s\" has multiple types set.", propertyName);
    }

    private void validateUserValue(OnestoreEntity.PropertyValue.UserValue v3UserValue) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!v3UserValue.hasNickname(), "nickname is not supported");
        try {
            if (v3UserValue.hasObfuscatedGaiaid()) {
                this.obfuscator.unobfuscate(v3UserValue.getObfuscatedGaiaid());
            }
        }
        catch (InvalidConversionException e) {
            throw new InvalidConversionException("Invalid user id in user value.", e);
        }
        this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.email", v3UserValue.getEmailAsBytes());
        this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.authDomain", v3UserValue.getAuthDomainAsBytes());
        if (v3UserValue.hasFederatedIdentity()) {
            this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.federatedIdentity", v3UserValue.getFederatedIdentityAsBytes());
        }
        if (v3UserValue.hasFederatedProvider()) {
            this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.federatedProvider", v3UserValue.getFederatedProviderAsBytes());
        }
    }

    private void validateUserFieldBytesAreValidUtf8(String fieldName, byte[] bytes) throws InvalidConversionException {
        if (!this.config.getEnableAppEngV3ValidateUserFieldValuesUtf8()) {
            return;
        }
        InvalidConversionException.checkConversion(Utf8.isWellFormed((byte[])bytes), ProblemCode.USER_FIELD_VALUE_NOT_UTF8, "Non-UTF-8 bytes in user field %s.", fieldName);
    }

    protected void validateAppId(String appId) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!appId.isEmpty(), "The app id is the empty string.");
        InvalidConversionException.checkConversion(ProjectIds.isValidAppId(appId), "\"%s\" is an invalid app id.", appId);
    }
}

