/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.ByteBuffers;
import com.google.appengine.repackaged.com.google.common.geometry.EncodedInts;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.math.IntMath;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.AbstractList;
import java.util.List;

@GwtIncompatible(value="Uses ByteBuffer")
abstract class EncodedS2PointVector
extends AbstractList<S2Point> {
    private static final int FORMAT_FAST = 0;
    private static final int FORMAT_COMPACT = 1;
    private static final int ENCODING_FORMAT_BITS = 3;
    private static final byte ENCODING_FORMAT_MASK = 7;
    private static final int SIZEOF_S2POINT = 24;

    EncodedS2PointVector() {
    }

    static EncodedS2PointVector create(ByteBuffer buffer) throws IOException {
        FastEncodedS2PointVector vector;
        Preconditions.checkArgument((buffer.remaining() >= 1 ? 1 : 0) != 0);
        ByteBuffer data = buffer.order() == ByteOrder.LITTLE_ENDIAN ? buffer : buffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        int format = data.get(data.position()) & 7;
        switch (format) {
            case 0: {
                vector = new FastEncodedS2PointVector(data);
                break;
            }
            case 1: {
                throw new IllegalArgumentException("Encoding \"COMPACT\" is not yet supported.");
            }
            default: {
                throw new IllegalArgumentException("Unknown encoding.");
            }
        }
        buffer.position(data.position());
        return vector;
    }

    public static void encode(List<S2Point> v, CodingHint hint, OutputStream output) throws IOException {
        Preconditions.checkArgument((hint == CodingHint.FAST ? 1 : 0) != 0, (Object)"Encoding \"COMPACT\" is not yet supported.");
        long sizeFormat = (long)(v.size() << 3) | 0L;
        EncodedInts.writeVarint64(output, sizeFormat);
        for (S2Point p : v) {
            p.encode(output);
        }
    }

    private static class FastEncodedS2PointVector
    extends EncodedS2PointVector {
        private final ByteBuffer data;
        private final int offset;
        private final int size;

        FastEncodedS2PointVector(ByteBuffer buffer) throws IOException {
            this.data = buffer;
            long tmpSize = EncodedInts.readVarint64(ByteBuffers.asInputStream(this.data));
            this.offset = this.data.position();
            Preconditions.checkArgument(((tmpSize >>= 3) <= 0x5555555L ? 1 : 0) != 0, (String)"Too many points. At most 2**31/24 can be decoded, got %s.", (long)tmpSize);
            this.size = (int)tmpSize;
            int bytes = this.size * 24;
            this.data.position(IntMath.checkedAdd((int)this.offset, (int)bytes));
        }

        @Override
        public S2Point get(int i) {
            this.data.position(this.offset + i * 24);
            return new S2Point(this.data.getDouble(), this.data.getDouble(), this.data.getDouble());
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    public static enum CodingHint {
        FAST,
        COMPACT;

    }
}

