/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.api.DatastorePb;
import javax.annotation.Nullable;

public class DatastoreException
extends Exception {
    private final boolean forcedNonRetryable;
    @Nullable
    private final DatastorePb.Error.ErrorCode errorCode;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isNeverRetryable() {
        return this.forcedNonRetryable || this.errorCode.equals((Object)DatastorePb.Error.ErrorCode.INTERNAL_ERROR);
    }

    public DatastoreException(String message, @Nullable DatastorePb.Error.ErrorCode errorCode, @Nullable Throwable cause) {
        this(message, errorCode, cause, false);
    }

    private DatastoreException(String message, @Nullable DatastorePb.Error.ErrorCode errorCode, @Nullable Throwable cause, boolean forcedNonRetryable) {
        super((String)Preconditions.checkNotNull((Object)message), cause);
        this.errorCode = errorCode;
        this.forcedNonRetryable = forcedNonRetryable;
    }

    public DatastoreException(@Nullable Throwable cause) {
        super(cause);
        this.forcedNonRetryable = false;
        this.errorCode = null;
    }

    @Nullable
    public DatastorePb.Error.ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public static class Builder {
        private boolean forceNonRetyable;
        @Nullable
        private DatastorePb.Error.ErrorCode errorCode;
        private String message;
        private Throwable cause;

        public Builder forceNonRetryable() {
            this.forceNonRetyable = true;
            return this;
        }

        public Builder errorCode(@Nullable DatastorePb.Error.ErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder cause(@Nullable Throwable cause) {
            this.cause = cause;
            return this;
        }

        public DatastoreException build() {
            return new DatastoreException(this.message, this.errorCode, this.cause, this.forceNonRetyable);
        }
    }
}

