/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.index;

import com.google.appengine.repackaged.org.apache.lucene.index.IndexWriter;
import com.google.appengine.repackaged.org.apache.lucene.index.LogMergePolicy;
import com.google.appengine.repackaged.org.apache.lucene.index.SegmentInfo;
import java.io.IOException;

public class LogByteSizeMergePolicy
extends LogMergePolicy {
    public static final double DEFAULT_MIN_MERGE_MB = 1.6;
    public static final double DEFAULT_MAX_MERGE_MB = 9.223372036854776E18;

    public LogByteSizeMergePolicy(IndexWriter writer) {
        super(writer);
        this.minMergeSize = 0x199999L;
        this.maxMergeSize = Long.MAX_VALUE;
    }

    protected long size(SegmentInfo info) throws IOException {
        return this.sizeBytes(info);
    }

    public void setMaxMergeMB(double mb) {
        this.maxMergeSize = (long)(mb * 1024.0 * 1024.0);
    }

    public double getMaxMergeMB() {
        return (double)this.maxMergeSize / 1024.0 / 1024.0;
    }

    public void setMinMergeMB(double mb) {
        this.minMergeSize = (long)(mb * 1024.0 * 1024.0);
    }

    public double getMinMergeMB() {
        return (double)this.minMergeSize / 1024.0 / 1024.0;
    }
}

