/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.dev.BlobInfoStorage;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class FileBlobStorage
implements BlobStorage {
    private final File rootDirectory;
    private final BlobInfoStorage blobInfoStorage;

    FileBlobStorage(File rootDirectory, BlobInfoStorage blobInfoStorage) {
        this.rootDirectory = rootDirectory;
        this.blobInfoStorage = blobInfoStorage;
    }

    @Override
    public boolean hasBlob(final BlobKey blobKey) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return FileBlobStorage.this.getFileForBlob(blobKey).exists();
            }
        });
    }

    @Override
    public OutputStream storeBlob(final BlobKey blobKey) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws IOException {
                    return new FileOutputStream(FileBlobStorage.this.getFileForBlob(blobKey));
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Throwable cause = ex.getCause();
            throw cause instanceof IOException ? (IOException)cause : new IOException(cause);
        }
    }

    @Override
    public InputStream fetchBlob(final BlobKey blobKey) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws IOException {
                    return new FileInputStream(FileBlobStorage.this.getFileForBlob(blobKey));
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Throwable cause = ex.getCause();
            throw cause instanceof IOException ? (IOException)cause : new IOException(cause);
        }
    }

    @Override
    public void deleteBlob(final BlobKey blobKey) throws IOException {
        if (this.blobInfoStorage.loadBlobInfo(blobKey) == null && this.blobInfoStorage.loadGsFileInfo(blobKey) == null) {
            String string = String.valueOf(blobKey);
            throw new RuntimeException(new StringBuilder(17 + String.valueOf(string).length()).append("Unknown blobkey: ").append(string).toString());
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    File file = FileBlobStorage.this.getFileForBlob(blobKey);
                    if (!file.delete()) {
                        String string = String.valueOf(file);
                        throw new IOException(new StringBuilder(18 + String.valueOf(string).length()).append("Could not delete: ").append(string).toString());
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Throwable cause = ex.getCause();
            throw cause instanceof IOException ? (IOException)cause : new IOException(cause);
        }
        this.blobInfoStorage.deleteBlobInfo(blobKey);
    }

    @VisibleForTesting
    File getFileForBlob(BlobKey blobKey) {
        if (blobKey.getKeyString().contains(File.separator)) {
            String string = String.valueOf(blobKey.getKeyString());
            throw new RuntimeException(string.length() != 0 ? "illegal blobKey: ".concat(string) : new String("illegal blobKey: "));
        }
        File file = new File(this.rootDirectory, blobKey.getKeyString());
        if (!file.getAbsoluteFile().getParent().equals(this.rootDirectory.getAbsolutePath())) {
            String string = String.valueOf(blobKey.getKeyString());
            throw new RuntimeException(string.length() != 0 ? "illegal blobKey: ".concat(string) : new String("illegal blobKey: "));
        }
        return file;
    }
}

