/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.shared.InvalidConversionException;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ValidationException;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Comparator;
import javax.annotation.Nullable;

public class CompiledCursorUtil {
    public static final ByteString V1_EMPTY_CURSOR = new DatastorePb.CompiledCursor().setPostfixPosition(OnestoreEntity.IndexPostfix.getDefaultInstance()).toByteString();
    public static final String BAD_CURSOR_MESSAGE = "cursor does not match query";
    public static final String OUT_OF_RANGE_CURSOR_MESSAGE = "cursor position is outside the range of the original query";

    private CompiledCursorUtil() {
    }

    private static void checkNormalized(DatastorePb.CompiledCursor cursor) {
        Preconditions.checkArgument((!cursor.hasPosition() ? 1 : 0) != 0, (Object)"Normalized cursors cannot specify a position.");
    }

    public static boolean isEmpty(DatastorePb.CompiledCursor normalizedCursor) {
        CompiledCursorUtil.checkNormalized(normalizedCursor);
        return !CompiledCursorUtil.isEncoded(normalizedCursor) && !CompiledCursorUtil.isPlannable(normalizedCursor);
    }

    public static boolean isEncoded(DatastorePb.CompiledCursor normalizedCursor) {
        CompiledCursorUtil.checkNormalized(normalizedCursor);
        return normalizedCursor.hasAbsolutePosition();
    }

    public static boolean isPlannable(DatastorePb.CompiledCursor normalizedCursor) {
        CompiledCursorUtil.checkNormalized(normalizedCursor);
        return normalizedCursor.hasPostfixPosition();
    }

    @Nullable
    public static DatastorePb.Query.Order.Direction getFirstSortDirection(DatastorePb.Query originalQuery) {
        return originalQuery.orderSize() == 0 ? null : originalQuery.getOrder(0).getDirectionEnum();
    }

    public static void normalizeCursors(DatastorePb.Query query) {
        DatastorePb.Query.Order.Direction firstSortDirection = CompiledCursorUtil.getFirstSortDirection(query);
        if (query.hasCompiledCursor()) {
            CompiledCursorUtil.normalizeCursor(query.getCompiledCursor(), firstSortDirection);
        }
        if (query.hasEndCompiledCursor()) {
            CompiledCursorUtil.normalizeCursor(query.getEndCompiledCursor(), firstSortDirection);
        }
    }

    public static void downgradeCursors(DatastorePb.QueryResult queryResult) throws InvalidConversionException {
        if (queryResult.hasCompiledCursor()) {
            CompiledCursorUtil.downgradeCursor(queryResult.getCompiledCursor());
        }
        for (DatastorePb.CompiledCursor cursor : queryResult.resultCompiledCursors()) {
            CompiledCursorUtil.downgradeCursor(cursor);
        }
        if (queryResult.hasSkippedResultsCompiledCursor()) {
            CompiledCursorUtil.downgradeCursor(queryResult.getSkippedResultsCompiledCursor());
        }
    }

    private static void downgradeCursor(DatastorePb.CompiledCursor cursor) throws InvalidConversionException {
        Preconditions.checkArgument((!(cursor.hasPosition() && cursor.hasPostfixPosition() || cursor.hasPosition() && cursor.hasAbsolutePosition() || cursor.hasPostfixPosition() && cursor.hasAbsolutePosition()) ? 1 : 0) != 0, (Object)"Cursor may specify at most one of position, postfix_position, and absolute_position.");
        if (cursor.hasAbsolutePosition()) {
            OnestoreEntity.IndexPosition indexPos = cursor.getAbsolutePosition();
            if (indexPos.hasKey()) {
                DatastorePb.CompiledCursor.Position pos = cursor.getMutablePosition();
                pos.setStartKeyAsBytes(indexPos.getKeyAsBytes());
                if (indexPos.hasBefore()) {
                    pos.setStartInclusive(indexPos.isBefore());
                }
                if (indexPos.hasBeforeAscending()) {
                    pos.setBeforeAscending(indexPos.isBeforeAscending());
                }
            }
            cursor.setAbsolutePosition(new OnestoreEntity.IndexPosition());
            cursor.clearAbsolutePosition();
        } else if (cursor.hasPostfixPosition()) {
            OnestoreEntity.IndexPostfix postfixPos = cursor.getPostfixPosition();
            if (postfixPos.hasKey() || postfixPos.indexValueSize() > 0) {
                DatastorePb.CompiledCursor.Position pos = cursor.getMutablePosition();
                for (OnestoreEntity.IndexPostfix_IndexValue value : postfixPos.indexValues()) {
                    DatastorePb.CompiledCursor.PositionIndexValue posIndexValue = pos.addIndexValue().setProperty(value.getPropertyName());
                    if (posIndexValue.getMutableValue().parseFrom(value.getValue().toByteArray())) continue;
                    throw new InvalidConversionException("Invalid value in cursor.");
                }
                if (postfixPos.hasKey() && postfixPos.hasKey() && !pos.getMutableKey().mergeFrom(postfixPos.getKey().toByteArray())) {
                    throw new InvalidConversionException("Invalid key in cursor.");
                }
                if (postfixPos.hasBefore()) {
                    pos.setStartInclusive(postfixPos.isBefore());
                }
                if (postfixPos.hasBeforeAscending()) {
                    pos.setBeforeAscending(postfixPos.isBeforeAscending());
                }
            }
            cursor.setPostfixPosition(new OnestoreEntity.IndexPostfix());
            cursor.clearPostfixPosition();
        }
    }

    private static void normalizeCursor(DatastorePb.CompiledCursor cursor, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        Preconditions.checkArgument((!(cursor.hasPosition() && cursor.hasPostfixPosition() || cursor.hasPosition() && cursor.hasAbsolutePosition() || cursor.hasPostfixPosition() && cursor.hasAbsolutePosition()) ? 1 : 0) != 0, (Object)"Cursor may specify at most one of position, postfix_position, and absolute_position.");
        if (cursor.hasPosition()) {
            DatastorePb.CompiledCursor.Position pos = cursor.getPosition();
            if (pos.hasStartKey()) {
                OnestoreEntity.IndexPosition indexPos = cursor.getMutableAbsolutePosition();
                indexPos.setKeyAsBytes(pos.getStartKeyAsBytes());
                if (pos.hasStartInclusive()) {
                    indexPos.setBefore(pos.isStartInclusive());
                }
                if (pos.hasBeforeAscending()) {
                    indexPos.setBeforeAscending(pos.isBeforeAscending());
                }
            } else if (pos.hasKey() || pos.indexValueSize() > 0) {
                OnestoreEntity.IndexPostfix postfixPos = cursor.getMutablePostfixPosition();
                for (DatastorePb.CompiledCursor.PositionIndexValue value : pos.indexValues()) {
                    OnestoreEntity.IndexPostfix_IndexValue indexValue = postfixPos.addIndexValue().setPropertyName(value.getProperty());
                    indexValue.getMutableValue().mergeFrom(value.getValue());
                }
                if (pos.hasKey()) {
                    postfixPos.getMutableKey().mergeFrom(pos.getKey());
                }
                if (pos.hasStartInclusive()) {
                    postfixPos.setBefore(pos.isStartInclusive());
                }
                if (pos.hasBeforeAscending()) {
                    postfixPos.setBeforeAscending(pos.isBeforeAscending());
                }
            }
            cursor.clearPosition();
        }
        if (CompiledCursorUtil.isEmpty(cursor)) {
            return;
        }
        if (cursor.hasAbsolutePosition()) {
            OnestoreEntity.IndexPosition indexPosition = cursor.getAbsolutePosition();
            if (indexPosition.hasBeforeAscending()) {
                CompiledCursorUtil.setBefore(indexPosition, firstSortDirection);
            } else {
                CompiledCursorUtil.setBeforeAscending(indexPosition, firstSortDirection);
            }
        } else if (cursor.hasPostfixPosition()) {
            OnestoreEntity.IndexPostfix indexPostfix = cursor.getPostfixPosition();
            if (indexPostfix.hasBeforeAscending()) {
                CompiledCursorUtil.setBefore(indexPostfix, firstSortDirection);
            } else {
                CompiledCursorUtil.setBeforeAscending(indexPostfix, firstSortDirection);
            }
        }
    }

    public static void setBefore(OnestoreEntity.IndexPosition position, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        position.setBefore(CompiledCursorUtil.getBefore(position.isBeforeAscending(), firstSortDirection));
    }

    public static void setBefore(OnestoreEntity.IndexPostfix position, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        position.setBefore(CompiledCursorUtil.getBefore(position.isBeforeAscending(), firstSortDirection));
    }

    public static void setBeforeAscending(OnestoreEntity.IndexPosition position, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        position.setBeforeAscending(CompiledCursorUtil.getBeforeAscending(position.isBefore(), firstSortDirection));
    }

    public static void setBeforeAscending(OnestoreEntity.IndexPostfix position, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        position.setBeforeAscending(CompiledCursorUtil.getBeforeAscending(position.isBefore(), firstSortDirection));
    }

    private static boolean getBefore(boolean isBeforeAscending, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        return isBeforeAscending ^ firstSortDirection == DatastorePb.Query.Order.Direction.DESCENDING;
    }

    private static boolean getBefore(boolean isInclusive, boolean isStart) {
        return isInclusive ^ !isStart;
    }

    private static boolean getBeforeAscending(boolean isBefore, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        return isBefore ^ firstSortDirection == DatastorePb.Query.Order.Direction.DESCENDING;
    }

    public static OnestoreEntity.IndexPostfix newIndexPostfix(String name, @Nullable OnestoreEntity.PropertyValue rangeValue, boolean rangeInc, boolean start) {
        if (rangeValue == null) {
            return null;
        }
        OnestoreEntity.IndexPostfix result = new OnestoreEntity.IndexPostfix();
        result.setBefore(CompiledCursorUtil.getBefore(rangeInc, start));
        if ("__key__".equals(name)) {
            result.setKey(Paths.toReference(rangeValue));
        } else {
            result.addIndexValue().setValue(rangeValue).setPropertyName(name);
        }
        return result;
    }

    public static OnestoreEntity.PropertyValue getPositionIndexValue(String property, OnestoreEntity.IndexPostfix pos) throws ValidationException {
        for (OnestoreEntity.IndexPostfix_IndexValue indexValue : pos.indexValues()) {
            if (!indexValue.getPropertyName().equals(property)) continue;
            return indexValue.getValue();
        }
        if ("__key__".equals(property)) {
            return Paths.toReferenceProperty(pos.getKey());
        }
        throw new ValidationException(BAD_CURSOR_MESSAGE);
    }

    public static <T> void checkCursorPos(T orig, boolean origInc, T cur, boolean curInc, boolean start, Comparator<T> cmpFn) throws ValidationException {
        if (orig == null) {
            return;
        }
        int cmp = cmpFn.compare(orig, cur);
        if (start) {
            ValidationException.validateAssertion(cmp < 0 || cmp == 0 && (origInc || !curInc), OUT_OF_RANGE_CURSOR_MESSAGE, new Object[0]);
        } else {
            ValidationException.validateAssertion(cmp > 0 || cmp == 0 && (!origInc || curInc), OUT_OF_RANGE_CURSOR_MESSAGE, new Object[0]);
        }
    }
}

