/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptionsOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RequestHeaderOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.apphosting.datastore.shared.CloudDatastoreV1Validator;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.Collection;

public class CloudDatastoreV1ServiceValidator {
    private final CloudDatastoreV1Validator validatorV1;

    public CloudDatastoreV1ServiceValidator(CloudDatastoreV1Validator validatorV1) {
        this.validatorV1 = validatorV1;
    }

    public CloudDatastoreV1Validator getDatastoreV1Validator() {
        return this.validatorV1;
    }

    public void validateCommitRequest(boolean isTrusted, CommitRequestOrBuilder req) throws ValidationException {
        this.validatorV1.validateCommitMode(req.getMode(), !req.getTransaction().isEmpty());
        this.validateRequestHeader(req.getHeaderOrBuilder());
        for (Mutation mutation : req.getMutationsList()) {
            this.validatorV1.validateMutation(req.getHeaderOrBuilder().getProjectId(), isTrusted, mutation);
        }
    }

    public void validateLookupRequest(LookupRequestOrBuilder req) throws ValidationException {
        this.validateReadOptions(req.getReadOptionsOrBuilder());
        this.validatorV1.getEntityValidator().validateKeys(ValidationConstraint.LOOKUP, req.getKeysList());
        this.validateRequestHeader(req.getHeaderOrBuilder());
        this.validateProjectIdMatches(req.getHeaderOrBuilder().getProjectId(), req.getKeysOrBuilderList());
    }

    public void validateAllocateIdsRequest(AllocateIdsRequestOrBuilder req) throws ValidationException {
        this.validatorV1.getEntityValidator().validateKeys(ValidationConstraint.ALLOCATE_ID, req.getKeysList());
        this.validateRequestHeader(req.getHeaderOrBuilder());
        this.validateProjectIdMatches(req.getHeaderOrBuilder().getProjectId(), req.getKeysOrBuilderList());
    }

    public void validateRunQueryRequest(RunQueryRequest req) throws ValidationException {
        Preconditions.checkArgument((req.getQueryTypeCase() != RunQueryRequest.QueryTypeCase.GQL_QUERY ? 1 : 0) != 0, (Object)"RunQueryRequest not normalized");
        this.validateReadOptions(req.getReadOptionsOrBuilder());
        this.validatorV1.getEntityValidator().validatePartitionId(ValidationConstraint.QUERY, req.getPartitionIdOrBuilder());
        ValidationException.validateAssertion(req.getQueryTypeCase() == RunQueryRequest.QueryTypeCase.QUERY, "one of fields Query.query and Query.gql_query must be set", new Object[0]);
        this.validatorV1.validateQuery(req.getReadOptionsOrBuilder().getReadConsistency() == ReadOptions.ReadConsistency.STRONG, (QueryOrBuilder)req.getQuery());
        this.validateRequestHeader(req.getHeaderOrBuilder());
        this.validatorV1.validateProjectIdMatches(req.getHeaderOrBuilder().getProjectId(), req.getPartitionIdOrBuilder());
    }

    private void validateReadOptions(ReadOptionsOrBuilder options) throws ValidationException {
        this.validatorV1.validateReadOptions(options.getReadConsistency() != ReadOptions.ReadConsistency.READ_CONSISTENCY_UNSPECIFIED, !options.getTransaction().isEmpty());
    }

    public void validateRollbackRequest(RollbackRequestOrBuilder req) throws ValidationException {
        ValidationException.validateAssertion(!req.getTransaction().isEmpty(), "transaction required", new Object[0]);
        this.validateRequestHeader(req.getHeaderOrBuilder());
    }

    public void validateBeginTransactionRequest(BeginTransactionRequestOrBuilder req) throws ValidationException {
        this.validateRequestHeader(req.getHeaderOrBuilder());
    }

    private void validateRequestHeader(RequestHeaderOrBuilder header) throws ValidationException {
        ValidationException.validateAssertion(!header.getProjectId().isEmpty(), "missing project id in header", new Object[0]);
        this.validatorV1.getEntityValidator().validateStringUtf8(header.getProjectIdBytes(), "project id");
    }

    private void validateProjectIdMatches(String projectId, Collection<? extends KeyOrBuilder> keys) throws ValidationException {
        for (KeyOrBuilder keyOrBuilder : keys) {
            this.validatorV1.validateProjectIdMatches(projectId, keyOrBuilder.getPartitionIdOrBuilder());
        }
    }
}

