/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.apphosting.datastore.DatastoreV4;

public final class QueryHelper {
    private static boolean hasGeospatialFilter(DatastoreV4.FilterOrBuilder filter) {
        if (filter.hasBoundingBoxFilter() || filter.hasBoundingCircleFilter()) {
            return true;
        }
        if (filter.hasCompositeFilter()) {
            for (DatastoreV4.FilterOrBuilder subFilter : filter.getCompositeFilter().getFilterList()) {
                if (!QueryHelper.hasGeospatialFilter(subFilter)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSearchQuery(DatastoreV4.QueryOrBuilder query) {
        return QueryHelper.hasGeospatialFilter((DatastoreV4.FilterOrBuilder)query.getFilter());
    }

    public static boolean isKeysOnlyQuery(DatastoreV4.QueryOrBuilder query) {
        return query.getProjectionCount() == 1 && query.getProjection(0).getProperty().getName().equals("__key__");
    }

    private static boolean hasAncestorFilter(DatastoreV4.FilterOrBuilder filter) {
        if (filter.hasPropertyFilter()) {
            DatastoreV4.PropertyFilterOrBuilder propFilter = filter.getPropertyFilterOrBuilder();
            return propFilter.getOperator() == DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR && propFilter.getPropertyOrBuilder().getName().equals("__key__");
        }
        if (filter.hasCompositeFilter() && filter.getCompositeFilter().getOperator() == DatastoreV4.CompositeFilter.Operator.AND) {
            for (DatastoreV4.Filter subFilter : filter.getCompositeFilter().getFilterList()) {
                if (!QueryHelper.hasAncestorFilter((DatastoreV4.FilterOrBuilder)subFilter)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAncestorFilter(DatastoreV4.QueryOrBuilder query) {
        return QueryHelper.hasAncestorFilter((DatastoreV4.FilterOrBuilder)query.getFilter());
    }

    private QueryHelper() {
    }
}

