/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.shingle;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Token;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.miscellaneous.EmptyTokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.payloads.PayloadHelper;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.TermAttribute;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import com.google.appengine.repackaged.org.apache.lucene.index.Payload;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class ShingleMatrixFilter
extends TokenStream {
    public static Character defaultSpacerCharacter = new Character('_');
    public static TokenSettingsCodec defaultSettingsCodec = new OneDimensionalNonWeightedTokenSettingsCodec();
    public static boolean ignoringSinglePrefixOrSuffixShingleByDefault = false;
    private TokenSettingsCodec settingsCodec;
    private int minimumShingleSize;
    private int maximumShingleSize;
    private boolean ignoringSinglePrefixOrSuffixShingle = false;
    private Character spacerCharacter = defaultSpacerCharacter;
    private TokenStream input;
    private TermAttribute termAtt;
    private PositionIncrementAttribute posIncrAtt;
    private PayloadAttribute payloadAtt;
    private OffsetAttribute offsetAtt;
    private TypeAttribute typeAtt;
    private FlagsAttribute flagsAtt;
    private TermAttribute in_termAtt;
    private PositionIncrementAttribute in_posIncrAtt;
    private PayloadAttribute in_payloadAtt;
    private OffsetAttribute in_offsetAtt;
    private TypeAttribute in_typeAtt;
    private FlagsAttribute in_flagsAtt;
    private Iterator permutations;
    private List currentPermuationTokens;
    private List currentPermutationRows;
    private int currentPermutationTokensStartOffset;
    private int currentShingleLength;
    private Set shinglesSeen = new HashSet();
    private Matrix matrix;
    private Token reusableToken = new Token();
    private static final Token request_next_token = new Token();
    private Token readColumnBuf;

    public ShingleMatrixFilter(Matrix matrix, int minimumShingleSize, int maximumShingleSize, Character spacerCharacter, boolean ignoringSinglePrefixOrSuffixShingle, TokenSettingsCodec settingsCodec) {
        this.matrix = matrix;
        this.minimumShingleSize = minimumShingleSize;
        this.maximumShingleSize = maximumShingleSize;
        this.spacerCharacter = spacerCharacter;
        this.ignoringSinglePrefixOrSuffixShingle = ignoringSinglePrefixOrSuffixShingle;
        this.settingsCodec = settingsCodec;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        this.payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
        this.flagsAtt = (FlagsAttribute)this.addAttribute(FlagsAttribute.class);
        this.input = new EmptyTokenStream();
        this.in_termAtt = (TermAttribute)this.input.addAttribute(TermAttribute.class);
        this.in_posIncrAtt = (PositionIncrementAttribute)this.input.addAttribute(PositionIncrementAttribute.class);
        this.in_payloadAtt = (PayloadAttribute)this.input.addAttribute(PayloadAttribute.class);
        this.in_offsetAtt = (OffsetAttribute)this.input.addAttribute(OffsetAttribute.class);
        this.in_typeAtt = (TypeAttribute)this.input.addAttribute(TypeAttribute.class);
        this.in_flagsAtt = (FlagsAttribute)this.input.addAttribute(FlagsAttribute.class);
    }

    public ShingleMatrixFilter(TokenStream input, int minimumShingleSize, int maximumShingleSize) {
        this(input, minimumShingleSize, maximumShingleSize, defaultSpacerCharacter);
    }

    public ShingleMatrixFilter(TokenStream input, int minimumShingleSize, int maximumShingleSize, Character spacerCharacter) {
        this(input, minimumShingleSize, maximumShingleSize, spacerCharacter, ignoringSinglePrefixOrSuffixShingleByDefault);
    }

    public ShingleMatrixFilter(TokenStream input, int minimumShingleSize, int maximumShingleSize, Character spacerCharacter, boolean ignoringSinglePrefixOrSuffixShingle) {
        this(input, minimumShingleSize, maximumShingleSize, spacerCharacter, ignoringSinglePrefixOrSuffixShingle, defaultSettingsCodec);
    }

    public ShingleMatrixFilter(TokenStream input, int minimumShingleSize, int maximumShingleSize, Character spacerCharacter, boolean ignoringSinglePrefixOrSuffixShingle, TokenSettingsCodec settingsCodec) {
        this.input = input;
        this.minimumShingleSize = minimumShingleSize;
        this.maximumShingleSize = maximumShingleSize;
        this.spacerCharacter = spacerCharacter;
        this.ignoringSinglePrefixOrSuffixShingle = ignoringSinglePrefixOrSuffixShingle;
        this.settingsCodec = settingsCodec;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        this.payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
        this.flagsAtt = (FlagsAttribute)this.addAttribute(FlagsAttribute.class);
        this.in_termAtt = (TermAttribute)input.addAttribute(TermAttribute.class);
        this.in_posIncrAtt = (PositionIncrementAttribute)input.addAttribute(PositionIncrementAttribute.class);
        this.in_payloadAtt = (PayloadAttribute)input.addAttribute(PayloadAttribute.class);
        this.in_offsetAtt = (OffsetAttribute)input.addAttribute(OffsetAttribute.class);
        this.in_typeAtt = (TypeAttribute)input.addAttribute(TypeAttribute.class);
        this.in_flagsAtt = (FlagsAttribute)input.addAttribute(FlagsAttribute.class);
    }

    public void reset() throws IOException {
        this.permutations = null;
        this.shinglesSeen.clear();
        this.input.reset();
    }

    public final boolean incrementToken() throws IOException {
        Token token;
        if (this.matrix == null) {
            this.matrix = new Matrix();
            while (this.matrix.columns.size() < this.maximumShingleSize && this.readColumn()) {
            }
        }
        while ((token = this.produceNextToken(this.reusableToken)) == request_next_token) {
        }
        if (token == null) {
            return false;
        }
        this.clearAttributes();
        this.termAtt.setTermBuffer(token.termBuffer(), 0, token.termLength());
        this.posIncrAtt.setPositionIncrement(token.getPositionIncrement());
        this.flagsAtt.setFlags(token.getFlags());
        this.offsetAtt.setOffset(token.startOffset(), token.endOffset());
        this.typeAtt.setType(token.type());
        this.payloadAtt.setPayload(token.getPayload());
        return true;
    }

    private Token getNextInputToken(Token token) throws IOException {
        if (!this.input.incrementToken()) {
            return null;
        }
        token.setTermBuffer(this.in_termAtt.termBuffer(), 0, this.in_termAtt.termLength());
        token.setPositionIncrement(this.in_posIncrAtt.getPositionIncrement());
        token.setFlags(this.in_flagsAtt.getFlags());
        token.setOffset(this.in_offsetAtt.startOffset(), this.in_offsetAtt.endOffset());
        token.setType(this.in_typeAtt.type());
        token.setPayload(this.in_payloadAtt.getPayload());
        return token;
    }

    public final Token next(Token reusableToken) throws IOException {
        return super.next(reusableToken);
    }

    public final Token next() throws IOException {
        return super.next();
    }

    private Token produceNextToken(Token reusableToken) throws IOException {
        if (this.currentPermuationTokens != null) {
            ++this.currentShingleLength;
            if (this.currentShingleLength + this.currentPermutationTokensStartOffset <= this.currentPermuationTokens.size() && this.currentShingleLength <= this.maximumShingleSize) {
                if (this.ignoringSinglePrefixOrSuffixShingle && this.currentShingleLength == 1 && (((Matrix.Column.Row)this.currentPermutationRows.get(this.currentPermutationTokensStartOffset)).getColumn().isFirst() || ((Matrix.Column.Row)this.currentPermutationRows.get(this.currentPermutationTokensStartOffset)).getColumn().isLast())) {
                    return this.next();
                }
                int termLength = 0;
                ArrayList<Token> shingle = new ArrayList<Token>();
                for (int i = 0; i < this.currentShingleLength; ++i) {
                    Token shingleToken = (Token)this.currentPermuationTokens.get(i + this.currentPermutationTokensStartOffset);
                    termLength += shingleToken.termLength();
                    shingle.add(shingleToken);
                }
                if (this.spacerCharacter != null) {
                    termLength += this.currentShingleLength - 1;
                }
                if (!this.shinglesSeen.add(shingle)) {
                    return request_next_token;
                }
                StringBuffer sb = new StringBuffer(termLength + 10);
                Iterator iterator = shingle.iterator();
                while (iterator.hasNext()) {
                    Token shingleToken = (Token)iterator.next();
                    if (this.spacerCharacter != null && sb.length() > 0) {
                        sb.append(this.spacerCharacter);
                    }
                    sb.append(shingleToken.termBuffer(), 0, shingleToken.termLength());
                }
                reusableToken.setTermBuffer(sb.toString());
                this.updateToken(reusableToken, shingle, this.currentPermutationTokensStartOffset, this.currentPermutationRows, this.currentPermuationTokens);
                return reusableToken;
            }
            if (this.currentPermutationTokensStartOffset < this.currentPermuationTokens.size() - 1) {
                ++this.currentPermutationTokensStartOffset;
                this.currentShingleLength = this.minimumShingleSize - 1;
                return request_next_token;
            }
            if (this.permutations == null) {
                return null;
            }
            if (!this.permutations.hasNext()) {
                if (this.input == null || this.readColumn()) {
                    // empty if block
                }
                Matrix.Column deletedColumn = (Matrix.Column)this.matrix.columns.remove(0);
                ArrayList deletedColumnTokens = new ArrayList();
                Iterator iterator = deletedColumn.getRows().iterator();
                while (iterator.hasNext()) {
                    Matrix.Column.Row row = (Matrix.Column.Row)iterator.next();
                    Iterator rowIter = row.getTokens().iterator();
                    while (rowIter.hasNext()) {
                        Object o = rowIter.next();
                        deletedColumnTokens.add(o);
                    }
                }
                Iterator shinglesSeenIterator = this.shinglesSeen.iterator();
                block4: while (shinglesSeenIterator.hasNext()) {
                    List shingle = (List)shinglesSeenIterator.next();
                    Iterator deletedIter = deletedColumnTokens.iterator();
                    while (deletedIter.hasNext()) {
                        Token deletedColumnToken = (Token)deletedIter.next();
                        if (!shingle.contains(deletedColumnToken)) continue;
                        shinglesSeenIterator.remove();
                        continue block4;
                    }
                }
                if (this.matrix.columns.size() < this.minimumShingleSize) {
                    return null;
                }
                this.permutations = this.matrix.permutationIterator();
            }
            this.nextTokensPermutation();
            return request_next_token;
        }
        if (this.permutations == null) {
            this.permutations = this.matrix.permutationIterator();
        }
        if (!this.permutations.hasNext()) {
            return null;
        }
        this.nextTokensPermutation();
        return request_next_token;
    }

    private void nextTokensPermutation() {
        Matrix.Column.Row[] rowsPermutation = (Matrix.Column.Row[])this.permutations.next();
        ArrayList<Matrix.Column.Row> currentPermutationRows = new ArrayList<Matrix.Column.Row>();
        ArrayList currentPermuationTokens = new ArrayList();
        for (int i = 0; i < rowsPermutation.length; ++i) {
            Matrix.Column.Row row = rowsPermutation[i];
            Iterator iterator = row.getTokens().iterator();
            while (iterator.hasNext()) {
                currentPermuationTokens.add(iterator.next());
                currentPermutationRows.add(row);
            }
        }
        this.currentPermuationTokens = currentPermuationTokens;
        this.currentPermutationRows = currentPermutationRows;
        this.currentPermutationTokensStartOffset = 0;
        this.currentShingleLength = this.minimumShingleSize - 1;
    }

    public void updateToken(Token token, List shingle, int currentPermutationStartOffset, List currentPermutationRows, List currentPermuationTokens) {
        token.setType(ShingleMatrixFilter.class.getName());
        token.setFlags(0);
        token.setPositionIncrement(1);
        token.setStartOffset(((Token)shingle.get(0)).startOffset());
        token.setEndOffset(((Token)shingle.get(shingle.size() - 1)).endOffset());
        this.settingsCodec.setWeight(token, this.calculateShingleWeight(token, shingle, currentPermutationStartOffset, currentPermutationRows, currentPermuationTokens));
    }

    public float calculateShingleWeight(Token shingleToken, List shingle, int currentPermutationStartOffset, List currentPermutationRows, List currentPermuationTokens) {
        double[] weights = new double[shingle.size()];
        double total = 0.0;
        double top = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = this.settingsCodec.getWeight((Token)shingle.get(i));
            double tmp = weights[i];
            if (tmp > top) {
                top = tmp;
            }
            total += tmp;
        }
        double factor = 1.0 / Math.sqrt(total);
        double weight = 0.0;
        for (int i = 0; i < weights.length; ++i) {
            double partWeight = weights[i];
            weight += partWeight * factor;
        }
        return (float)weight;
    }

    private boolean readColumn() throws IOException {
        TokenPositioner tokenPositioner;
        Token token;
        if (this.readColumnBuf != null) {
            token = this.readColumnBuf;
            this.readColumnBuf = null;
        } else {
            token = this.getNextInputToken(new Token());
        }
        if (token == null) {
            return false;
        }
        Matrix.Column currentReaderColumn = this.matrix.new Matrix.Column();
        Matrix.Column.Row currentReaderRow = currentReaderColumn.new Matrix.Column.Row();
        currentReaderRow.getTokens().add(token);
        while ((this.readColumnBuf = this.getNextInputToken(new Token())) != null && (tokenPositioner = this.settingsCodec.getTokenPositioner(this.readColumnBuf)) != TokenPositioner.newColumn) {
            if (tokenPositioner == TokenPositioner.sameRow) {
                currentReaderRow.getTokens().add(this.readColumnBuf);
            } else {
                currentReaderRow = currentReaderColumn.new Matrix.Column.Row();
                currentReaderRow.getTokens().add(this.readColumnBuf);
            }
            this.readColumnBuf = null;
        }
        if (this.readColumnBuf == null) {
            this.readColumnBuf = this.getNextInputToken(new Token());
            if (this.readColumnBuf == null) {
                currentReaderColumn.setLast(true);
            }
        }
        return true;
    }

    public int getMinimumShingleSize() {
        return this.minimumShingleSize;
    }

    public void setMinimumShingleSize(int minimumShingleSize) {
        this.minimumShingleSize = minimumShingleSize;
    }

    public int getMaximumShingleSize() {
        return this.maximumShingleSize;
    }

    public void setMaximumShingleSize(int maximumShingleSize) {
        this.maximumShingleSize = maximumShingleSize;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    public Character getSpacerCharacter() {
        return this.spacerCharacter;
    }

    public void setSpacerCharacter(Character spacerCharacter) {
        this.spacerCharacter = spacerCharacter;
    }

    public boolean isIgnoringSinglePrefixOrSuffixShingle() {
        return this.ignoringSinglePrefixOrSuffixShingle;
    }

    public void setIgnoringSinglePrefixOrSuffixShingle(boolean ignoringSinglePrefixOrSuffixShingle) {
        this.ignoringSinglePrefixOrSuffixShingle = ignoringSinglePrefixOrSuffixShingle;
    }

    public static class SimpleThreeDimensionalTokenSettingsCodec
    extends TokenSettingsCodec {
        public TokenPositioner getTokenPositioner(Token token) throws IOException {
            switch (token.getFlags()) {
                case 0: {
                    return TokenPositioner.newColumn;
                }
                case 1: {
                    return TokenPositioner.newRow;
                }
                case 2: {
                    return TokenPositioner.sameRow;
                }
            }
            throw new IOException("Unknown matrix positioning of token " + token);
        }

        public void setTokenPositioner(Token token, TokenPositioner tokenPositioner) {
            token.setFlags(tokenPositioner.getIndex());
        }

        public float getWeight(Token token) {
            if (token.getPayload() == null || token.getPayload().getData() == null) {
                return 1.0f;
            }
            return PayloadHelper.decodeFloat(token.getPayload().getData());
        }

        public void setWeight(Token token, float weight) {
            if (weight == 1.0f) {
                token.setPayload(null);
            } else {
                token.setPayload(new Payload(PayloadHelper.encodeFloat(weight)));
            }
        }
    }

    public static class TwoDimensionalNonWeightedSynonymTokenSettingsCodec
    extends TokenSettingsCodec {
        public TokenPositioner getTokenPositioner(Token token) throws IOException {
            if (token.getPositionIncrement() == 0) {
                return TokenPositioner.newRow;
            }
            return TokenPositioner.newColumn;
        }

        public void setTokenPositioner(Token token, TokenPositioner tokenPositioner) {
            throw new UnsupportedOperationException();
        }

        public float getWeight(Token token) {
            return 1.0f;
        }

        public void setWeight(Token token, float weight) {
        }
    }

    public static class OneDimensionalNonWeightedTokenSettingsCodec
    extends TokenSettingsCodec {
        public TokenPositioner getTokenPositioner(Token token) throws IOException {
            return TokenPositioner.newColumn;
        }

        public void setTokenPositioner(Token token, TokenPositioner tokenPositioner) {
        }

        public float getWeight(Token token) {
            return 1.0f;
        }

        public void setWeight(Token token, float weight) {
        }
    }

    public static class Matrix {
        private boolean columnsHasBeenCreated = false;
        private List columns = new ArrayList();

        public List getColumns() {
            return this.columns;
        }

        public Iterator permutationIterator() {
            return new Iterator(){
                private int[] columnRowCounters;
                {
                    this.columnRowCounters = new int[Matrix.this.columns.size()];
                }

                public void remove() {
                    throw new IllegalStateException("not implemented");
                }

                public boolean hasNext() {
                    int s = this.columnRowCounters.length;
                    int n = Matrix.this.columns.size();
                    return s != 0 && n >= s && this.columnRowCounters[s - 1] < ((Column)Matrix.this.columns.get(s - 1)).getRows().size();
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("no more elements");
                    }
                    Column.Row[] rows = new Column.Row[this.columnRowCounters.length];
                    for (int i = 0; i < this.columnRowCounters.length; ++i) {
                        rows[i] = (Column.Row)((Column)Matrix.this.columns.get(i)).rows.get(this.columnRowCounters[i]);
                    }
                    this.incrementColumnRowCounters();
                    return rows;
                }

                private void incrementColumnRowCounters() {
                    for (int i = 0; i < this.columnRowCounters.length; ++i) {
                        int n = i;
                        this.columnRowCounters[n] = this.columnRowCounters[n] + 1;
                        if (this.columnRowCounters[i] != ((Column)Matrix.this.columns.get(i)).rows.size() || i >= this.columnRowCounters.length - 1) break;
                        this.columnRowCounters[i] = 0;
                    }
                }
            };
        }

        public String toString() {
            return "Matrix{columns=" + this.columns + '}';
        }

        public class Column {
            private boolean last;
            private boolean first;
            private List rows = new ArrayList();

            public Matrix getMatrix() {
                return Matrix.this;
            }

            public Column(Token token) {
                this();
                Row row = new Row();
                row.getTokens().add(token);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Column() {
                Matrix matrix2 = Matrix.this;
                synchronized (matrix2) {
                    if (!Matrix.this.columnsHasBeenCreated) {
                        this.setFirst(true);
                        Matrix.this.columnsHasBeenCreated = true;
                    }
                }
                Matrix.this.columns.add(this);
            }

            public List getRows() {
                return this.rows;
            }

            public int getIndex() {
                return Matrix.this.columns.indexOf(this);
            }

            public String toString() {
                return "Column{first=" + this.first + ", last=" + this.last + ", rows=" + this.rows + '}';
            }

            public boolean isFirst() {
                return this.first;
            }

            public void setFirst(boolean first) {
                this.first = first;
            }

            public void setLast(boolean last) {
                this.last = last;
            }

            public boolean isLast() {
                return this.last;
            }

            public class Row {
                private List tokens = new LinkedList();

                public Column getColumn() {
                    return Column.this;
                }

                public Row() {
                    Column.this.rows.add(this);
                }

                public int getIndex() {
                    return Column.this.rows.indexOf(this);
                }

                public List getTokens() {
                    return this.tokens;
                }

                public void setTokens(List tokens) {
                    this.tokens = tokens;
                }

                public String toString() {
                    return "Row{index=" + this.getIndex() + ", tokens=" + (this.tokens == null ? null : this.tokens) + '}';
                }
            }
        }
    }

    public static class TokenPositioner {
        public static final TokenPositioner newColumn = new TokenPositioner(0);
        public static final TokenPositioner newRow = new TokenPositioner(1);
        public static final TokenPositioner sameRow = new TokenPositioner(2);
        private final int index;

        private TokenPositioner(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static abstract class TokenSettingsCodec {
        public abstract TokenPositioner getTokenPositioner(Token var1) throws IOException;

        public abstract void setTokenPositioner(Token var1, TokenPositioner var2);

        public abstract float getWeight(Token var1);

        public abstract void setWeight(Token var1, float var2);
    }
}

