/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient;

import com.google.appengine.repackaged.org.apache.commons.httpclient.ProtocolException;

public class HttpVersion
implements Comparable {
    private int major = 0;
    private int minor = 0;
    public static final HttpVersion HTTP_0_9 = new HttpVersion(0, 9);
    public static final HttpVersion HTTP_1_0 = new HttpVersion(1, 0);
    public static final HttpVersion HTTP_1_1 = new HttpVersion(1, 1);

    public HttpVersion(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("HTTP major version number may not be negative");
        }
        this.major = n;
        if (n2 < 0) {
            throw new IllegalArgumentException("HTTP minor version number may not be negative");
        }
        this.minor = n2;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int hashCode() {
        return this.major * 100000 + this.minor;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HttpVersion)) {
            return false;
        }
        return this.equals((HttpVersion)object);
    }

    public int compareTo(HttpVersion httpVersion) {
        if (httpVersion == null) {
            throw new IllegalArgumentException("Version parameter may not be null");
        }
        int n = this.getMajor() - httpVersion.getMajor();
        if (n == 0) {
            n = this.getMinor() - httpVersion.getMinor();
        }
        return n;
    }

    public int compareTo(Object object) {
        return this.compareTo((HttpVersion)object);
    }

    public boolean equals(HttpVersion httpVersion) {
        return this.compareTo(httpVersion) == 0;
    }

    public boolean greaterEquals(HttpVersion httpVersion) {
        return this.compareTo(httpVersion) >= 0;
    }

    public boolean lessEquals(HttpVersion httpVersion) {
        return this.compareTo(httpVersion) <= 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HTTP/");
        stringBuffer.append(this.major);
        stringBuffer.append('.');
        stringBuffer.append(this.minor);
        return stringBuffer.toString();
    }

    public static HttpVersion parse(String string) throws ProtocolException {
        int n;
        int n2;
        if (string == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        if (!string.startsWith("HTTP/")) {
            throw new ProtocolException("Invalid HTTP version string: " + string);
        }
        int n3 = "HTTP/".length();
        int n4 = string.indexOf(".", n3);
        if (n4 == -1) {
            throw new ProtocolException("Invalid HTTP version number: " + string);
        }
        try {
            n2 = Integer.parseInt(string.substring(n3, n4));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException("Invalid HTTP major version number: " + string);
        }
        n3 = n4 + 1;
        n4 = string.length();
        try {
            n = Integer.parseInt(string.substring(n3, n4));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProtocolException("Invalid HTTP minor version number: " + string);
        }
        return new HttpVersion(n2, n);
    }
}

