/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

@GwtCompatible(serializable=true)
public class S2RegionUnion
implements S2Region,
Serializable {
    final S2Region[] regions;
    private transient S2Cap cachedCapBound = null;
    private transient S2LatLngRect cachedRectBound = null;

    public S2RegionUnion(Collection<S2Region> regions) {
        this.regions = regions.toArray(new S2Region[regions.size()]);
    }

    @Override
    public boolean contains(S2Cell cell) {
        for (S2Region region : this.regions) {
            if (!region.contains(cell)) continue;
            return true;
        }
        return false;
    }

    @Override
    public S2Cap getCapBound() {
        if (this.cachedCapBound != null) {
            return this.cachedCapBound;
        }
        this.cachedCapBound = S2Cap.empty();
        for (S2Region region : this.regions) {
            this.cachedCapBound = this.cachedCapBound.addCap(region.getCapBound());
        }
        return this.cachedCapBound;
    }

    @Override
    public S2LatLngRect getRectBound() {
        if (this.cachedRectBound != null) {
            return this.cachedRectBound;
        }
        this.cachedRectBound = S2LatLngRect.empty();
        for (S2Region region : this.regions) {
            this.cachedRectBound = this.cachedRectBound.union(region.getRectBound());
        }
        return this.cachedRectBound;
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        for (S2Region region : this.regions) {
            if (!region.mayIntersect(cell)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object thatObject) {
        if (!(thatObject instanceof S2RegionUnion)) {
            return false;
        }
        S2RegionUnion that = (S2RegionUnion)thatObject;
        return Arrays.deepEquals(this.regions, that.regions);
    }
}

