/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.prospectivesearch.dev;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.prospectivesearch.ProspectiveSearchPb;
import com.google.appengine.api.prospectivesearch.dev.BooleanQueryContext;
import com.google.appengine.api.prospectivesearch.dev.QueryEngine;
import com.google.appengine.api.search.query.QueryLexer;
import com.google.appengine.api.search.query.QueryParser;
import com.google.appengine.api.search.query.QueryTreeContext;
import com.google.appengine.api.search.query.QueryTreeVisitor;
import com.google.appengine.api.search.query.QueryTreeWalker;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.org.antlr.runtime.ANTLRStringStream;
import com.google.appengine.repackaged.org.antlr.runtime.CharStream;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import com.google.appengine.repackaged.org.antlr.runtime.TokenRewriteStream;
import com.google.appengine.repackaged.org.antlr.runtime.TokenSource;
import com.google.appengine.repackaged.org.antlr.runtime.TokenStream;
import com.google.appengine.repackaged.org.antlr.runtime.tree.Tree;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueryEvaluator
implements QueryTreeVisitor<BooleanQueryContext> {
    static final Logger logger = Logger.getLogger(QueryEvaluator.class.getName());
    private final Tree queryTree;
    private final StringBuffer debugIndentSpaces;
    Entity doc;
    Map<String, ProspectiveSearchPb.SchemaEntry> schema;
    String op;
    int debugIndentLevel;

    QueryEvaluator(String query) throws RecognitionException {
        QueryParser parser = new QueryParser((TokenStream)new TokenRewriteStream((TokenSource)new QueryLexer((CharStream)new ANTLRStringStream(query))));
        this.queryTree = QueryTreeWalker.simplify((Tree)((Tree)parser.query().getTree()));
        this.debugIndentSpaces = new StringBuffer();
    }

    boolean eval(Entity doc, Map<String, ProspectiveSearchPb.SchemaEntry> schema) {
        this.doc = doc;
        this.schema = schema;
        QueryTreeWalker walker = new QueryTreeWalker((QueryTreeVisitor)this);
        BooleanQueryContext rootContext = new BooleanQueryContext();
        walker.walk(this.queryTree, (QueryTreeContext)rootContext);
        this.debugIndentSpaces.setLength(0);
        return rootContext.get();
    }

    public void visitSequence(Tree node, BooleanQueryContext matches) {
        this.visitConjunction(node, matches);
    }

    public void visitConjunction(Tree node, BooleanQueryContext matches) {
        this.debugIn("Conjunction {", new Object[0]);
        boolean curBool = true;
        for (BooleanQueryContext child : matches.children()) {
            curBool &= child.get();
        }
        matches.set(curBool);
        this.debugOut("} = %s", new Object[]{matches});
    }

    public void visitDisjunction(Tree node, BooleanQueryContext matches) {
        this.debugIn("Disjunction {", new Object[0]);
        boolean curBool = false;
        for (BooleanQueryContext child : matches.children()) {
            curBool |= child.get();
        }
        matches.set(curBool);
        this.debugOut("} = %s", new Object[]{matches});
    }

    public void visitNegation(Tree node, BooleanQueryContext matches) {
        this.debugIn("Negation {", new Object[0]);
        Preconditions.checkArgument((matches.getChildCount() == 1 ? 1 : 0) != 0);
        matches.set(!((BooleanQueryContext)matches.getChild(0)).get());
        this.debugOut("} = %s", new Object[]{matches});
    }

    public void visitFuzzy(Tree node, BooleanQueryContext matches) {
        this.debugIn("Fuzzy {", new Object[0]);
        this.debugOut("} = %s", new Object[]{matches});
    }

    public void visitLiteral(Tree node, BooleanQueryContext matches) {
        this.debugIn("Literal {", new Object[0]);
        this.debugOut("} = %s", new Object[]{matches});
    }

    public void visitLessThan(Tree node, BooleanQueryContext matches) {
        this.debugIn("LessThan {", new Object[0]);
        this.evalComparison(matches, "<");
        this.debugOut("} = %s", new Object[]{matches});
    }

    public void visitLessOrEqual(Tree node, BooleanQueryContext matches) {
        this.debugIn("LessOrEqual {", new Object[0]);
        this.evalComparison(matches, "<=");
        this.debugOut("} = %s", new Object[]{matches});
    }

    public void visitGreaterThan(Tree node, BooleanQueryContext matches) {
        this.debugIn("GreaterThan {", new Object[0]);
        this.evalComparison(matches, ">");
        this.debugOut("} = %s", new Object[]{matches});
    }

    public void visitGreaterOrEqual(Tree node, BooleanQueryContext matches) {
        this.debugIn("GreaterOrEqual {", new Object[0]);
        this.evalComparison(matches, ">=");
        this.debugOut("} = %s", new Object[]{matches});
    }

    public void visitEqual(Tree node, BooleanQueryContext matches) {
        this.debugIn("Equal {", new Object[0]);
        this.evalComparison(matches, "=");
        this.debugOut("} = %s", new Object[]{matches});
    }

    public void visitContains(Tree node, BooleanQueryContext matches) {
        this.debugIn("Contains {", new Object[0]);
        this.evalComparison(matches, ":");
        this.debugOut("} = %s", new Object[]{matches});
    }

    public void visitValue(Tree node, BooleanQueryContext matches) {
        String fieldValue;
        if (node.getChild(0).getType() == 32) {
            fieldValue = node.getChild(1).getText();
        } else {
            StringBuilder builder = new StringBuilder();
            for (int i = 1; i < node.getChildCount(); ++i) {
                builder.append(node.getChild(i).getText());
            }
            fieldValue = builder.toString();
        }
        matches.setText(fieldValue);
        if (this.schema.containsKey(fieldValue)) {
            matches.setKind(QueryTreeContext.Kind.FIELD);
        } else {
            matches.setKind(QueryTreeContext.Kind.LITERAL);
        }
    }

    public void visitGlobal(Tree node, BooleanQueryContext matches) {
        matches.setText("");
    }

    public void visitFunction(Tree node, BooleanQueryContext matches) {
    }

    public void visitOther(Tree node, BooleanQueryContext matches) {
        this.debugIn("Other {", new Object[0]);
        this.debugOut("} = %s", new Object[]{matches});
    }

    private void evalComparison(BooleanQueryContext matches, String op) {
        BooleanQueryContext lhs = (BooleanQueryContext)matches.getChild(0);
        BooleanQueryContext rhs = (BooleanQueryContext)matches.getChild(1);
        String fieldName = "";
        if (lhs.isField()) {
            fieldName = lhs.getText();
        }
        String fieldValue = rhs.getText();
        this.debug("  Entity[%s] %s %s", fieldName, op, fieldValue);
        matches.set(QueryEngine.query(this.doc, fieldName, op, fieldValue, this.schema));
    }

    void debugIn(String template, Object ... args) {
        ++this.debugIndentLevel;
        this.debug(template, args);
    }

    void debugOut(String template, Object ... args) {
        this.debug(template, args);
        --this.debugIndentLevel;
    }

    void debug(String template, Object ... args) {
        while (this.debugIndentSpaces.length() < this.debugIndentLevel * 2) {
            this.debugIndentSpaces.append(" ");
        }
        if (logger.isLoggable(Level.FINEST)) {
            String string = String.valueOf(this.debugIndentSpaces.substring(0, this.debugIndentLevel * 2));
            String string2 = String.valueOf(String.format(template, args));
            logger.finest(string2.length() != 0 ? string.concat(string2) : new String(string));
        }
    }
}

