/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.tools.appstats.TemplateTool;
import com.google.appengine.tools.appstats.TemplateValueHelper;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class TemplateObjectModel
implements Cloneable {
    private static final Pattern ROOT_PATTERN = Pattern.compile("(\\{\\{[^\\{\\}]+\\}\\})|(\\{%[^\\{\\}]+%\\})|(\\{#[^\\{\\}]+#\\})|([\\{\\}]?([^\\{\\}]+))");
    private static final Pattern FOR_PATTERN = Pattern.compile("for\\s+(.+)\\s+in\\s+([^,]+)");
    private static final Pattern IFEQUAL_PATTERN = Pattern.compile("ifequal\\s+(\\S+)\\s+(\\S+)\\s*");
    private static final Pattern IF_PATTERN = Pattern.compile("if\\s+(.+)\\s*");

    private static String unwrap(String s) {
        return s.substring(2, s.length() - 2).trim();
    }

    private static void append(List<TemplateObjectModel> stack, TemplateObjectModel cmd) throws ParseException {
        TemplateObjectModel last = stack.get(stack.size() - 1);
        if (last instanceof CompositeNode) {
            ((CompositeNode)last).add(cmd);
        } else if (last instanceof CommentNode) {
            CommentNode node = (CommentNode)last;
            node.subNode.add(cmd);
        } else {
            String string = String.valueOf(last.getClass().getSimpleName());
            throw new ParseException(string.length() != 0 ? "Cannot append a sub-node to ".concat(string) : new String("Cannot append a sub-node to "), 0);
        }
    }

    private TemplateObjectModel() {
    }

    abstract void execute(Writer var1, TemplateValueHelper var2) throws IOException;

    public static TemplateObjectModel buildFrom(CharSequence parseThis, TemplateObjectModel baseTemplate, TemplateTool tool) throws ParseException {
        HashMap<String, CompositeNode> blocks = new HashMap<String, CompositeNode>();
        ArrayList<TemplateObjectModel> stack = new ArrayList<TemplateObjectModel>();
        ArrayList<ForLoopNode> ifStack = new ArrayList<ForLoopNode>();
        stack.add(new CompositeNode());
        Matcher matcher = ROOT_PATTERN.matcher(parseThis);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                if (stack.get(stack.size() - 1) instanceof CommentNode) {
                    TemplateObjectModel.append(stack, new TextNode(matcher.group(1)));
                    continue;
                }
                TemplateObjectModel.append(stack, new FieldNode(TemplateObjectModel.unwrap(matcher.group(1))));
                continue;
            }
            if (matcher.group(2) != null) {
                Matcher subMatcher;
                TemplateObjectModel node;
                Object forMatcher;
                TemplateObjectModel node2;
                String[] tokens;
                if (stack.get(stack.size() - 1) instanceof CommentNode) {
                    tokens = TemplateObjectModel.unwrap(matcher.group(2)).split("\\s");
                    if (tokens[0].equals("endcomment")) {
                        node2 = (CommentNode)stack.remove(stack.size() - 1);
                        TemplateObjectModel.append(stack, node2);
                        continue;
                    }
                    TemplateObjectModel.append(stack, new TextNode(matcher.group(2)));
                    continue;
                }
                tokens = TemplateObjectModel.unwrap(matcher.group(2)).split("\\s");
                if (tokens[0].equals("else")) {
                    node2 = (CompositeNode)stack.remove(stack.size() - 1);
                    TemplateObjectModel ifNode = (TemplateObjectModel)ifStack.get(ifStack.size() - 1);
                    if (ifNode instanceof IfNode) {
                        stack.add(((IfNode)ifNode).onFalse);
                        continue;
                    }
                    if (ifNode instanceof IfEqualNode) {
                        stack.add(((IfEqualNode)ifNode).onFalse);
                        continue;
                    }
                    String string = String.valueOf(ifNode.getClass());
                    throw new ParseException(new StringBuilder(23 + String.valueOf(string).length()).append("else not supported for ").append(string).toString(), 0);
                }
                if (tokens[0].equals("comment")) {
                    stack.add(new CommentNode());
                    continue;
                }
                if (tokens[0].equals("extends")) {
                    String filename = tokens[1];
                    if (filename.startsWith("\"")) {
                        filename = filename.substring(1, filename.length() - 1);
                    }
                    if (stack.size() != 1) {
                        throw new ParseException("Can only extend root template node", 0);
                    }
                    if (baseTemplate != null) {
                        throw new ParseException("Cannot set base template twice", 0);
                    }
                    try {
                        baseTemplate = tool.getTemplate(filename, null);
                        continue;
                    }
                    catch (IOException e) {
                        String string = filename;
                        String string2 = String.valueOf(e);
                        throw new ParseException(new StringBuilder(30 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Cannot load template parent ").append(string).append(": ").append(string2).toString(), 0);
                    }
                }
                if (tokens[0].equals("include")) {
                    String includeName = tokens[1];
                    TemplateObjectModel.append(stack, new IncludeNode(includeName));
                    continue;
                }
                if (tokens[0].equals("block")) {
                    String blockName = tokens[1];
                    if (blocks.containsKey(blockName)) {
                        String string = String.valueOf(blockName);
                        throw new ParseException(string.length() != 0 ? "block already defined: ".concat(string) : new String("block already defined: "), 0);
                    }
                    CompositeNode block = new CompositeNode();
                    block.blockName = blockName;
                    TemplateObjectModel.append(stack, block);
                    stack.add(block);
                    blocks.put(blockName, block);
                    continue;
                }
                if (tokens[0].equals("for")) {
                    forMatcher = FOR_PATTERN.matcher(TemplateObjectModel.unwrap(matcher.group(2)));
                    if (!((Matcher)forMatcher).matches()) {
                        String string = String.valueOf(matcher.group(2));
                        throw new ParseException(string.length() != 0 ? "Cannot parse: ".concat(string) : new String("Cannot parse: "), 0);
                    }
                    node = new ForLoopNode(((Matcher)forMatcher).group(1).trim(), ((Matcher)forMatcher).group(2).trim());
                    TemplateObjectModel.append(stack, node);
                    stack.add(node.subTree);
                    continue;
                }
                if (tokens[0].equals("endblock")) {
                    forMatcher = (CompositeNode)stack.remove(stack.size() - 1);
                    continue;
                }
                if (tokens[0].equals("endfor")) {
                    forMatcher = (CompositeNode)stack.remove(stack.size() - 1);
                    continue;
                }
                if (tokens[0].equals("if")) {
                    subMatcher = IF_PATTERN.matcher(TemplateObjectModel.unwrap(matcher.group(2)));
                    if (!subMatcher.matches()) {
                        String string = String.valueOf(matcher.group(2));
                        throw new ParseException(string.length() != 0 ? "Cannot parse: ".concat(string) : new String("Cannot parse: "), 0);
                    }
                    node = new IfNode(subMatcher.group(1));
                    TemplateObjectModel.append(stack, node);
                    stack.add(((IfNode)node).onTrue);
                    ifStack.add((ForLoopNode)node);
                    continue;
                }
                if (tokens[0].equals("endif")) {
                    node2 = (CompositeNode)stack.remove(stack.size() - 1);
                    node = (IfNode)ifStack.remove(ifStack.size() - 1);
                    continue;
                }
                if (tokens[0].equals("ifequal")) {
                    subMatcher = IFEQUAL_PATTERN.matcher(TemplateObjectModel.unwrap(matcher.group(2)));
                    if (!subMatcher.matches()) {
                        String string = String.valueOf(matcher.group(2));
                        throw new ParseException(string.length() != 0 ? "Cannot parse: ".concat(string) : new String("Cannot parse: "), 0);
                    }
                    node = new IfEqualNode(subMatcher.group(1), subMatcher.group(2));
                    TemplateObjectModel.append(stack, node);
                    stack.add(((IfEqualNode)node).onTrue);
                    ifStack.add((ForLoopNode)node);
                    continue;
                }
                if (tokens[0].equals("endifequal")) {
                    node2 = (CompositeNode)stack.remove(stack.size() - 1);
                    IfEqualNode ifEqualNode = (IfEqualNode)ifStack.remove(ifStack.size() - 1);
                    continue;
                }
                String string = String.valueOf(tokens[0]);
                throw new ParseException(string.length() != 0 ? "Unknown command: ".concat(string) : new String("Unknown command: "), 0);
            }
            if (matcher.group(3) != null) {
                CommentNode comment = new CommentNode();
                comment.subNode.add(new TextNode(TemplateObjectModel.unwrap(matcher.group(3))));
                TemplateObjectModel.append(stack, comment);
                continue;
            }
            if (matcher.group(4) != null) {
                TemplateObjectModel.append(stack, new TextNode(matcher.group(4)));
                continue;
            }
            String string = String.valueOf(matcher.group());
            throw new ParseException(string.length() != 0 ? "Unknown token: ".concat(string) : new String("Unknown token: "), 0);
        }
        if (stack.size() != 1) {
            throw new ParseException("Not all opened tags were closed", 0);
        }
        CompositeNode result = (CompositeNode)stack.get(0);
        result.blocks = blocks;
        result.baseTemplate = (CompositeNode)baseTemplate;
        return result;
    }

    static class ForLoopNode
    extends TemplateObjectModel {
        private final String[] variables;
        private final String iterateOn;
        TemplateObjectModel subTree = new CompositeNode();

        ForLoopNode(String variables, String iterateOn) {
            this.iterateOn = iterateOn;
            this.variables = variables.split(",");
            for (int i = 0; i < this.variables.length; ++i) {
                this.variables[i] = this.variables[i].trim();
            }
        }

        @Override
        void execute(Writer out, TemplateValueHelper helper) throws IOException {
            if (this.subTree == null) {
                return;
            }
            Object o = helper.getValue(this.iterateOn);
            if (o != null && !(o instanceof List)) {
                String string = this.iterateOn;
                String string2 = String.valueOf(o.getClass());
                String string3 = String.valueOf(o);
                throw new AssertionError((Object)new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(" should be a list, but was ").append(string2).append(": ").append(string3).toString());
            }
            List l = (List)o;
            if (l == null) {
                return;
            }
            TemplateValueHelper.Loop loop = helper.openLoop(l, this.variables);
            while (loop.hasCurrent()) {
                this.subTree.execute(out, helper);
                loop.next();
            }
            loop.close();
        }
    }

    static class IfEqualNode
    extends TemplateObjectModel {
        private String refArg1;
        private String refArg2;
        private String valArg1;
        private String valArg2;
        TemplateObjectModel onTrue = new CompositeNode();
        TemplateObjectModel onFalse = new CompositeNode();

        private static String asValOrNull(String val) {
            if ((val = val.trim()).startsWith("\"") && val.endsWith("\"") || val.startsWith("'") && val.endsWith("'")) {
                return val.substring(1, val.length() - 1);
            }
            return null;
        }

        private static Object getValue(TemplateValueHelper helper, String refArg, String valArg) {
            if (valArg != null) {
                return valArg;
            }
            return helper.getValue(refArg);
        }

        private Boolean eval(TemplateValueHelper helper) {
            Object o1 = IfEqualNode.getValue(helper, this.refArg1, this.valArg1);
            Object o2 = IfEqualNode.getValue(helper, this.refArg2, this.valArg2);
            if (o1 == null && o2 == null) {
                return true;
            }
            if (o1 != null && o2 != null && o1.equals(o2)) {
                return true;
            }
            return false;
        }

        public IfEqualNode(String arg1, String arg2) {
            this.valArg1 = IfEqualNode.asValOrNull(arg1);
            if (this.valArg1 == null) {
                this.refArg1 = arg1.trim();
            }
            this.valArg2 = IfEqualNode.asValOrNull(arg2);
            if (this.valArg2 == null) {
                this.refArg2 = arg2.trim();
            }
        }

        @Override
        void execute(Writer out, TemplateValueHelper helper) throws IOException {
            if (this.eval(helper).booleanValue()) {
                this.onTrue.execute(out, helper);
            } else {
                this.onFalse.execute(out, helper);
            }
        }
    }

    static class IfNode
    extends TemplateObjectModel {
        private String condition;
        TemplateObjectModel onTrue = new CompositeNode();
        TemplateObjectModel onFalse = new CompositeNode();

        IfNode(String condition) {
            this.condition = condition.trim();
        }

        @Override
        void execute(Writer out, TemplateValueHelper helper) throws IOException {
            if (helper.eval(this.condition)) {
                this.onTrue.execute(out, helper);
            } else {
                this.onFalse.execute(out, helper);
            }
        }
    }

    static class FieldNode
    extends TemplateObjectModel {
        private final String fieldExpression;

        FieldNode(String fieldExpression) {
            this.fieldExpression = fieldExpression;
        }

        @Override
        void execute(Writer out, TemplateValueHelper helper) throws IOException {
            out.write(helper.format(this.fieldExpression));
        }
    }

    static class TextNode
    extends TemplateObjectModel {
        private final String text;

        TextNode(String text) {
            this.text = text;
        }

        @Override
        void execute(Writer out, TemplateValueHelper helper) throws IOException {
            out.write(this.text);
        }
    }

    static class CommentNode
    extends TemplateObjectModel {
        CompositeNode subNode = new CompositeNode();

        CommentNode() {
        }

        @Override
        void execute(Writer out, TemplateValueHelper helper) {
        }
    }

    static class IncludeNode
    extends TemplateObjectModel {
        private final String toInclude;
        private final boolean isLiteral;

        IncludeNode(String includeThis) throws ParseException {
            if (includeThis.charAt(0) != '\"') {
                this.isLiteral = false;
                this.toInclude = includeThis;
                throw new ParseException("not supported yet", 0);
            }
            this.isLiteral = true;
            this.toInclude = includeThis.substring(1, includeThis.length() - 1).trim();
        }

        @Override
        void execute(Writer out, TemplateValueHelper helper) throws IOException {
            if (this.isLiteral) {
                try {
                    helper.getTemplateTool().getTemplate(this.toInclude, null).execute(out, helper);
                }
                catch (ParseException e) {
                    String string = String.valueOf(this.toInclude);
                    throw new IOException(string.length() != 0 ? "Could not load sub-template: ".concat(string) : new String("Could not load sub-template: "));
                }
            } else {
                throw new IOException("not supported yet");
            }
        }
    }

    static class CompositeNode
    extends TemplateObjectModel {
        private List<TemplateObjectModel> nodes = new ArrayList<TemplateObjectModel>();
        private String blockName;
        private Map<String, TemplateObjectModel> blocks;
        private CompositeNode baseTemplate;

        CompositeNode() {
        }

        CompositeNode add(TemplateObjectModel node) {
            this.nodes.add(node);
            return this;
        }

        @Override
        void execute(Writer out, TemplateValueHelper helper) throws IOException {
            TemplateObjectModel replacementBlock;
            this.registerBlocks(helper);
            if (this.baseTemplate != null) {
                this.baseTemplate.execute(out, helper);
                return;
            }
            if (this.blockName != null && (replacementBlock = helper.getBlock(this.blockName)) != this) {
                replacementBlock.execute(out, helper);
                return;
            }
            for (TemplateObjectModel node : this.nodes) {
                node.execute(out, helper);
            }
        }

        void registerBlocks(TemplateValueHelper helper) {
            if (this.blocks != null) {
                for (Map.Entry<String, TemplateObjectModel> block : this.blocks.entrySet()) {
                    helper.registerBlock(block.getKey(), block.getValue());
                }
            }
            if (this.baseTemplate != null) {
                this.baseTemplate.registerBlocks(helper);
            }
        }
    }
}

