/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.repackaged.com.google.protobuf.bridge.ProtoConverter;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.appengine.tools.appstats.ChannelRpcCostCalculator;
import com.google.appengine.tools.appstats.DatastoreRpcCostCalculator;
import com.google.appengine.tools.appstats.MailRpcCostCalculator;
import com.google.appengine.tools.appstats.PayloadRenderer;
import com.google.appengine.tools.appstats.RpcCostCalculator;
import com.google.appengine.tools.appstats.StaticRpcOperationCostManager;
import com.google.appengine.tools.appstats.StatsProtos;
import com.google.appengine.tools.appstats.XMPPRpcCostCalculator;
import com.google.apphosting.api.ApiStats;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

class RecordingData {
    private static final Map<String, RpcCostCalculator> COST_CALCULATOR_MAP;
    private StatsProtos.IndividualRpcStatsProto.Builder stats;
    private String packageName;
    private String methodName;
    private boolean calculateRpcCosts;
    private boolean datastoreDetails;
    private boolean wasSuccessful;
    private long durationMilliseconds;
    private Long apiMcyclesOrNull;
    private byte[] response;
    private Throwable exceptionOrError;
    private long overhead;
    private ApiStats apiStats;
    private boolean isProcessed;

    RecordingData() {
        this("", "", false, false);
    }

    RecordingData(String packageName, String methodName, boolean calculateRpcCosts, boolean datastoreDetails) {
        this.setPackageName(packageName);
        this.setMethodName(methodName);
        this.setCalculateRpcCosts(calculateRpcCosts);
        this.setDatastoreDetails(datastoreDetails);
    }

    void setDatastoreDetails(boolean datastoreDetails) {
        this.datastoreDetails = datastoreDetails;
    }

    ApiStats getApiStats() {
        return this.apiStats;
    }

    void setApiStats(ApiStats apiStats) {
        this.apiStats = apiStats;
    }

    StatsProtos.IndividualRpcStatsProto.Builder getStats() {
        return this.stats;
    }

    void setStats(StatsProtos.IndividualRpcStatsProto.Builder stats) {
        this.stats = stats;
    }

    String getPackageName() {
        return this.packageName;
    }

    void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    String getMethodName() {
        return this.methodName;
    }

    void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    void setCalculateRpcCosts(boolean calculateRpcCosts) {
        this.calculateRpcCosts = calculateRpcCosts;
    }

    boolean isWasSuccessful() {
        return this.wasSuccessful;
    }

    void setWasSuccessful(boolean wasSuccessful) {
        this.wasSuccessful = wasSuccessful;
    }

    long getDurationMilliseconds() {
        return this.durationMilliseconds;
    }

    void setDurationMilliseconds(long durationMilliseconds) {
        this.durationMilliseconds = durationMilliseconds;
    }

    Long getApiMcyclesOrNull() {
        return this.apiMcyclesOrNull;
    }

    void setApiMcyclesOrNull(Long apiMcyclesOrNull) {
        this.apiMcyclesOrNull = apiMcyclesOrNull;
    }

    byte[] getResponse() {
        return this.response;
    }

    void setResponse(byte[] response) {
        this.response = response;
    }

    Throwable getExceptionOrError() {
        return this.exceptionOrError;
    }

    void setExceptionOrError(Throwable exceptionOrError) {
        this.exceptionOrError = exceptionOrError;
    }

    long getOverhead() {
        return this.overhead;
    }

    void addOverhead(long overhead) {
        this.overhead += overhead;
    }

    boolean isProcessed() {
        return this.isProcessed;
    }

    void setProcessed() {
        this.isProcessed = true;
    }

    void storeResultData(PayloadRenderer payloadRenderer, byte[] request) {
        this.stats.setWasSuccessful(this.wasSuccessful);
        this.stats.setDurationMilliseconds(this.durationMilliseconds);
        if (this.apiMcyclesOrNull != null) {
            this.stats.setApiMcycles(this.apiMcyclesOrNull);
        }
        if (this.response != null) {
            this.stats.setResponseDataSummary(payloadRenderer.renderPayload(this.packageName, this.methodName, this.response, false));
            RpcCostCalculator rcc = COST_CALCULATOR_MAP.get(this.packageName);
            if (rcc != null && this.calculateRpcCosts) {
                RpcCostCalculator.RpcCost rpcCost = rcc.determineCost(this.methodName, request, this.response);
                this.stats.setCallCostMicrodollars(rpcCost.getCostMicropennies());
                for (StatsProtos.BilledOpProto billedOpProto : rpcCost.getBilledOps()) {
                    this.stats.addBilledOps(billedOpProto);
                }
            }
            if (this.datastoreDetails && this.packageName.equals("datastore_v3")) {
                this.recordDatastoreDetails(request);
            }
        }
        if (this.exceptionOrError != null) {
            StringWriter stackTrace = new StringWriter();
            this.exceptionOrError.printStackTrace(new PrintWriter(stackTrace));
            this.stats.setResponseDataSummary(stackTrace.toString());
        }
    }

    void recordDatastoreDetails(byte[] request) {
        if (this.methodName.equals("Put")) {
            this.recordPutDetails();
        } else if (this.methodName.equals("RunQuery") || this.methodName.equals("Next")) {
            this.recordQueryDetails(request);
        } else if (this.methodName.equals("Get")) {
            this.recordGetDetails(request);
        }
    }

    void recordPutDetails() {
        StatsProtos.DatastoreCallDetailsProto.Builder details = this.stats.getDatastoreDetailsBuilder();
        DatastorePb.PutResponse resultResponse = new DatastorePb.PutResponse();
        boolean parsed = resultResponse.mergeFrom(this.response);
        if (!parsed || !resultResponse.isInitialized()) {
            return;
        }
        ProtoConverter<OnestoreEntity.Reference, OnestoreEntity.Reference> bridge = this.protoConverter();
        for (OnestoreEntity.Reference key : resultResponse.keys()) {
            details.addKeysWritten((OnestoreEntity.Reference)bridge.convert(key));
        }
    }

    void recordGetDetails(byte[] request) {
        StatsProtos.DatastoreCallDetailsProto.Builder details = this.stats.getDatastoreDetailsBuilder();
        DatastorePb.GetRequest getRequest = new DatastorePb.GetRequest();
        boolean parsedRequest = getRequest.mergeFrom(request);
        if (!parsedRequest || !getRequest.isInitialized()) {
            return;
        }
        DatastorePb.GetResponse resultResponse = new DatastorePb.GetResponse();
        boolean parsedResponse = resultResponse.mergeFrom(this.response);
        if (!parsedResponse || !resultResponse.isInitialized()) {
            return;
        }
        ProtoConverter<OnestoreEntity.Reference, OnestoreEntity.Reference> bridge = this.protoConverter();
        for (OnestoreEntity.Reference key : getRequest.keys()) {
            details.addKeysRead((OnestoreEntity.Reference)bridge.convert(key));
        }
        for (DatastorePb.GetResponse.Entity entity : resultResponse.entitys()) {
            details.addGetSuccessfulFetch(entity.hasEntity());
        }
    }

    void recordQueryDetails(byte[] request) {
        StatsProtos.DatastoreCallDetailsProto.Builder details = this.stats.getDatastoreDetailsBuilder();
        DatastorePb.QueryResult queryResponse = new DatastorePb.QueryResult();
        boolean parsedResponse = queryResponse.mergeFrom(this.response);
        if (!parsedResponse || !queryResponse.isInitialized()) {
            return;
        }
        ProtoConverter<OnestoreEntity.Reference, OnestoreEntity.Reference> bridge = this.protoConverter();
        if (!queryResponse.isKeysOnly()) {
            for (OnestoreEntity.EntityProto entity : queryResponse.results()) {
                details.addKeysRead((OnestoreEntity.Reference)bridge.convert(entity.getKey()));
            }
        }
        if (this.methodName.equals("RunQuery")) {
            DatastorePb.Query queryRequest = new DatastorePb.Query();
            boolean parsed = queryRequest.mergeFrom(request);
            if (!parsed || !queryRequest.isInitialized()) {
                return;
            }
            if (queryRequest.hasKind()) {
                details.setQueryKind(queryRequest.getKind());
            }
            if (queryRequest.hasAncestor()) {
                details.setQueryAncestor((OnestoreEntity.Reference)bridge.convert(queryRequest.getAncestor()));
            }
            if (queryResponse.hasCursor()) {
                details.setQueryNextcursor(queryResponse.getCursor().getCursor());
            }
        } else if (this.methodName.equals("Next")) {
            DatastorePb.NextRequest nextRequest = new DatastorePb.NextRequest();
            boolean parsed = nextRequest.mergeFrom(request);
            if (!parsed || !nextRequest.isInitialized()) {
                return;
            }
            details.setQueryThiscursor(nextRequest.getCursor().getCursor());
            if (queryResponse.hasCursor()) {
                details.setQueryNextcursor(queryResponse.getCursor().getCursor());
            }
        }
    }

    private ProtoConverter<OnestoreEntity.Reference, OnestoreEntity.Reference> protoConverter() {
        return ProtoConverter.forProtos(OnestoreEntity.Reference.getDefaultInstance(), OnestoreEntity.Reference.getDefaultInstance());
    }

    static {
        StaticRpcOperationCostManager costMgr = new StaticRpcOperationCostManager();
        COST_CALCULATOR_MAP = new HashMap<String, RpcCostCalculator>();
        DatastoreRpcCostCalculator.register(COST_CALCULATOR_MAP, costMgr);
        MailRpcCostCalculator.register(COST_CALCULATOR_MAP, costMgr);
        ChannelRpcCostCalculator.register(COST_CALCULATOR_MAP, costMgr);
        XMPPRpcCostCalculator.register(COST_CALCULATOR_MAP, costMgr);
    }
}

