/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.tools.appstats.AppstatsSettings;
import com.google.appengine.tools.appstats.PayloadRenderer;
import com.google.appengine.tools.appstats.RecordingData;
import com.google.appengine.tools.appstats.RecordingFuture;
import com.google.appengine.tools.appstats.StatsProtos;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.ApiStats;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class Recorder
implements ApiProxy.Delegate {
    static final String CURRENT_NAMESPACE_KEY = String.valueOf(NamespaceManager.class.getName()).concat(".currentNamespace");
    static final String KEY = Recorder.class.getName();
    private static final Pattern STACK_PATTERN = Pattern.compile("\\s*at\\s([^\\(]+)[^:]+:([^\\)]+)\\)\\s*");
    private final Clock clock;
    private final ApiProxy.Delegate wrappedDelegate;
    private final RecordWriter writer;
    private final AppstatsSettings settings;

    static void createStackTrace(int numLinesToIgnore, StatsProtos.IndividualRpcStatsProto.Builder stats, int maxNumLines) {
        StringWriter stack = new StringWriter();
        new Exception().printStackTrace(new PrintWriter(stack));
        Matcher matcher = STACK_PATTERN.matcher(stack.toString());
        while (matcher.find() && stats.getCallStackCount() < maxNumLines) {
            if (numLinesToIgnore > 0) {
                --numLinesToIgnore;
                continue;
            }
            String classAndMethod = matcher.group(1);
            int lastDot = classAndMethod.lastIndexOf(46);
            String lineNumber = matcher.group(2);
            StatsProtos.StackFrameProto.Builder builder = StatsProtos.StackFrameProto.newBuilder();
            builder.setClassOrFileName(classAndMethod.substring(0, lastDot));
            builder.setFunctionName(classAndMethod.substring(lastDot + 1));
            try {
                builder.setLineNumber(Integer.parseInt(lineNumber));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            stats.addCallStack(builder);
        }
    }

    public Recorder(ApiProxy.Delegate<?> wrapThis, RecordWriter writer, AppstatsSettings settings) {
        this(wrapThis, writer, Clock.INSTANCE, settings);
    }

    Recorder(ApiProxy.Delegate<?> wrapThis, RecordWriter writer, Clock clock, AppstatsSettings settings) {
        this.wrappedDelegate = Preconditions.checkNotNull(wrapThis);
        this.clock = Preconditions.checkNotNull(clock);
        this.writer = Preconditions.checkNotNull(writer);
        this.settings = Preconditions.checkNotNull(settings);
    }

    public void log(ApiProxy.Environment environment, ApiProxy.LogRecord record) {
        this.wrappedDelegate.log(environment, record);
    }

    public void flushLogs(ApiProxy.Environment environment) {
        this.wrappedDelegate.flushLogs(environment);
    }

    public List<Thread> getRequestThreads(ApiProxy.Environment environment) {
        return this.wrappedDelegate.getRequestThreads(environment);
    }

    int getMaxLinesOfStackTrace() {
        return this.settings.getMaxLinesOfStackTrace();
    }

    PayloadRenderer getPayloadRenderer() {
        return this.settings.getPayloadRenderer();
    }

    private void initializeIntermediary(ApiProxy.Environment environment, byte[] request, long preNow, RecordingData intermediary) {
        StatsProtos.IndividualRpcStatsProto.Builder stats = this.newBuilder();
        intermediary.setStats(stats);
        String string = intermediary.getPackageName();
        String string2 = intermediary.getMethodName();
        stats.setServiceCallName(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString());
        if (environment.getAttributes() != null && environment.getAttributes().containsKey(CURRENT_NAMESPACE_KEY)) {
            stats.setNamespace((String)environment.getAttributes().get(CURRENT_NAMESPACE_KEY));
        }
        stats.setRequestDataSummary(this.settings.getPayloadRenderer().renderPayload(intermediary.getPackageName(), intermediary.getMethodName(), request, true));
        stats.setStartOffsetMilliseconds(this.clock.currentTimeMillis());
        Recorder.createStackTrace(2, stats, this.settings.getMaxLinesOfStackTrace());
        ApiStats apiStats = this.getApiStats(environment);
        intermediary.setApiMcyclesOrNull(apiStats == null ? null : Long.valueOf(apiStats.getApiTimeInMegaCycles()));
        intermediary.setApiStats(apiStats);
        intermediary.addOverhead(stats.getStartOffsetMilliseconds() - preNow);
    }

    public Future<byte[]> makeAsyncCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] request, ApiProxy.ApiConfig apiConfig) {
        long preNow = this.clock.currentTimeMillis();
        RecordingData intermediary = new RecordingData(packageName, methodName, this.settings.isCalculateRpcCosts(), this.settings.isDatastoreDetails());
        this.initializeIntermediary(environment, request, preNow, intermediary);
        Future wrappedFuture = this.wrappedDelegate.makeAsyncCall(environment, packageName, methodName, request, apiConfig);
        RecordingFuture wrappingFuture = RecordingFuture.of(wrappedFuture, intermediary, this, environment, request);
        this.getStashedFutures(environment).add(wrappingFuture);
        return wrappingFuture;
    }

    public byte[] makeSyncCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] request) throws ApiProxy.ApiProxyException {
        long preNow = this.clock.currentTimeMillis();
        RecordingData intermediary = new RecordingData(packageName, methodName, this.settings.isCalculateRpcCosts(), this.settings.isDatastoreDetails());
        this.initializeIntermediary(environment, request, preNow, intermediary);
        StatsProtos.IndividualRpcStatsProto.Builder stats = intermediary.getStats();
        try {
            intermediary.setResponse(this.wrappedDelegate.makeSyncCall(environment, packageName, methodName, request));
            intermediary.setWasSuccessful(true);
        }
        catch (Throwable t) {
            intermediary.setExceptionOrError(t);
            intermediary.setWasSuccessful(false);
        }
        intermediary.setDurationMilliseconds(this.clock.currentTimeMillis() - stats.getStartOffsetMilliseconds());
        preNow = this.clock.currentTimeMillis();
        if (intermediary.getApiStats() != null) {
            intermediary.setApiMcyclesOrNull(intermediary.getApiStats().getApiTimeInMegaCycles() - intermediary.getApiMcyclesOrNull());
        }
        intermediary.storeResultData(this.settings.getPayloadRenderer(), request);
        intermediary.addOverhead(this.clock.currentTimeMillis() - preNow);
        this.writer.write(this.wrappedDelegate, environment, stats, intermediary.getOverhead(), true);
        Throwable exceptionOrError = intermediary.getExceptionOrError();
        if (exceptionOrError != null) {
            if (exceptionOrError instanceof Error) {
                throw (Error)exceptionOrError;
            }
            if (exceptionOrError instanceof ApiProxy.ApiProxyException) {
                throw (ApiProxy.ApiProxyException)exceptionOrError;
            }
            if (exceptionOrError instanceof RuntimeException) {
                throw (RuntimeException)exceptionOrError;
            }
            throw new AssertionError((Object)exceptionOrError);
        }
        return intermediary.getResponse();
    }

    StatsProtos.IndividualRpcStatsProto.Builder newBuilder() {
        return StatsProtos.IndividualRpcStatsProto.newBuilder();
    }

    ApiStats getApiStats(ApiProxy.Environment environment) {
        return ApiStats.get((ApiProxy.Environment)environment);
    }

    Collection<RecordingFuture> getStashedFutures(ApiProxy.Environment environment) {
        HashSet<RecordingFuture> futures = (HashSet<RecordingFuture>)environment.getAttributes().get(KEY);
        if (futures == null) {
            futures = Sets.newHashSet();
            environment.getAttributes().put(KEY, futures);
        }
        return futures;
    }

    void processAsyncRpc(RecordingFuture future, ApiProxy.Environment environment) {
        if (!future.getRecordingData().isProcessed()) {
            this.processRecordingFuture(future, environment);
        }
        this.getStashedFutures(environment).remove(future);
    }

    void processAsyncRpcs(ApiProxy.Environment environment) {
        Collection<RecordingFuture> futures = this.getStashedFutures(environment);
        for (RecordingFuture current : new ArrayList<RecordingFuture>(futures)) {
            if (!current.getRecordingData().isProcessed()) {
                this.processRecordingFuture(current, environment);
            }
            futures.remove(current);
        }
    }

    private void processRecordingFuture(RecordingFuture current, ApiProxy.Environment environment) {
        RecordingData recordingData = current.getRecordingData();
        if (current.isDone() || current.isCancelled()) {
            recordingData.setProcessed();
            try {
                recordingData.setResponse(current.get());
                recordingData.setWasSuccessful(true);
            }
            catch (InterruptedException e) {
                recordingData.setExceptionOrError(e);
                recordingData.setWasSuccessful(false);
            }
            catch (ExecutionException e) {
                recordingData.setExceptionOrError(e);
                recordingData.setWasSuccessful(false);
            }
            catch (CancellationException e) {
                recordingData.setExceptionOrError(e);
                recordingData.setWasSuccessful(false);
            }
            if (current instanceof ApiProxy.ApiResultFuture) {
                ApiProxy.ApiResultFuture future = (ApiProxy.ApiResultFuture)current;
                recordingData.setDurationMilliseconds(future.getWallclockTimeInMillis());
                recordingData.setApiMcyclesOrNull(future.getCpuTimeInMegaCycles());
            } else {
                recordingData.setDurationMilliseconds(this.clock.currentTimeMillis() - recordingData.getStats().getStartOffsetMilliseconds());
            }
            recordingData.storeResultData(this.settings.getPayloadRenderer(), current.getRequest());
            this.writer.write(this.wrappedDelegate, environment, recordingData.getStats(), recordingData.getOverhead(), true);
        } else {
            try {
                this.settings.getUnprocessedFutureStrategy().onUnprocessedFuture(current);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    public static class Clock {
        public static final Clock INSTANCE = new Clock();

        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    }

    public static interface RecordWriter {
        public long begin(ApiProxy.Delegate<?> var1, ApiProxy.Environment var2, HttpServletRequest var3);

        public boolean commit(ApiProxy.Delegate<?> var1, ApiProxy.Environment var2, int var3);

        public void write(ApiProxy.Delegate<?> var1, ApiProxy.Environment var2, StatsProtos.IndividualRpcStatsProto.Builder var3, long var4, boolean var6);

        public List<StatsProtos.RequestStatProto> getSummaries();

        public StatsProtos.RequestStatProto getFull(long var1);
    }

    static enum UnprocessedFutureStrategy {
        DO_NOTHING{

            @Override
            void onUnprocessedFuture(RecordingFuture future) {
                future.getRecordingData().setProcessed();
            }
        }
        ,
        WAIT_UNTIL_FINISHED{

            @Override
            void onUnprocessedFuture(RecordingFuture future) throws InterruptedException, ExecutionException {
                future.get();
            }
        };


        abstract void onUnprocessedFuture(RecordingFuture var1) throws InterruptedException, ExecutionException;
    }
}

