/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.tools.appstats.NullPayloadRenderer;
import com.google.appengine.tools.appstats.PayloadRenderer;
import com.google.appengine.tools.appstats.Recorder;

final class AppstatsSettings {
    private static final PayloadRenderer DEFAULT_RENDERER = new NullPayloadRenderer();
    private PayloadRenderer payloadRenderer;
    private Recorder.UnprocessedFutureStrategy unprocessedFutureStrategy;
    private boolean calculateRpcCosts;
    private boolean datastoreDetails;
    private int maxLinesOfStackTrace;

    private AppstatsSettings() {
    }

    static AppstatsSettings withDefault() {
        AppstatsSettings settings = new AppstatsSettings();
        settings.setPayloadRenderer(DEFAULT_RENDERER);
        settings.setDatastoreDetails(false);
        settings.setCalculateRpcCosts(false);
        settings.setUnprocessedFutureStrategy(Recorder.UnprocessedFutureStrategy.DO_NOTHING);
        settings.setMaxLinesOfStackTrace(Integer.MAX_VALUE);
        return settings;
    }

    PayloadRenderer getPayloadRenderer() {
        return this.payloadRenderer;
    }

    Recorder.UnprocessedFutureStrategy getUnprocessedFutureStrategy() {
        return this.unprocessedFutureStrategy;
    }

    boolean isCalculateRpcCosts() {
        return this.calculateRpcCosts;
    }

    boolean isDatastoreDetails() {
        return this.datastoreDetails;
    }

    int getMaxLinesOfStackTrace() {
        return this.maxLinesOfStackTrace;
    }

    void setPayloadRenderer(String payloadRenderer) {
        try {
            this.payloadRenderer = (PayloadRenderer)Class.forName(payloadRenderer).newInstance();
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw new IllegalArgumentException("Cannot instantiate payloadRenderer", e);
        }
    }

    void setUnprocessedFutureStrategy(String unprocessedFutureStrategy) {
        this.unprocessedFutureStrategy = Recorder.UnprocessedFutureStrategy.valueOf(unprocessedFutureStrategy);
    }

    void setCalculateRpcCosts(String calculateRpcCosts) {
        this.calculateRpcCosts = Boolean.parseBoolean(calculateRpcCosts);
    }

    void setDatastoreDetails(String datastoreDetails) {
        this.datastoreDetails = Boolean.parseBoolean(datastoreDetails);
    }

    void setPayloadRenderer(PayloadRenderer payloadRenderer) {
        this.payloadRenderer = payloadRenderer;
    }

    void setUnprocessedFutureStrategy(Recorder.UnprocessedFutureStrategy unprocessedFutureStrategy) {
        this.unprocessedFutureStrategy = unprocessedFutureStrategy;
    }

    void setCalculateRpcCosts(boolean calculateRpcCosts) {
        this.calculateRpcCosts = calculateRpcCosts;
    }

    void setDatastoreDetails(boolean datastoreDetails) {
        this.datastoreDetails = datastoreDetails;
    }

    void setMaxLinesOfStackTrace(int maxLinesOfStackTrace) {
        this.maxLinesOfStackTrace = maxLinesOfStackTrace;
    }
}

