/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.datastore.overlay;

import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.DatastoreAttributes;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.api.labs.datastore.overlay.FakeFutureTask;
import com.google.appengine.api.labs.datastore.overlay.IncompleteKey;
import com.google.appengine.api.labs.datastore.overlay.OverlayAsyncDatastoreService;
import com.google.appengine.api.labs.datastore.overlay.OverlayPreparedQueryImpl;
import com.google.appengine.api.labs.datastore.overlay.OverlayUtils;
import com.google.appengine.api.labs.datastore.overlay.RethrowingFutureWrapper;
import com.google.appengine.api.labs.datastore.overlay.TransactionLinkedAsyncDatastoreServiceImpl;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

final class OverlayAsyncDatastoreServiceImpl
implements OverlayAsyncDatastoreService {
    private final String name;
    private final AsyncDatastoreService datastore;
    private final AsyncDatastoreService parent;

    OverlayAsyncDatastoreServiceImpl(String name, AsyncDatastoreService datastore, AsyncDatastoreService parent) {
        this.name = Preconditions.checkNotNull(name);
        this.datastore = Preconditions.checkNotNull(datastore);
        this.parent = Preconditions.checkNotNull(parent);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public AsyncDatastoreService getParentDatastoreService() {
        return this.parent;
    }

    public Future<Entity> get(Key key) {
        Preconditions.checkNotNull(key);
        return this.getImpl(this.datastore, key);
    }

    public Future<Entity> get(Transaction txn, Key key) {
        Preconditions.checkNotNull(key);
        return this.getImpl(this.getTxnAsyncDatastore(txn), key);
    }

    public Future<Map<Key, Entity>> get(Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        return this.getImpl(this.datastore, keys);
    }

    public Future<Map<Key, Entity>> get(Transaction txn, Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        return this.getImpl(this.getTxnAsyncDatastore(txn), keys);
    }

    private Future<Entity> getImpl(AsyncDatastoreService datastore, final Key key) {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(key);
        return new RethrowingFutureWrapper<Map<Key, Entity>, Entity>(this, this.getImpl(datastore, ImmutableList.of(key))){

            protected Entity wrap(Map<Key, Entity> entityMap) throws Exception {
                Entity entity = entityMap.get(key);
                if (entity == null) {
                    throw new EntityNotFoundException(key);
                }
                return entity;
            }
        };
    }

    private Future<Map<Key, Entity>> getImpl(AsyncDatastoreService datastore, final Iterable<Key> keys) {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(keys);
        return new RethrowingFutureWrapper<Map<Key, Entity>, Map<Key, Entity>>(datastore.get(OverlayUtils.getKeysAndTombstoneKeys(keys))){

            protected Map<Key, Entity> wrap(Map<Key, Entity> results) throws Exception {
                HashSet remainingKeys = Sets.newHashSet(keys);
                Iterator<Map.Entry<Key, Entity>> entryIterator = results.entrySet().iterator();
                while (entryIterator.hasNext()) {
                    Map.Entry<Key, Entity> entry = entryIterator.next();
                    if (OverlayUtils.isTombstone(entry.getValue())) {
                        entryIterator.remove();
                        remainingKeys.remove(OverlayUtils.getKeyFromTombstoneKey(entry.getKey()));
                        continue;
                    }
                    remainingKeys.remove(entry.getKey());
                }
                results.putAll((Map)FutureHelper.quietGet((Future)OverlayAsyncDatastoreServiceImpl.this.parent.get(null, remainingKeys)));
                return results;
            }
        };
    }

    public Future<Key> put(Entity entity) {
        Preconditions.checkNotNull(entity);
        return this.putImpl(this.datastore, entity);
    }

    public Future<Key> put(Transaction txn, Entity entity) {
        Preconditions.checkNotNull(entity);
        return this.putImpl(this.getTxnAsyncDatastore(txn), entity);
    }

    public Future<List<Key>> put(Iterable<Entity> entities) {
        Preconditions.checkNotNull(entities);
        return this.putImpl(this.datastore, entities);
    }

    public Future<List<Key>> put(Transaction txn, Iterable<Entity> entities) {
        Preconditions.checkNotNull(entities);
        return this.putImpl(this.getTxnAsyncDatastore(txn), entities);
    }

    private Future<Key> putImpl(AsyncDatastoreService datastore, Entity entity) {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(entity);
        Future<List<Key>> futureKeys = this.putImpl(datastore, ImmutableList.of(entity));
        return new RethrowingFutureWrapper<List<Key>, Key>(this, futureKeys){

            protected Key wrap(List<Key> keys) throws Exception {
                return keys.get(0);
            }
        };
    }

    private Future<List<Key>> putImpl(final AsyncDatastoreService datastore, final Iterable<Entity> entities) {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(entities);
        return new FakeFutureTask<List<Key>>(){

            @Override
            public List<Key> call() throws Exception {
                Future futureDelete = datastore.delete(OverlayUtils.getTombstoneKeysForEntities(OverlayUtils.getEntitiesWithPreexistingCompleteKeys(entities)));
                Map<IncompleteKey, Integer> idsNeededMap = OverlayUtils.getIdsNeededMap(entities);
                HashMap<IncompleteKey, Future<KeyRange>> idsAllocatedFutureMap = Maps.newHashMap();
                for (Map.Entry<IncompleteKey, Integer> entry : idsNeededMap.entrySet()) {
                    IncompleteKey incompleteKey = entry.getKey();
                    idsAllocatedFutureMap.put(incompleteKey, OverlayAsyncDatastoreServiceImpl.this.allocateIds(incompleteKey.parent, incompleteKey.kind, entry.getValue().intValue()));
                }
                HashMap<IncompleteKey, Iterator<Key>> idsAllocatedMap = Maps.newHashMap();
                for (Map.Entry entry : idsAllocatedFutureMap.entrySet()) {
                    idsAllocatedMap.put((IncompleteKey)entry.getKey(), ((KeyRange)FutureHelper.quietGet((Future)((Future)entry.getValue()))).iterator());
                }
                Future future = datastore.put(OverlayUtils.translateAndCompleteEntityKeys(entities, idsAllocatedMap));
                FutureHelper.quietGet((Future)futureDelete);
                return (List)FutureHelper.quietGet((Future)future);
            }
        };
    }

    public Future<Void> delete(Key ... keys) {
        Preconditions.checkNotNull(keys);
        return this.delete(ImmutableList.copyOf(keys));
    }

    public Future<Void> delete(Transaction txn, Key ... keys) {
        Preconditions.checkNotNull(keys);
        return this.delete(txn, ImmutableList.copyOf(keys));
    }

    public Future<Void> delete(Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        return this.deleteImpl(this.datastore, keys);
    }

    public Future<Void> delete(Transaction txn, Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        return this.deleteImpl(this.getTxnAsyncDatastore(txn), keys);
    }

    private Future<Void> deleteImpl(AsyncDatastoreService datastore, Iterable<Key> keys) {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(keys);
        Future futurePut = datastore.put(OverlayUtils.getTombstonesForKeys(keys));
        final Future futureDelete = datastore.delete(keys);
        return new RethrowingFutureWrapper<List<Key>, Void>(this, futurePut){

            protected Void wrap(List<Key> tombstoneKeys) throws Exception {
                return (Void)FutureHelper.quietGet((Future)futureDelete);
            }
        };
    }

    public Future<Transaction> beginTransaction() {
        return this.datastore.beginTransaction();
    }

    public Future<Transaction> beginTransaction(TransactionOptions options) {
        return this.datastore.beginTransaction(options);
    }

    public Future<KeyRange> allocateIds(String kind, long num) {
        Preconditions.checkNotNull(kind);
        return this.parent.allocateIds(kind, num);
    }

    public Future<KeyRange> allocateIds(Key parent, String kind, long num) {
        Preconditions.checkNotNull(kind);
        return this.parent.allocateIds(parent, kind, num);
    }

    public Future<DatastoreAttributes> getDatastoreAttributes() {
        return this.datastore.getDatastoreAttributes();
    }

    public Future<Map<Index, Index.IndexState>> getIndexes() {
        return this.datastore.getIndexes();
    }

    public PreparedQuery prepare(Query query) {
        Preconditions.checkNotNull(query);
        return this.prepare(null, query);
    }

    public PreparedQuery prepare(Transaction txn, Query query) {
        PreparedQuery preparedOverlayQuery = this.datastore.prepare(txn, query);
        PreparedQuery preparedParentQuery = this.getParentDatastoreService().prepare(null, query);
        return new OverlayPreparedQueryImpl(this, query, preparedOverlayQuery, preparedParentQuery, txn);
    }

    public Transaction getCurrentTransaction() {
        return this.datastore.getCurrentTransaction();
    }

    public Transaction getCurrentTransaction(Transaction returnedIfNoTxn) {
        return this.datastore.getCurrentTransaction(returnedIfNoTxn);
    }

    public Collection<Transaction> getActiveTransactions() {
        return this.datastore.getActiveTransactions();
    }

    Map<Key, Entity> getFromOverlayOnly(Transaction txn, Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        try {
            return (Map)this.datastore.get(txn, keys).get();
        }
        catch (Exception e) {
            return Maps.newHashMap();
        }
    }

    private AsyncDatastoreService getTxnAsyncDatastore(Transaction txn) {
        return new TransactionLinkedAsyncDatastoreServiceImpl(this.datastore, txn);
    }
}

