/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.datastore.overlay;

import com.google.appengine.api.labs.datastore.overlay.IdAllocationPolicyInterface;

enum IdAllocationPolicy implements IdAllocationPolicyInterface
{
    SEQUENTIAL(IdAllocationPolicy.newSequentialPolicy(0)),
    SCATTERED(IdAllocationPolicy.newScatteredPolicy(0)),
    OVERLAY_SEQUENTIAL(IdAllocationPolicy.newSequentialPolicy(1)),
    OVERLAY_SCATTERED(IdAllocationPolicy.newScatteredPolicy(1));

    private final IdAllocationPolicyInterface policy;

    public static long overlayIdFromDefaultId(long id) {
        if (SEQUENTIAL.containsId(id)) {
            return OVERLAY_SEQUENTIAL.counterToId(SEQUENTIAL.idToCounter(id));
        }
        if (SCATTERED.containsId(id)) {
            return OVERLAY_SCATTERED.counterToId(SCATTERED.idToCounter(id));
        }
        String string = String.valueOf(Long.toHexString(id));
        throw new IllegalArgumentException(string.length() != 0 ? "ID does not conform to a known default allocation policy: ".concat(string) : new String("ID does not conform to a known default allocation policy: "));
    }

    private IdAllocationPolicy(IdAllocationPolicyInterface policy) {
        this.policy = policy;
    }

    @Override
    public boolean containsId(long id) {
        return this.policy.containsId(id);
    }

    @Override
    public long getMaximumCounterValue() {
        return this.policy.getMaximumCounterValue();
    }

    @Override
    public long counterToId(long counter) {
        return this.policy.counterToId(counter);
    }

    @Override
    public long idToCounter(long id) {
        return this.policy.idToCounter(id);
    }

    private static IdAllocationPolicyInterface newSequentialPolicy(int depth) {
        final long minId = IdAllocationPolicy.minSequentialId(depth);
        final long maxCounterValue = (1L << IdAllocationPolicy.maxSequentialBit(depth)) - 1L;
        final long maxId = minId + maxCounterValue;
        return new IdAllocationPolicyInterface(){

            @Override
            public boolean containsId(long id) {
                return id >= minId && id <= maxId;
            }

            @Override
            public long getMaximumCounterValue() {
                return maxCounterValue;
            }

            @Override
            public long counterToId(long counter) {
                IdAllocationPolicy.checkCounterBounds(this, counter);
                return minId + counter;
            }

            @Override
            public long idToCounter(long id) {
                IdAllocationPolicy.checkIdBounds(this, id);
                return id - minId;
            }
        };
    }

    private static IdAllocationPolicyInterface newScatteredPolicy(int depth) {
        long maxBit = IdAllocationPolicy.maxScatteredBit(depth);
        final long maxCounterValue = (1L << (int)maxBit) - 1L;
        final long minId = IdAllocationPolicy.minScatteredId(depth);
        final long maxId = minId + maxCounterValue;
        final long scatterShift = 64L - maxBit;
        return new IdAllocationPolicyInterface(){

            @Override
            public boolean containsId(long id) {
                return id >= minId && id <= maxId;
            }

            @Override
            public long getMaximumCounterValue() {
                return maxCounterValue;
            }

            @Override
            public long counterToId(long counter) {
                IdAllocationPolicy.checkCounterBounds(this, counter);
                return minId + Long.reverse(counter << (int)scatterShift);
            }

            @Override
            public long idToCounter(long id) {
                IdAllocationPolicy.checkIdBounds(this, id);
                return Long.reverse(id) >>> (int)scatterShift;
            }
        };
    }

    private static int maxSequentialBit(int depth) {
        return 52 - 3 * depth;
    }

    private static long minSequentialId(int depth) {
        long prefix = 0L;
        for (int i = 0; i < depth; ++i) {
            prefix = (prefix << 3) + 6L;
        }
        return prefix << IdAllocationPolicy.maxSequentialBit(depth) + 1;
    }

    private static int maxScatteredBit(int depth) {
        return IdAllocationPolicy.maxSequentialBit(depth) - 1;
    }

    private static long minScatteredId(int depth) {
        return IdAllocationPolicy.minSequentialId(depth) + (1L << IdAllocationPolicy.maxSequentialBit(depth));
    }

    private static void checkCounterBounds(IdAllocationPolicyInterface policy, long counter) {
        if (counter < 1L) {
            String string = Long.toHexString(counter);
            throw new IllegalArgumentException(new StringBuilder(25 + String.valueOf(string).length()).append("Counter ").append(string).append(" is non-positive.").toString());
        }
        if (counter > policy.getMaximumCounterValue()) {
            String string = Long.toHexString(counter);
            String string2 = Long.toHexString(policy.getMaximumCounterValue());
            throw new IllegalArgumentException(new StringBuilder(40 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Counter ").append(string).append(" exceeds maximum counter value ").append(string2).append(".").toString());
        }
    }

    private static void checkIdBounds(IdAllocationPolicyInterface policy, long id) {
        if (!policy.containsId(id)) {
            String string = policy.getClass().getName();
            String string2 = Long.toHexString(id);
            throw new IllegalArgumentException(new StringBuilder(43 + String.valueOf(string).length() + String.valueOf(string2).length()).append("ID does not conform to allocation policy ").append(string).append(": ").append(string2).toString());
        }
    }
}

