/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.api.xmpp.XMPPServicePb;
import com.google.appengine.tools.appstats.RpcCostCalculator;
import com.google.appengine.tools.appstats.RpcOperationCostManager;
import com.google.appengine.tools.appstats.StatsProtos;
import java.util.Arrays;
import java.util.Map;

class XMPPRpcCostCalculator
implements RpcCostCalculator {
    private static final String PKG = "xmpp";
    private final long costPerStanzaMicropennies;
    private final StatsProtos.BilledOpProto singleCostOpProto = StatsProtos.BilledOpProto.newBuilder().setNumOps(1).setOp(StatsProtos.BilledOpProto.BilledOp.XMPP_STANZA).build();

    XMPPRpcCostCalculator(long costPerStanzaMicropennies) {
        this.costPerStanzaMicropennies = costPerStanzaMicropennies;
    }

    @Override
    public RpcCostCalculator.RpcCost determineCost(String methodName, byte[] request, byte[] response) {
        if (methodName.equals("SendMessage")) {
            XMPPServicePb.XmppMessageRequest proto = new XMPPServicePb.XmppMessageRequest();
            boolean parsed = proto.parseFrom(request);
            if (!parsed || !proto.isInitialized()) {
                throw new IllegalArgumentException("Could not parse XmppMessageRequest");
            }
            StatsProtos.BilledOpProto billedOpProto = StatsProtos.BilledOpProto.newBuilder().setNumOps(proto.jidSize()).setOp(StatsProtos.BilledOpProto.BilledOp.XMPP_STANZA).build();
            return new RpcCostCalculator.RpcCost(this.costPerStanzaMicropennies * (long)proto.jidSize(), Arrays.asList(billedOpProto));
        }
        if (methodName.equals("GetPresence") || methodName.equals("SendPresence") || methodName.equals("SendInvite")) {
            return new RpcCostCalculator.RpcCost(this.costPerStanzaMicropennies, Arrays.asList(this.singleCostOpProto));
        }
        return FREE;
    }

    static void register(Map<String, RpcCostCalculator> costCalculatorMap, RpcOperationCostManager opCostMgr) {
        costCalculatorMap.put(PKG, new XMPPRpcCostCalculator(opCostMgr.costOf(StatsProtos.BilledOpProto.BilledOp.XMPP_STANZA)));
    }
}

