/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.repackaged.org.json.JSONArray;
import com.google.appengine.repackaged.org.json.JSONException;
import com.google.appengine.repackaged.org.json.JSONObject;
import com.google.appengine.tools.appstats.StatsProtos;
import com.google.appengine.tools.appstats.StatsUtil;
import com.google.appengine.tools.appstats.TemplateTool;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class Renderer {
    private final TemplateTool templateTool;
    private final Logger log = Logger.getLogger(this.getClass().getName());

    public Renderer() {
        this(false);
    }

    Renderer(boolean strict) {
        this.templateTool = new TemplateTool(new TemplateTool.Option[]{strict ? TemplateTool.Option.STRICT : TemplateTool.Option.NON_STRICT}){
            private final String prefix = "/apphosting/ext/appstats/templates/";
            {
                this.prefix = "/apphosting/ext/appstats/templates/";
            }

            @Override
            protected CharSequence loadTemplateSource(String name) throws IOException {
                String string = String.valueOf("/apphosting/ext/appstats/templates/");
                String string2 = String.valueOf(name);
                return super.loadTemplateSource(string2.length() != 0 ? string.concat(string2) : new String(string));
            }

            @Override
            public void format(Map<String, ?> parameters, Writer out, String templateName, String ... parents) throws IOException, ParseException {
                HashMap extendedParams = new HashMap(parameters);
                HashMap<String, String> env = new HashMap<String, String>();
                extendedParams.put("env", env);
                env.put("APPLICATION_ID", Renderer.this.getAppId());
                env.put("CURRENT_VERSION_ID", Renderer.this.getCurrentVersionId());
                super.format(extendedParams, out, templateName, parents);
            }
        };
    }

    String getAppId() {
        return ApiProxy.getCurrentEnvironment().getAppId();
    }

    String getCurrentVersionId() {
        return ApiProxy.getCurrentEnvironment().getVersionId();
    }

    public void renderSummaries(Writer out, List<StatsProtos.RequestStatProto> summaries) throws IOException {
        try {
            this.templateTool.format(StatsUtil.createSummaryStats(summaries), out, "main.html", new String[0]);
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void renderDetails(Writer out, StatsProtos.RequestStatProto detailedStats) throws IOException {
        try {
            this.templateTool.format(StatsUtil.createDetailedStats(detailedStats), out, "details.html", new String[0]);
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean renderDetailsAsJson(Writer out, StatsProtos.RequestStatProto detailedStats) {
        JSONObject json = new JSONObject();
        try {
            json.put("http_method", detailedStats.getHttpMethod());
            json.put("http_status", detailedStats.getHttpStatus());
            json.put("http_path", detailedStats.getHttpPath());
            json.put("http_query", detailedStats.getHttpQuery());
            json.put("duration", detailedStats.getDurationMilliseconds());
            json.put("format", "appstats");
            json.put("processor_total", StatsUtil.megaCyclesToMilliseconds(detailedStats.getProcessorMcycles()));
            JSONArray statsArray = new JSONArray();
            for (StatsProtos.IndividualRpcStatsProto stat : detailedStats.getIndividualStatsList()) {
                JSONObject statJson = new JSONObject();
                statJson.put("name", stat.getServiceCallName());
                statJson.put("success", stat.getWasSuccessful());
                statJson.put("start", stat.getStartOffsetMilliseconds());
                statJson.put("duration", stat.getDurationMilliseconds());
                if (stat.hasCallCostMicrodollars()) {
                    statJson.put("cost_micropennies", stat.getCallCostMicrodollars());
                }
                statsArray.put(statJson);
            }
            json.put("children", statsArray);
            json.write(out);
            return true;
        }
        catch (JSONException e) {
            String string = e.getMessage();
            this.log.logp(Level.FINE, "com.google.appengine.tools.appstats.Renderer", "renderDetailsAsJson", new StringBuilder(24 + String.valueOf(string).length()).append("Unable to create JSON (").append(string).append(")").toString());
            return false;
        }
    }
}

