/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.tools.appstats.AppstatsSettings;
import com.google.appengine.tools.appstats.MemcacheWriter;
import com.google.appengine.tools.appstats.Recorder;
import com.google.appengine.tools.appstats.RecordingData;
import com.google.appengine.tools.appstats.StatsProtos;
import com.google.apphosting.api.ApiProxy;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;

public final class Recording {
    private final Recorder.RecordWriter writer;
    private final Recorder.Clock clock = new Recorder.Clock();
    private final AppstatsSettings settings;
    static final String RECORDING_KEY = String.valueOf(Recording.class.getName()).concat(".recording_key");
    static final String CUSTOM_RECORDING_KEY = String.valueOf(Recording.class.getName()).concat(".custom");

    public static Recording get() {
        Recording recording = (Recording)ApiProxy.getCurrentEnvironment().getAttributes().get(RECORDING_KEY);
        Preconditions.checkNotNull(recording, "Recording has not been initialized yet.");
        return recording;
    }

    Recording(AppstatsSettings settings) {
        this(settings, new MemcacheWriter(new Recorder.Clock(), MemcacheServiceFactory.getMemcacheService((String)"__appstats__")));
    }

    Recording(AppstatsSettings settings, Recorder.RecordWriter writer) {
        Preconditions.checkNotNull(settings);
        Preconditions.checkNotNull(writer);
        this.settings = settings;
        this.writer = writer;
    }

    Recorder.RecordWriter getWriter() {
        return this.writer;
    }

    long begin(ApiProxy.Delegate<?> wrappedDelegate, ApiProxy.Environment environment, HttpServletRequest request) {
        return this.writer.begin(wrappedDelegate, environment, request);
    }

    void write(ApiProxy.Delegate<?> wrappedDelegate, ApiProxy.Environment environment, StatsProtos.IndividualRpcStatsProto.Builder record, long overheadWalltimeMillis, boolean correctStartOffset) {
        this.writer.write(wrappedDelegate, environment, record, overheadWalltimeMillis, correctStartOffset);
    }

    boolean commit(ApiProxy.Delegate<?> wrappedDelegate, ApiProxy.Environment environment, int httpResponseCode) {
        return this.writer.commit(wrappedDelegate, environment, httpResponseCode);
    }

    public String startCustomRecording(String packageName, String methodName, boolean recordParams, Object ... params) {
        long preNow = this.clock.currentTimeMillis();
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        packageName = Strings.isNullOrEmpty(packageName) ? "custom" : packageName;
        methodName = Strings.isNullOrEmpty(methodName) ? "method" : methodName;
        RecordingData recordingData = new RecordingData();
        StatsProtos.IndividualRpcStatsProto.Builder stats = StatsProtos.IndividualRpcStatsProto.newBuilder();
        String string = packageName;
        String string2 = methodName;
        stats.setServiceCallName(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString());
        if (environment.getAttributes().containsKey(Recorder.CURRENT_NAMESPACE_KEY)) {
            stats.setNamespace((String)environment.getAttributes().get(Recorder.CURRENT_NAMESPACE_KEY));
        }
        if (recordParams) {
            stats.setRequestDataSummary(this.settings.getPayloadRenderer().renderPayload(packageName, methodName, true, params));
        }
        Recorder.createStackTrace(2, stats, this.settings.getMaxLinesOfStackTrace());
        stats.setWasSuccessful(false);
        stats.setStartOffsetMilliseconds(this.clock.currentTimeMillis());
        recordingData.setStats(stats);
        if (!environment.getAttributes().containsKey(CUSTOM_RECORDING_KEY)) {
            environment.getAttributes().put(CUSTOM_RECORDING_KEY, Maps.newLinkedHashMap());
        }
        Map customRecordings = (Map)environment.getAttributes().get(CUSTOM_RECORDING_KEY);
        String key = this.generateKey(stats.getServiceCallName(), preNow);
        recordingData.addOverhead(this.clock.currentTimeMillis() - preNow);
        customRecordings.put(key, recordingData);
        return key;
    }

    public void endCustomRecording(String key, boolean wasSuccessful) {
        Map customRecordings;
        RecordingData recordingData;
        long preNow = this.clock.currentTimeMillis();
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment.getAttributes().containsKey(CUSTOM_RECORDING_KEY) && (recordingData = (RecordingData)(customRecordings = (Map)environment.getAttributes().get(CUSTOM_RECORDING_KEY)).get(key)) != null) {
            this.writeCustomRecording(environment, recordingData, preNow, wasSuccessful);
            customRecordings.remove(key);
        }
    }

    private void writeCustomRecording(ApiProxy.Environment environment, RecordingData recordingData, long preNow, boolean wasSuccessful) {
        ApiProxy.Delegate<?> noDelegate = null;
        StatsProtos.IndividualRpcStatsProto.Builder stats = recordingData.getStats();
        stats.setWasSuccessful(wasSuccessful);
        stats.setDurationMilliseconds(preNow - stats.getStartOffsetMilliseconds());
        recordingData.addOverhead(this.clock.currentTimeMillis() - preNow);
        this.write(noDelegate, environment, stats, recordingData.getOverhead(), true);
    }

    private String generateKey(String prefix, long timeStamp) {
        prefix = Strings.isNullOrEmpty(prefix) ? "custom_key" : prefix;
        timeStamp = timeStamp * 1000L + (long)new Random().nextInt(1000);
        String string = prefix;
        long l = timeStamp;
        return new StringBuilder(21 + String.valueOf(string).length()).append(string).append("-").append(l).toString();
    }

    void finishCustomRecordings() {
        long preNow = this.clock.currentTimeMillis();
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment.getAttributes().containsKey(CUSTOM_RECORDING_KEY)) {
            Map customRecordings = (Map)environment.getAttributes().get(CUSTOM_RECORDING_KEY);
            for (RecordingData recordingData : customRecordings.values()) {
                this.writeCustomRecording(environment, recordingData, preNow, false);
            }
            environment.getAttributes().remove(CUSTOM_RECORDING_KEY);
        }
    }
}

