/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.tools.appstats.Recorder;
import com.google.appengine.tools.appstats.StatsProtos;
import com.google.apphosting.api.ApiProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class MemcacheWriter
implements Recorder.RecordWriter {
    private static final int FIRST_FIELD_NUMBER_FOR_DETAILS = 100;
    private static final String KEY_PREFIX = "__appstats__";
    private static final String KEY_TEMPLATE = ":%06d";
    private static final String PART_SUFFIX = ":part";
    private static final String FULL_SUFFIX = ":full";
    private static final int KEY_DISTANCE = 100;
    private static final int KEY_MODULUS = 1000;
    static final int MAX_SIZE = 1000000;
    private static final int EXPIRATION_SECONDS = 129600;
    public static final String STATS_NAMESPACE = "__appstats__";
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final Recorder.Clock clock;
    String keyInCache;
    private final MemcacheService statsMemcache;

    private static String makeKeyPrefix(long timestamp) {
        return String.format("__appstats__:%06d", timestamp / 100L % 1000L * 100L);
    }

    public MemcacheWriter(Recorder.Clock clock, MemcacheService service) {
        this.clock = clock;
        this.keyInCache = String.valueOf(this.getClass().getName()).concat(".CACHED_STATS");
        this.statsMemcache = service;
        if (service == null) {
            throw new NullPointerException("Memcache service not found");
        }
    }

    @Override
    public final long begin(ApiProxy.Delegate<?> wrappedDelegate, ApiProxy.Environment environment, HttpServletRequest request) {
        long beganAt = this.clock.currentTimeMillis();
        StatsProtos.RequestStatProto.Builder builder = StatsProtos.RequestStatProto.newBuilder();
        builder.setStartTimestampMilliseconds(beganAt);
        builder.setHttpMethod(request.getMethod());
        builder.setHttpPath(request.getRequestURI());
        String queryUnescaped = request.getQueryString();
        if (queryUnescaped != null && queryUnescaped.length() > 0) {
            String string = String.valueOf(queryUnescaped);
            builder.setHttpQuery(string.length() != 0 ? "?".concat(string) : new String("?"));
        }
        builder.setIsAdmin(environment.isAdmin());
        if (environment.getEmail() != null) {
            builder.setUserEmail(environment.getEmail());
        }
        builder.setOverheadWalltimeMilliseconds(this.clock.currentTimeMillis() - beganAt);
        environment.getAttributes().put(this.keyInCache, builder);
        return beganAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean commit(ApiProxy.Delegate<?> wrappedDelegate, ApiProxy.Environment environment, int responseCode) {
        StatsProtos.RequestStatProto.Builder builder = (StatsProtos.RequestStatProto.Builder)environment.getAttributes().get(this.keyInCache);
        if (builder == null) {
            return false;
        }
        StatsProtos.RequestStatProto.Builder builder2 = builder;
        synchronized (builder2) {
            builder.setDurationMilliseconds(this.clock.currentTimeMillis() - builder.getStartTimestampMilliseconds());
            if (responseCode != 0) {
                builder.setHttpStatus(responseCode);
            } else {
                builder.clearHttpStatus();
            }
            HashMap<String, StatsProtos.AggregateRpcStatsProto.Builder> aggregates = new HashMap<String, StatsProtos.AggregateRpcStatsProto.Builder>();
            for (StatsProtos.IndividualRpcStatsProto stat : builder.getIndividualStatsList()) {
                String key = stat.getServiceCallName();
                if (!aggregates.containsKey(key)) {
                    StatsProtos.AggregateRpcStatsProto.Builder aggregate = StatsProtos.AggregateRpcStatsProto.newBuilder().setServiceCallName(stat.getServiceCallName()).setTotalAmountOfCalls(0L);
                    if (stat.hasCallCostMicrodollars()) {
                        aggregate.setTotalCostOfCallsMicrodollars(0L);
                    }
                    aggregates.put(key, aggregate);
                }
                HashMap<StatsProtos.BilledOpProto.BilledOp, StatsProtos.BilledOpProto.Builder> billedOpMap = Maps.newHashMap();
                StatsProtos.AggregateRpcStatsProto.Builder aggregate = (StatsProtos.AggregateRpcStatsProto.Builder)aggregates.get(key);
                aggregate.setTotalAmountOfCalls(aggregate.getTotalAmountOfCalls() + 1L);
                aggregate.setTotalCostOfCallsMicrodollars(aggregate.getTotalCostOfCallsMicrodollars() + stat.getCallCostMicrodollars());
                for (StatsProtos.BilledOpProto billedOp : stat.getBilledOpsList()) {
                    StatsProtos.BilledOpProto.Builder totalBilledOp = (StatsProtos.BilledOpProto.Builder)billedOpMap.get(billedOp.getOp());
                    if (totalBilledOp == null) {
                        totalBilledOp = StatsProtos.BilledOpProto.newBuilder().setOp(billedOp.getOp());
                        billedOpMap.put(billedOp.getOp(), totalBilledOp);
                    }
                    totalBilledOp.setNumOps(totalBilledOp.getNumOps() + billedOp.getNumOps());
                }
                for (StatsProtos.BilledOpProto.Builder totalBilledOp : billedOpMap.values()) {
                    aggregate.addTotalBilledOps(totalBilledOp);
                }
            }
            for (StatsProtos.AggregateRpcStatsProto.Builder aggregate : aggregates.values()) {
                builder.addRpcStats(aggregate);
            }
            environment.getAttributes().remove(this.keyInCache);
            try {
                this.persist(builder.build());
                return true;
            }
            catch (MemcacheServiceException e) {
                this.log.log(Level.WARNING, "Error persisting request stats", e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(ApiProxy.Delegate<?> wrappedDelegate, ApiProxy.Environment environment, StatsProtos.IndividualRpcStatsProto.Builder record, long overheadWalltimeMillis, boolean correctStartOffset) {
        if (record == null) {
            throw new NullPointerException("Record must not be null");
        }
        if (environment == null) {
            throw new NullPointerException("Environment must not be null");
        }
        StatsProtos.RequestStatProto.Builder builder = (StatsProtos.RequestStatProto.Builder)environment.getAttributes().get(this.keyInCache);
        if (builder != null) {
            StatsProtos.RequestStatProto.Builder builder2 = builder;
            synchronized (builder2) {
                if (correctStartOffset) {
                    record.setStartOffsetMilliseconds(Math.max(0L, record.getStartOffsetMilliseconds() - builder.getStartTimestampMilliseconds()));
                }
                builder.addIndividualStats(record);
                builder.setOverheadWalltimeMilliseconds(builder.getOverheadWalltimeMilliseconds() + overheadWalltimeMillis);
            }
        }
    }

    @Override
    public List<StatsProtos.RequestStatProto> getSummaries() {
        ArrayList<String> keys = new ArrayList<String>(1000);
        for (int i = 0; i < 1000; ++i) {
            String string = String.valueOf(MemcacheWriter.makeKeyPrefix(i * 100));
            String string2 = String.valueOf(PART_SUFFIX);
            keys.add(string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        ArrayList<StatsProtos.RequestStatProto> result = new ArrayList<StatsProtos.RequestStatProto>();
        for (Map.Entry entry : this.statsMemcache.getAll(keys).entrySet()) {
            try {
                result.add(((StatsProtos.RequestStatProto.Builder)StatsProtos.RequestStatProto.newBuilder().mergeFrom((byte[])entry.getValue())).build());
            }
            catch (InvalidProtocolBufferException e) {
                String string = String.valueOf(entry.getKey());
                this.log.warning(new StringBuilder(64 + String.valueOf(string).length()).append("Memcache store for request stats is partially corrupted for key ").append(string).toString());
                this.statsMemcache.delete(entry.getKey());
            }
        }
        return result;
    }

    @Override
    public StatsProtos.RequestStatProto getFull(long timestamp) {
        String string = String.valueOf(MemcacheWriter.makeKeyPrefix(timestamp));
        String string2 = String.valueOf(FULL_SUFFIX);
        String key = string2.length() != 0 ? string.concat(string2) : new String(string);
        try {
            byte[] rawData = (byte[])this.statsMemcache.get((Object)key);
            return rawData == null ? null : ((StatsProtos.RequestStatProto.Builder)StatsProtos.RequestStatProto.newBuilder().mergeFrom(rawData)).build();
        }
        catch (InvalidProtocolBufferException e) {
            String string3 = String.valueOf(key);
            this.log.warning(string3.length() != 0 ? "Memcache store for request stats is partially corrupted for key ".concat(string3) : new String("Memcache store for request stats is partially corrupted for key "));
            this.statsMemcache.delete((Object)key);
            return null;
        }
    }

    private void persist(StatsProtos.RequestStatProto stats) {
        StatsProtos.RequestStatProto.Builder summary = StatsProtos.RequestStatProto.newBuilder().mergeFrom(stats);
        for (Descriptors.FieldDescriptor field : StatsProtos.RequestStatProto.getDescriptor().getFields()) {
            if (field.getNumber() <= 100) continue;
            summary.clearField(field);
        }
        HashMap<String, byte[]> values = new HashMap<String, byte[]>();
        String prefix = MemcacheWriter.makeKeyPrefix(stats.getStartTimestampMilliseconds());
        String string = String.valueOf(prefix);
        String string2 = String.valueOf(PART_SUFFIX);
        values.put(string2.length() != 0 ? string.concat(string2) : new String(string), this.serialize(summary.build()));
        String string3 = String.valueOf(prefix);
        String string4 = String.valueOf(FULL_SUFFIX);
        values.put(string4.length() != 0 ? string3.concat(string4) : new String(string3), this.serialize(stats));
        this.statsMemcache.putAll(values, Expiration.byDeltaSeconds((int)129600));
    }

    byte[] serialize(StatsProtos.RequestStatProto proto) {
        byte[] result = this.serializeIfSmallEnough(proto);
        if (result == null) {
            proto = this.removeStackTraces(proto);
            result = this.serializeIfSmallEnough(proto);
            this.logMaybe(result, "all stack traces were removed");
        }
        if (result == null) {
            proto = this.trimStatsEntries(100, proto);
            result = this.serializeIfSmallEnough(proto);
            this.logMaybe(result, "trimmed the amount of individual stats down to 100 entries");
        }
        if (result == null) {
            proto = this.trimStatsEntries(0, proto);
            result = this.serializeIfSmallEnough(proto);
            this.logMaybe(result, "cleared out all individual stats");
        }
        if (result == null) {
            throw new MemcacheServiceException("Appstats data too big");
        }
        return result;
    }

    private byte[] serializeIfSmallEnough(StatsProtos.RequestStatProto proto) {
        byte[] result = proto.toByteArray();
        return result.length > 1000000 ? null : result;
    }

    private void logMaybe(byte[] result, String action) {
        if (result != null) {
            this.log.warning(new StringBuilder(25 + String.valueOf(action).length()).append("Stats data was too big, ").append(action).append(".").toString());
        }
    }

    private StatsProtos.RequestStatProto removeStackTraces(StatsProtos.RequestStatProto proto) {
        StatsProtos.RequestStatProto.Builder builder = proto.toBuilder().clearIndividualStats();
        for (StatsProtos.IndividualRpcStatsProto stat : proto.getIndividualStatsList()) {
            builder.addIndividualStats(stat.toBuilder().clearCallStack());
        }
        return builder.build();
    }

    private StatsProtos.RequestStatProto trimStatsEntries(int max, StatsProtos.RequestStatProto proto) {
        StatsProtos.RequestStatProto.Builder builder = proto.toBuilder().clearIndividualStats();
        for (int i = 0; i < Math.min(max, proto.getIndividualStatsCount()); ++i) {
            builder.addIndividualStats(proto.getIndividualStats(i));
        }
        return builder.build();
    }
}

