/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.api.mail.MailServicePb;
import com.google.appengine.tools.appstats.RpcCostCalculator;
import com.google.appengine.tools.appstats.RpcOperationCostManager;
import com.google.appengine.tools.appstats.StatsProtos;
import java.util.Arrays;
import java.util.Map;

class MailRpcCostCalculator
implements RpcCostCalculator {
    private static final String PKG = "mail";
    private final long recipientCostMicropennies;

    MailRpcCostCalculator(long recipientCostMicropennies) {
        this.recipientCostMicropennies = recipientCostMicropennies;
    }

    @Override
    public RpcCostCalculator.RpcCost determineCost(String methodName, byte[] request, byte[] response) {
        if (methodName.equals("Send") || methodName.equals("SendToAdmin")) {
            MailServicePb.MailMessage proto = new MailServicePb.MailMessage();
            boolean parsed = proto.parseFrom(request);
            if (!parsed || !proto.isInitialized()) {
                throw new IllegalArgumentException("Could not parse request protobuf");
            }
            int numRecipients = proto.toSize() + proto.ccSize() + proto.bccSize();
            StatsProtos.BilledOpProto billedOpProto = StatsProtos.BilledOpProto.newBuilder().setNumOps(numRecipients).setOp(StatsProtos.BilledOpProto.BilledOp.MAIL_RECIPIENT).build();
            return new RpcCostCalculator.RpcCost(this.recipientCostMicropennies * (long)numRecipients, Arrays.asList(billedOpProto));
        }
        return FREE;
    }

    static void register(Map<String, RpcCostCalculator> costCalculatorMap, RpcOperationCostManager opCostMgr) {
        costCalculatorMap.put(PKG, new MailRpcCostCalculator(opCostMgr.costOf(StatsProtos.BilledOpProto.BilledOp.MAIL_RECIPIENT)));
    }
}

