/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.TextFormat;
import com.google.appengine.tools.appstats.InternalProtos;
import com.google.appengine.tools.appstats.PayloadRenderer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

class FullPayloadRenderer
implements PayloadRenderer {
    private static final int MAX_OUTPUT_SIZE = 500;
    private static final int PER_ITEM_LIMIT = 20;
    private static final String ELLIPSIS = "...";
    private static final int ELLIPSIS_LENGTH = "...".length();
    private static final int DEPTH = 5;

    FullPayloadRenderer() {
    }

    @Override
    public String renderPayload(String packageName, String methodName, byte[] payload, boolean isRequestPayload) {
        try {
            InternalProtos.EmptyProto proto = ((InternalProtos.EmptyProto.Builder)InternalProtos.EmptyProto.newBuilder().mergeFrom(payload)).build();
            return TextFormat.printToString(proto.getUnknownFields());
        }
        catch (InvalidProtocolBufferException e) {
            return "???";
        }
    }

    @Override
    public String renderPayload(String packageName, String methodName, boolean isRequestPayload, Object ... params) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(packageName).append(".").append(methodName);
            builder.append("(");
            int size = 0;
            String separator = "";
            for (Object param : params) {
                builder.append(separator);
                separator = ", ";
                size = this.format(builder, param, size, 5);
            }
            builder.append(")");
            return builder.toString();
        }
        catch (Exception ex) {
            return "???";
        }
    }

    private int format(StringBuilder builder, Object val, int size, int depth) {
        String text = null;
        if (val != null) {
            if (FullPayloadRenderer.isTextType(val)) {
                String string = text = this.getText(val.toString(), size, true);
                text = new StringBuilder(2 + String.valueOf(string).length()).append("'").append(string).append("'").toString();
            } else if (FullPayloadRenderer.isNumberType(val)) {
                text = this.getText(Objects.toString(val), size, false);
            } else if (FullPayloadRenderer.isCollectionType(val)) {
                if (depth < 1) {
                    text = this.getText(Objects.toString(val), size, true);
                } else {
                    Iterator iter = ((Collection)val).iterator();
                    builder.append("{");
                    String separator = "";
                    while (iter.hasNext()) {
                        builder.append(separator);
                        separator = ", ";
                        size = this.format(builder, iter.next(), size, depth - 1);
                    }
                    builder.append("}");
                }
            } else {
                text = FullPayloadRenderer.isArrayType(val) ? this.getText(this.deepToString(val), size, true) : this.getText(Objects.toString(val), size, true);
            }
        }
        if (text != null) {
            builder.append(text);
            size += text.length();
        }
        return size;
    }

    private String getText(String val, int filled, boolean trimIfRequired) {
        int placesLeft;
        if (val == null || filled >= 500) {
            return "";
        }
        if (trimIfRequired && (placesLeft = FullPayloadRenderer.placesLeft(filled)) < val.length()) {
            if (placesLeft > ELLIPSIS_LENGTH) {
                String string = String.valueOf(val.substring(0, placesLeft - ELLIPSIS_LENGTH));
                String string2 = String.valueOf(ELLIPSIS);
                val = string2.length() != 0 ? string.concat(string2) : new String(string);
            } else {
                val = ELLIPSIS;
            }
        }
        filled += val.length();
        return val;
    }

    private String deepToString(Object obj) {
        String s = Arrays.deepToString(new Object[]{obj});
        return s.substring(1, s.length() - 1);
    }

    private static int placesLeft(int filled) {
        return Math.min(500 - filled, 20);
    }

    private static boolean isTextType(Object obj) {
        return obj instanceof CharSequence || obj instanceof Character || obj instanceof Enum;
    }

    private static boolean isNumberType(Object obj) {
        return obj instanceof Number;
    }

    private static boolean isArrayType(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    private static boolean isCollectionType(Object obj) {
        return obj instanceof Collection;
    }
}

