/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.tools.appstats.AppstatsSettings;
import com.google.appengine.tools.appstats.Recorder;
import com.google.appengine.tools.appstats.Recording;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DeadlineExceededException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AppstatsFilter
implements Filter {
    static final String DEADLINE_MESSAGE = "Deadline exceeded; cannot log app stats";
    static Logger log = Logger.getLogger(AppstatsFilter.class.getName());
    static final String TRACE_HEADER_NAME = "X-TraceUrl";
    private static final String DEFAULT_BASE_PATH = "/appstats/";
    private Recording recording;
    static ApiProxy.Delegate<?> delegate;
    private String basePath;
    private String logMessage;
    private Recorder recorder;

    public AppstatsFilter() {
    }

    AppstatsFilter(String basePath, String logMessage, Recording recording) {
        this.basePath = basePath;
        this.logMessage = logMessage;
        this.recording = recording;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filters) throws IOException, ServletException {
        Preconditions.checkNotNull(this.recording, "recording shouldn't be null");
        ApiProxy.Environment environment = this.getCurrentEnvironment();
        environment.getAttributes().put(Recording.RECORDING_KEY, this.recording);
        Long id = this.recording.begin(delegate, environment, (HttpServletRequest)request);
        final HttpServletResponse innerResponse = (HttpServletResponse)response;
        final int[] responseCode = new int[]{0};
        String string = this.basePath;
        String string2 = String.valueOf(id);
        innerResponse.addHeader(TRACE_HEADER_NAME, new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("details?time=").append(string2).append("&type=json").toString());
        InvocationHandler invocationHandler = new InvocationHandler(this){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("sendError") || method.getName().equals("setStatus")) {
                    responseCode[0] = (Integer)args[0];
                } else if (method.getName().equals("sendRedirect")) {
                    responseCode[0] = 307;
                }
                return AppstatsFilter.call(method, innerResponse, args);
            }
        };
        HttpServletResponse outerResponse = (HttpServletResponse)Proxy.newProxyInstance(AppstatsFilter.class.getClassLoader(), new Class[]{HttpServletResponse.class}, invocationHandler);
        try {
            filters.doFilter(request, (ServletResponse)outerResponse);
        }
        catch (DeadlineExceededException e) {
            id = null;
            log.warning(DEADLINE_MESSAGE);
            throw e;
        }
        finally {
            if (id != null) {
                if (this.recorder != null) {
                    this.recorder.processAsyncRpcs(environment);
                }
                this.recording.finishCustomRecordings();
                boolean didCommit = this.recording.commit(delegate, environment, responseCode[0]);
                if (this.logMessage != null && didCommit) {
                    String string3 = String.valueOf(id);
                    log.info(this.logMessage.replace("{ID}", new StringBuilder(String.valueOf(string3).length()).append(string3).toString()));
                }
            }
        }
    }

    private static String getAppStatsPathFromConfig(FilterConfig config) {
        String path = config.getInitParameter("basePath");
        if (path == null) {
            return DEFAULT_BASE_PATH;
        }
        return path.endsWith("/") ? path : String.valueOf(path).concat("/");
    }

    public synchronized void init(FilterConfig config) {
        if (this.recording == null) {
            AppstatsSettings settings = AppstatsFilter.initializeSettings(config);
            this.recording = new Recording(settings);
            Recorder.RecordWriter newWriter = this.recording.getWriter();
            delegate = ApiProxy.getDelegate();
            this.recorder = new Recorder(delegate, newWriter, settings);
            ApiProxy.setDelegate(AppstatsFilter.wrapPartially(delegate, this.recorder));
        }
        this.basePath = AppstatsFilter.getAppStatsPathFromConfig(config);
        this.logMessage = config.getInitParameter("logMessage");
    }

    static <S, T extends S> S wrapPartially(final S original, final T wrapper) {
        if (!original.getClass().getName().contains("Local")) {
            return wrapper;
        }
        Class<?>[] interfaces = original.getClass().getInterfaces();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Method wrapperMethod = null;
                try {
                    wrapperMethod = wrapper.getClass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    return AppstatsFilter.call(method, original, args);
                }
                return AppstatsFilter.call(wrapperMethod, wrapper, args);
            }
        };
        Object ret = Proxy.newProxyInstance(original.getClass().getClassLoader(), interfaces, handler);
        return (S)ret;
    }

    private static Object call(Method m, Object o, Object[] args) throws Throwable {
        Preconditions.checkArgument(m.getDeclaringClass().isAssignableFrom(o.getClass()));
        try {
            return m.invoke(o, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    ApiProxy.Environment getCurrentEnvironment() {
        return ApiProxy.getCurrentEnvironment();
    }

    static AppstatsSettings initializeSettings(FilterConfig config) {
        Preconditions.checkNotNull(config, "FilterConfig can not be null.");
        AppstatsSettings settings = AppstatsSettings.withDefault();
        settings.setMaxLinesOfStackTrace(AppstatsFilter.getPositiveInt(config, "maxLinesOfStackTrace", Integer.MAX_VALUE));
        if (config.getInitParameter("payloadRenderer") != null) {
            settings.setPayloadRenderer(config.getInitParameter("payloadRenderer"));
        }
        if (config.getInitParameter("onPendingAsyncCall") != null) {
            settings.setUnprocessedFutureStrategy(config.getInitParameter("onPendingAsyncCall"));
        }
        if (config.getInitParameter("calculateRpcCosts") != null) {
            settings.setCalculateRpcCosts(config.getInitParameter("calculateRpcCosts"));
        }
        if (config.getInitParameter("datastoreDetails") != null) {
            settings.setDatastoreDetails(config.getInitParameter("datastoreDetails"));
        }
        return settings;
    }

    static int getPositiveInt(FilterConfig config, String key, int defaultValue) {
        int result = defaultValue;
        String stringValue = config.getInitParameter(key);
        if (stringValue != null && (result = Integer.parseInt(stringValue)) <= 0) {
            throw new IllegalArgumentException(String.valueOf(key).concat(" must be a positive value"));
        }
        return result;
    }
}

