/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.ExtensionSchemas;
import com.google.appengine.repackaged.com.google.protobuf.GeneratedMessageInfoFactory;
import com.google.appengine.repackaged.com.google.protobuf.GeneratedMessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Internal;
import com.google.appengine.repackaged.com.google.protobuf.ListFieldSchema;
import com.google.appengine.repackaged.com.google.protobuf.MapFieldSchemas;
import com.google.appengine.repackaged.com.google.protobuf.MessageInfo;
import com.google.appengine.repackaged.com.google.protobuf.MessageInfoFactory;
import com.google.appengine.repackaged.com.google.protobuf.MessageSchema;
import com.google.appengine.repackaged.com.google.protobuf.MessageSetSchema;
import com.google.appengine.repackaged.com.google.protobuf.ProtoSyntax;
import com.google.appengine.repackaged.com.google.protobuf.Schema;
import com.google.appengine.repackaged.com.google.protobuf.SchemaFactory;
import com.google.appengine.repackaged.com.google.protobuf.SchemaUtil;

final class ManifestSchemaFactory
implements SchemaFactory {
    private final MessageInfoFactory messageInfoFactory;
    private final Mode mode;
    private static final MessageInfoFactory EMPTY_FACTORY = new MessageInfoFactory(){

        @Override
        public boolean isSupported(Class<?> clazz) {
            return false;
        }

        @Override
        public MessageInfo messageInfoFor(Class<?> clazz) {
            throw new IllegalStateException("This should never be called.");
        }
    };

    public ManifestSchemaFactory() {
        this(Mode.DYNAMIC);
    }

    public ManifestSchemaFactory(Mode mode) {
        this(ManifestSchemaFactory.getDefaultMessageInfoFactory(), mode);
    }

    private ManifestSchemaFactory(MessageInfoFactory messageInfoFactory, Mode mode) {
        this.messageInfoFactory = Internal.checkNotNull(messageInfoFactory, "messageInfoFactory");
        this.mode = Internal.checkNotNull(mode, "mode");
    }

    @Override
    public <T> Schema<T> createSchema(Class<T> messageType) {
        SchemaUtil.requireGeneratedMessage(messageType);
        MessageInfo messageInfo = this.messageInfoFactory.messageInfoFor(messageType);
        if (messageInfo.isMessageSetWireFormat()) {
            if (GeneratedMessageLite.class.isAssignableFrom(messageType)) {
                return MessageSetSchema.newSchema(messageType, SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite());
            }
            return MessageSetSchema.newSchema(messageType, SchemaUtil.proto2UnknownFieldSetSchema(), ExtensionSchemas.full());
        }
        switch (this.mode) {
            case TABLE: {
                return ManifestSchemaFactory.newTableSchema(messageType, messageInfo);
            }
            case LOOKUP: {
                return ManifestSchemaFactory.newLookupSchema(messageType, messageInfo);
            }
        }
        return SchemaUtil.shouldUseTableSwitch(messageInfo.getFields()) ? ManifestSchemaFactory.newTableSchema(messageType, messageInfo) : ManifestSchemaFactory.newLookupSchema(messageType, messageInfo);
    }

    private static <T> Schema<T> newTableSchema(Class<T> messageType, MessageInfo messageInfo) {
        if (GeneratedMessageLite.class.isAssignableFrom(messageType)) {
            return ManifestSchemaFactory.isProto2(messageInfo) ? MessageSchema.newTableSchema(messageType, messageInfo, ListFieldSchema.lite(), SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite(), MapFieldSchemas.lite()) : MessageSchema.newTableSchema(messageType, messageInfo, ListFieldSchema.lite(), SchemaUtil.unknownFieldSetLiteSchema(), null, MapFieldSchemas.lite());
        }
        return ManifestSchemaFactory.isProto2(messageInfo) ? MessageSchema.newTableSchema(messageType, messageInfo, ListFieldSchema.full(), SchemaUtil.proto2UnknownFieldSetSchema(), ExtensionSchemas.full(), MapFieldSchemas.full()) : MessageSchema.newTableSchema(messageType, messageInfo, ListFieldSchema.full(), SchemaUtil.proto3UnknownFieldSetSchema(), null, MapFieldSchemas.full());
    }

    private static <T> Schema<T> newLookupSchema(Class<T> messageType, MessageInfo messageInfo) {
        if (GeneratedMessageLite.class.isAssignableFrom(messageType)) {
            return ManifestSchemaFactory.isProto2(messageInfo) ? MessageSchema.newLookupSchema(messageType, messageInfo, ListFieldSchema.lite(), SchemaUtil.unknownFieldSetLiteSchema(), ExtensionSchemas.lite(), MapFieldSchemas.lite()) : MessageSchema.newLookupSchema(messageType, messageInfo, ListFieldSchema.lite(), SchemaUtil.unknownFieldSetLiteSchema(), null, MapFieldSchemas.lite());
        }
        return ManifestSchemaFactory.isProto2(messageInfo) ? MessageSchema.newLookupSchema(messageType, messageInfo, ListFieldSchema.full(), SchemaUtil.proto2UnknownFieldSetSchema(), ExtensionSchemas.full(), MapFieldSchemas.full()) : MessageSchema.newLookupSchema(messageType, messageInfo, ListFieldSchema.full(), SchemaUtil.proto3UnknownFieldSetSchema(), null, MapFieldSchemas.full());
    }

    private static boolean isProto2(MessageInfo messageInfo) {
        return messageInfo.getSyntax() == ProtoSyntax.PROTO2;
    }

    private static MessageInfoFactory getDefaultMessageInfoFactory() {
        return new CompositeMessageInfoFactory(GeneratedMessageInfoFactory.getInstance(), ManifestSchemaFactory.getDescriptorMessageInfoFactory());
    }

    private static MessageInfoFactory getDescriptorMessageInfoFactory() {
        try {
            Class<?> clazz = Class.forName("com.google.appengine.repackaged.com.google.protobuf.DescriptorMessageInfoFactory");
            return (MessageInfoFactory)clazz.getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return EMPTY_FACTORY;
        }
    }

    private static class CompositeMessageInfoFactory
    implements MessageInfoFactory {
        private MessageInfoFactory[] factories;

        CompositeMessageInfoFactory(MessageInfoFactory ... factories) {
            this.factories = factories;
        }

        @Override
        public boolean isSupported(Class<?> clazz) {
            for (MessageInfoFactory factory : this.factories) {
                if (!factory.isSupported(clazz)) continue;
                return true;
            }
            return false;
        }

        @Override
        public MessageInfo messageInfoFor(Class<?> clazz) {
            for (MessageInfoFactory factory : this.factories) {
                if (!factory.isSupported(clazz)) continue;
                return factory.messageInfoFor(clazz);
            }
            String string = String.valueOf(clazz.getName());
            throw new UnsupportedOperationException(string.length() != 0 ? "No factory is available for message type: ".concat(string) : new String("No factory is available for message type: "));
        }
    }

    public static enum Mode {
        TABLE,
        LOOKUP,
        DYNAMIC;

    }
}

