/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.datastore.overlay;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.BaseDatastoreService;
import com.google.appengine.api.datastore.DatastoreAttributes;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.api.labs.datastore.overlay.NamespacePinnedPreparedQueryImpl;
import com.google.appengine.api.labs.datastore.overlay.RethrowingFutureWrapper;
import com.google.appengine.api.labs.datastore.overlay.TransactionLinkedAsyncDatastoreServiceImpl;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

final class NamespacePinnedAsyncDatastoreServiceImpl
implements AsyncDatastoreService {
    private final AsyncDatastoreService datastore;
    private final String namespacePrefix;
    private final boolean shouldReserveIds;

    NamespacePinnedAsyncDatastoreServiceImpl(AsyncDatastoreService datastore, String namespacePrefix, boolean shouldReserveIds) {
        this.datastore = Preconditions.checkNotNull(datastore);
        this.namespacePrefix = Preconditions.checkNotNull(namespacePrefix);
        this.shouldReserveIds = shouldReserveIds;
    }

    public Future<Entity> get(Key key) {
        Preconditions.checkNotNull(key);
        return this.getImpl(this.datastore, key);
    }

    public Future<Entity> get(Transaction txn, Key key) {
        Preconditions.checkNotNull(key);
        return this.getImpl(this.getTxnAsyncDatastore(txn), key);
    }

    private Future<Entity> getImpl(AsyncDatastoreService datastore, Key key) {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(key);
        return new RethrowingFutureWrapper<Entity, Entity>(datastore.get(this.getAlternateNamespaceKey(key))){

            protected Entity wrap(Entity entity) throws Exception {
                return NamespacePinnedAsyncDatastoreServiceImpl.this.getOriginalNamespaceEntity(entity);
            }
        };
    }

    public Future<Map<Key, Entity>> get(Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        return this.getImpl(this.datastore, keys);
    }

    public Future<Map<Key, Entity>> get(Transaction txn, Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        return this.getImpl(this.getTxnAsyncDatastore(txn), keys);
    }

    private Future<Map<Key, Entity>> getImpl(AsyncDatastoreService datastore, Iterable<Key> keys) {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(keys);
        return new RethrowingFutureWrapper<Map<Key, Entity>, Map<Key, Entity>>(datastore.get(this.getAlternateNamespaceKeys(keys))){

            protected Map<Key, Entity> wrap(Map<Key, Entity> entityMap) throws Exception {
                return NamespacePinnedAsyncDatastoreServiceImpl.this.getOriginalNamespaceEntityMap(entityMap);
            }
        };
    }

    public Future<Key> put(Entity entity) {
        Preconditions.checkNotNull(entity);
        return this.putImpl(this.datastore, entity);
    }

    public Future<Key> put(Transaction txn, Entity entity) {
        Preconditions.checkNotNull(entity);
        return this.putImpl(this.getTxnAsyncDatastore(txn), entity);
    }

    private Future<Key> putImpl(AsyncDatastoreService datastore, Entity entity) {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(entity);
        Entity alternateEntity = this.getAlternateNamespaceEntity(entity);
        return new RethrowingFutureWrapper<Key, Key>(datastore.put(alternateEntity)){

            protected Key wrap(Key key) throws Exception {
                return NamespacePinnedAsyncDatastoreServiceImpl.this.getOriginalNamespaceKey(key);
            }
        };
    }

    public Future<List<Key>> put(Iterable<Entity> entities) {
        Preconditions.checkNotNull(entities);
        return this.putImpl(this.datastore, entities);
    }

    public Future<List<Key>> put(Transaction txn, Iterable<Entity> entities) {
        Preconditions.checkNotNull(entities);
        return this.putImpl(this.getTxnAsyncDatastore(txn), entities);
    }

    private Future<List<Key>> putImpl(AsyncDatastoreService datastore, Iterable<Entity> entities) {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(entities);
        List<Entity> alternateEntities = this.getAlternateNamespaceEntities(entities);
        return new RethrowingFutureWrapper<List<Key>, List<Key>>(datastore.put(alternateEntities)){

            protected List<Key> wrap(List<Key> keys) throws Exception {
                return NamespacePinnedAsyncDatastoreServiceImpl.this.getOriginalNamespaceKeys(keys);
            }
        };
    }

    public Future<Void> delete(Key ... keys) {
        Preconditions.checkNotNull(keys);
        return this.delete(ImmutableList.copyOf(keys));
    }

    public Future<Void> delete(Transaction txn, Key ... keys) {
        Preconditions.checkNotNull(keys);
        return this.delete(txn, ImmutableList.copyOf(keys));
    }

    public Future<Void> delete(Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        return this.datastore.delete(this.getAlternateNamespaceKeys(keys));
    }

    public Future<Void> delete(Transaction txn, Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        return this.datastore.delete(txn, this.getAlternateNamespaceKeys(keys));
    }

    public Future<Transaction> beginTransaction() {
        return this.datastore.beginTransaction();
    }

    public Future<Transaction> beginTransaction(TransactionOptions options) {
        Preconditions.checkNotNull(options);
        return this.datastore.beginTransaction(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<KeyRange> allocateIds(String kind, long num) {
        Preconditions.checkNotNull(kind);
        String currentNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)this.getAlternateNamespace(currentNamespace));
            RethrowingFutureWrapper<KeyRange, KeyRange> rethrowingFutureWrapper = new RethrowingFutureWrapper<KeyRange, KeyRange>(this.datastore.allocateIds(kind, num)){

                protected KeyRange wrap(KeyRange range) throws Exception {
                    return NamespacePinnedAsyncDatastoreServiceImpl.this.getOriginalNamespaceKeyRange(range);
                }
            };
            return rethrowingFutureWrapper;
        }
        finally {
            NamespaceManager.set((String)currentNamespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<KeyRange> allocateIds(Key parent, String kind, long num) {
        Preconditions.checkNotNull(parent);
        Preconditions.checkNotNull(kind);
        String currentNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)this.getAlternateNamespace(parent.getNamespace()));
            RethrowingFutureWrapper<KeyRange, KeyRange> rethrowingFutureWrapper = new RethrowingFutureWrapper<KeyRange, KeyRange>(this.datastore.allocateIds(this.getAlternateNamespaceKey(parent), kind, num)){

                protected KeyRange wrap(KeyRange range) throws Exception {
                    return NamespacePinnedAsyncDatastoreServiceImpl.this.getOriginalNamespaceKeyRange(range);
                }
            };
            return rethrowingFutureWrapper;
        }
        finally {
            NamespaceManager.set((String)currentNamespace);
        }
    }

    public Future<DatastoreAttributes> getDatastoreAttributes() {
        return this.datastore.getDatastoreAttributes();
    }

    public Future<Map<Index, Index.IndexState>> getIndexes() {
        return this.datastore.getIndexes();
    }

    public Collection<Transaction> getActiveTransactions() {
        return this.datastore.getActiveTransactions();
    }

    public Transaction getCurrentTransaction() {
        return this.datastore.getCurrentTransaction();
    }

    public Transaction getCurrentTransaction(Transaction returnedIfNoTxn) {
        return this.datastore.getCurrentTransaction(returnedIfNoTxn);
    }

    public PreparedQuery prepare(Query query) {
        Preconditions.checkNotNull(query);
        return this.prepareImpl((BaseDatastoreService)this.datastore, query);
    }

    public PreparedQuery prepare(Transaction txn, Query query) {
        Preconditions.checkNotNull(query);
        return this.prepareImpl((BaseDatastoreService)this.getTxnAsyncDatastore(txn), query);
    }

    private PreparedQuery prepareImpl(BaseDatastoreService datastore, Query query) {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(query);
        Query alternateQuery = this.getAlternateNamespaceQuery(query);
        return new NamespacePinnedPreparedQueryImpl(this, datastore.prepare(alternateQuery));
    }

    @VisibleForTesting
    private String getAlternateNamespace(String namespace) {
        String string = String.valueOf(this.namespacePrefix);
        String string2 = String.valueOf(Strings.nullToEmpty(namespace));
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    @VisibleForTesting
    private String getOriginalNamespace(String namespace) {
        Preconditions.checkNotNull(namespace);
        Preconditions.checkArgument(namespace.startsWith(this.namespacePrefix), "%s must start with %s", (Object)namespace, (Object)this.namespacePrefix);
        return namespace.substring(this.namespacePrefix.length());
    }

    private List<Entity> getAlternateNamespaceEntities(Iterable<Entity> entities) {
        Preconditions.checkNotNull(entities);
        ArrayList<Entity> newEntities = Lists.newArrayList();
        for (Entity entity : entities) {
            newEntities.add(this.getAlternateNamespaceEntity(entity));
        }
        return newEntities;
    }

    private Entity getAlternateNamespaceEntity(Entity entity) {
        Preconditions.checkNotNull(entity);
        return this.cloneEntityWithNewKey(entity, this.getAlternateNamespaceKey(entity.getKey()));
    }

    Entity getOriginalNamespaceEntity(Entity entity) {
        Preconditions.checkNotNull(entity);
        return this.cloneEntityWithNewKey(entity, this.getOriginalNamespaceKey(entity.getKey()));
    }

    private Entity cloneEntityWithNewKey(Entity entity, Key newKey) {
        Entity newEntity = new Entity(newKey);
        newEntity.setPropertiesFrom(entity);
        return newEntity;
    }

    private Map<Key, Entity> getOriginalNamespaceEntityMap(Map<Key, Entity> entityMap) {
        Preconditions.checkNotNull(entityMap);
        HashMap<Key, Entity> newMap = Maps.newHashMapWithExpectedSize(entityMap.size());
        for (Map.Entry<Key, Entity> entry : entityMap.entrySet()) {
            newMap.put(this.getOriginalNamespaceKey(entry.getKey()), this.getOriginalNamespaceEntity(entry.getValue()));
        }
        return newMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key getAlternateNamespaceKey(Key key) {
        Preconditions.checkNotNull(key);
        String currentNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)this.getAlternateNamespace(key.getNamespace()));
            Key key2 = NamespacePinnedAsyncDatastoreServiceImpl.cloneKey(key);
            return key2;
        }
        finally {
            NamespaceManager.set((String)currentNamespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key getOriginalNamespaceKey(Key key) {
        Preconditions.checkNotNull(key);
        String currentNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)this.getOriginalNamespace(key.getNamespace()));
            Key key2 = NamespacePinnedAsyncDatastoreServiceImpl.cloneKey(key);
            return key2;
        }
        finally {
            NamespaceManager.set((String)currentNamespace);
        }
    }

    private List<Key> getAlternateNamespaceKeys(Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        ArrayList<Key> newKeys = Lists.newArrayList();
        for (Key key : keys) {
            newKeys.add(this.getAlternateNamespaceKey(key));
        }
        return newKeys;
    }

    private List<Key> getOriginalNamespaceKeys(Iterable<Key> keys) {
        Preconditions.checkNotNull(keys);
        ArrayList<Key> newKeys = Lists.newArrayList();
        for (Key key : keys) {
            newKeys.add(this.getOriginalNamespaceKey(key));
        }
        return newKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query getAlternateNamespaceQuery(Query query) {
        Query alternateQuery;
        Preconditions.checkNotNull(query);
        String currentNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)this.getAlternateNamespace(query.getNamespace()));
            alternateQuery = new Query(query.getKind());
        }
        finally {
            NamespaceManager.set((String)currentNamespace);
        }
        Key ancestor = query.getAncestor();
        if (ancestor != null) {
            alternateQuery.setAncestor(this.getAlternateNamespaceKey(ancestor));
        }
        for (Query.SortPredicate sp : query.getSortPredicates()) {
            alternateQuery.addSort(sp.getPropertyName(), sp.getDirection());
        }
        alternateQuery.setFilter(query.getFilter());
        for (Query.FilterPredicate fp : query.getFilterPredicates()) {
            alternateQuery.addFilter(fp.getPropertyName(), fp.getOperator(), fp.getValue());
        }
        if (query.isKeysOnly()) {
            alternateQuery.setKeysOnly();
        }
        for (Projection p : query.getProjections()) {
            alternateQuery.addProjection(p);
        }
        alternateQuery.setDistinct(query.getDistinct());
        return alternateQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyRange getOriginalNamespaceKeyRange(KeyRange keyRange) {
        Key alternateParent = keyRange.getStart().getParent();
        Key originalParent = alternateParent == null ? null : this.getOriginalNamespaceKey(alternateParent);
        String currentNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)this.getOriginalNamespace(keyRange.getStart().getNamespace()));
            KeyRange keyRange2 = new KeyRange(originalParent, keyRange.getStart().getKind(), keyRange.getStart().getId(), keyRange.getEnd().getId());
            return keyRange2;
        }
        finally {
            NamespaceManager.set((String)currentNamespace);
        }
    }

    private AsyncDatastoreService getTxnAsyncDatastore(Transaction txn) {
        return new TransactionLinkedAsyncDatastoreServiceImpl(this.datastore, txn);
    }

    private static Key cloneKey(Key key) {
        Preconditions.checkNotNull(key);
        Key parentKey = key.getParent();
        String name = key.getName();
        long id = key.getId();
        if (parentKey == null) {
            if (name != null) {
                return new Entity(key.getKind(), name).getKey();
            }
            if (id != 0L) {
                return new Entity(key.getKind(), key.getId()).getKey();
            }
            return new Entity(key.getKind()).getKey();
        }
        if (name != null) {
            return new Entity(key.getKind(), name, NamespacePinnedAsyncDatastoreServiceImpl.cloneKey(parentKey)).getKey();
        }
        if (id != 0L) {
            return new Entity(key.getKind(), key.getId(), NamespacePinnedAsyncDatastoreServiceImpl.cloneKey(parentKey)).getKey();
        }
        return new Entity(key.getKind(), NamespacePinnedAsyncDatastoreServiceImpl.cloneKey(parentKey)).getKey();
    }
}

