/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import org.jspecify.annotations.Nullable;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage != null ? String.valueOf(errorMessage) : null);
        }
    }

    public static void checkArgument(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessageTemplate != null ? String.format(errorMessageTemplate, errorMessageArgs) : null);
        }
    }

    public static <T> T checkNotNull(T reference, @Nullable Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage != null ? String.valueOf(errorMessage) : null);
        }
        return reference;
    }

    public static void checkState(boolean expression, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(errorMessageTemplate != null ? String.format(errorMessageTemplate, errorMessageArgs) : null);
        }
    }

    public static void checkState(boolean expression, @Nullable String errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage != null ? String.valueOf(errorMessage) : null);
        }
    }
}

