/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.internal.ImmutableCopy;
import com.google.appengine.api.search.DateUtil;
import com.google.appengine.api.search.GeoPoint;
import com.google.appengine.api.search.SearchException;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.api.search.DocumentPb;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jspecify.annotations.Nullable;

public final class Field
implements Serializable {
    private static final long serialVersionUID = 6829483617830682721L;
    private final String name;
    private final @Nullable Locale locale;
    private final @Nullable FieldType type;
    private @Nullable String text;
    private @Nullable String html;
    private @Nullable String atom;
    private @Nullable Date date;
    private @Nullable Double number;
    private @Nullable GeoPoint geoPoint;
    private @Nullable String untokenizedPrefix;
    private @Nullable String tokenizedPrefix;
    private List<Double> vector = Collections.emptyList();

    private Field(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        if (builder.type != null) {
            switch (builder.type.ordinal()) {
                case 0: {
                    this.text = builder.text;
                    break;
                }
                case 1: {
                    this.html = builder.html;
                    break;
                }
                case 2: {
                    this.atom = builder.atom;
                    break;
                }
                case 3: {
                    this.date = builder.date;
                    break;
                }
                case 4: {
                    this.number = builder.number;
                    break;
                }
                case 5: {
                    this.geoPoint = builder.geoPoint;
                    break;
                }
                case 6: {
                    this.untokenizedPrefix = builder.untokenizedPrefix;
                    break;
                }
                case 7: {
                    this.tokenizedPrefix = builder.tokenizedPrefix;
                    break;
                }
                case 8: {
                    this.vector = builder.vector;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown field type given %s", new Object[]{builder.type}));
                }
            }
        }
        this.locale = builder.locale;
        this.checkValid();
    }

    public String getName() {
        return this.name;
    }

    public FieldType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public String getHTML() {
        return this.html;
    }

    public String getAtom() {
        return this.atom;
    }

    public Date getDate() {
        return this.date;
    }

    public Double getNumber() {
        return this.number;
    }

    public GeoPoint getGeoPoint() {
        return this.geoPoint;
    }

    public String getUntokenizedPrefix() {
        return this.untokenizedPrefix;
    }

    public String getTokenizedPrefix() {
        return this.tokenizedPrefix;
    }

    public List<Double> getVector() {
        return this.vector;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Field)) {
            return false;
        }
        Field field = (Field)object;
        return Util.equalObjects(this.name, field.name);
    }

    private Field checkValid() {
        FieldChecker.checkFieldName(this.name);
        if (this.type != null) {
            switch (this.type.ordinal()) {
                case 0: {
                    FieldChecker.checkText(this.text);
                    break;
                }
                case 1: {
                    FieldChecker.checkHTML(this.html);
                    break;
                }
                case 2: {
                    FieldChecker.checkAtom(this.atom);
                    break;
                }
                case 3: {
                    FieldChecker.checkDate(this.date);
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    FieldChecker.checkPrefix(this.untokenizedPrefix);
                    break;
                }
                case 7: {
                    FieldChecker.checkPrefix(this.tokenizedPrefix);
                    break;
                }
                case 8: {
                    FieldChecker.checkVector(this.vector);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("unknown field type %s", new Object[]{this.type}));
                }
            }
        }
        return this;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static Builder newBuilder(DocumentPb.Field field) {
        DocumentPb.FieldValue value = field.getValue();
        Builder fieldBuilder = Field.newBuilder().setName(field.getName());
        if (value.hasLanguage()) {
            fieldBuilder.setLocale(FieldChecker.parseLocale(value.getLanguage()));
        }
        switch (value.getType()) {
            case TEXT: {
                fieldBuilder.setText(value.getStringValue());
                break;
            }
            case HTML: {
                fieldBuilder.setHTML(value.getStringValue());
                break;
            }
            case ATOM: {
                fieldBuilder.setAtom(value.getStringValue());
                break;
            }
            case NUMBER: {
                try {
                    fieldBuilder.setNumber(NumberFormat.getNumberInstance().parse(value.getStringValue()).doubleValue());
                    break;
                }
                catch (ParseException e) {
                    throw new SearchException("Failed to parse double: " + value.getStringValue());
                }
            }
            case GEO: {
                fieldBuilder.setGeoPoint(GeoPoint.newGeoPoint(value.getGeo()));
                break;
            }
            case DATE: {
                String dateString = value.getStringValue();
                if (dateString.isEmpty()) {
                    throw new SearchException(String.format("date not specified for field %s", field.getName()));
                }
                fieldBuilder.setDate(DateUtil.deserializeDate(dateString));
                break;
            }
            case UNTOKENIZED_PREFIX: {
                fieldBuilder.setUntokenizedPrefix(value.getStringValue());
                break;
            }
            case TOKENIZED_PREFIX: {
                fieldBuilder.setTokenizedPrefix(value.getStringValue());
                break;
            }
            case VECTOR: {
                fieldBuilder.setVector(value.getVectorValueList());
                break;
            }
            default: {
                throw new SearchException(String.format("unknown field value type %s for field %s", value.getType(), field.getName()));
            }
        }
        return fieldBuilder;
    }

    DocumentPb.Field copyToProtocolBuffer() {
        DocumentPb.FieldValue.Builder fieldValueBuilder = DocumentPb.FieldValue.newBuilder();
        if (this.locale != null) {
            fieldValueBuilder.setLanguage(this.locale.toString());
        }
        if (this.type != null) {
            switch (this.type.ordinal()) {
                case 0: {
                    if (this.text != null) {
                        fieldValueBuilder.setStringValue(this.text);
                    }
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.TEXT);
                    break;
                }
                case 1: {
                    if (this.html != null) {
                        fieldValueBuilder.setStringValue(this.html);
                    }
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.HTML);
                    break;
                }
                case 2: {
                    if (this.atom != null) {
                        fieldValueBuilder.setStringValue(this.atom);
                    }
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.ATOM);
                    break;
                }
                case 3: {
                    fieldValueBuilder.setStringValue(DateUtil.serializeDate(this.date));
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.DATE);
                    break;
                }
                case 4: {
                    DecimalFormat format = new DecimalFormat();
                    format.setDecimalSeparatorAlwaysShown(false);
                    format.setGroupingUsed(false);
                    format.setMaximumFractionDigits(Integer.MAX_VALUE);
                    fieldValueBuilder.setStringValue(format.format(this.number));
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.NUMBER);
                    break;
                }
                case 5: {
                    fieldValueBuilder.setGeo(this.geoPoint.copyToProtocolBuffer());
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.GEO);
                    break;
                }
                case 6: {
                    if (this.untokenizedPrefix != null) {
                        fieldValueBuilder.setStringValue(this.untokenizedPrefix);
                    }
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.UNTOKENIZED_PREFIX);
                    break;
                }
                case 7: {
                    if (this.tokenizedPrefix != null) {
                        fieldValueBuilder.setStringValue(this.tokenizedPrefix);
                    }
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.TOKENIZED_PREFIX);
                    break;
                }
                case 8: {
                    fieldValueBuilder.addAllVectorValue(this.vector);
                    fieldValueBuilder.setType(DocumentPb.FieldValue.ContentType.VECTOR);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("unknown field type %s", new Object[]{this.type}));
                }
            }
        }
        DocumentPb.Field.Builder builder = DocumentPb.Field.newBuilder().setName(this.name).setValue(fieldValueBuilder);
        return builder.build();
    }

    public String toString() {
        return new Util.ToStringHelper("Field").addField("name", this.name).addField("value", this.valueToString()).addField("type", String.valueOf((Object)this.type)).addField("locale", this.locale).finish();
    }

    private String valueToString() throws IllegalArgumentException {
        if (this.type == null) {
            return "null";
        }
        switch (this.type.ordinal()) {
            case 0: {
                return this.text;
            }
            case 1: {
                return this.html;
            }
            case 2: {
                return this.atom;
            }
            case 3: {
                return DateUtil.formatDateTime(this.date);
            }
            case 5: {
                return this.geoPoint.toString();
            }
            case 4: {
                DecimalFormat format = new DecimalFormat();
                format.setDecimalSeparatorAlwaysShown(false);
                format.setMaximumFractionDigits(Integer.MAX_VALUE);
                return format.format(this.number);
            }
            case 6: {
                return this.untokenizedPrefix;
            }
            case 7: {
                return this.tokenizedPrefix;
            }
            case 8: {
                return this.vector.toString();
            }
        }
        throw new IllegalArgumentException(String.format("unknown field type %s", new Object[]{this.type}));
    }

    public static final class Builder {
        private String name;
        private @Nullable Locale locale;
        private @Nullable FieldType type;
        private @Nullable String text;
        private @Nullable String html;
        private @Nullable String atom;
        private @Nullable Date date;
        private @Nullable Double number;
        private @Nullable GeoPoint geoPoint;
        private @Nullable String untokenizedPrefix;
        private @Nullable String tokenizedPrefix;
        private List<Double> vector = Collections.emptyList();

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = FieldChecker.checkFieldName(name);
            return this;
        }

        public Builder setText(String text) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            this.type = FieldType.TEXT;
            this.text = FieldChecker.checkText(text);
            return this;
        }

        public Builder setHTML(String html) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            this.type = FieldType.HTML;
            this.html = FieldChecker.checkHTML(html);
            return this;
        }

        public Builder setAtom(String atom) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            this.type = FieldType.ATOM;
            this.atom = FieldChecker.checkAtom(atom);
            return this;
        }

        public Builder setDate(Date date) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            Preconditions.checkArgument(date != null, "Cannot set date field to null.");
            this.type = FieldType.DATE;
            this.date = FieldChecker.checkDate(date);
            return this;
        }

        public Builder setNumber(double number) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            this.type = FieldType.NUMBER;
            this.number = FieldChecker.checkNumber(number);
            return this;
        }

        public Builder setGeoPoint(GeoPoint geoPoint) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            Preconditions.checkArgument(geoPoint != null, "Cannot set geo field to null.");
            this.type = FieldType.GEO_POINT;
            this.geoPoint = geoPoint;
            return this;
        }

        public Builder setUntokenizedPrefix(String untokenizedPrefix) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            this.type = FieldType.UNTOKENIZED_PREFIX;
            this.untokenizedPrefix = FieldChecker.checkPrefix(untokenizedPrefix);
            return this;
        }

        public Builder setTokenizedPrefix(String tokenizedPrefix) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            this.type = FieldType.TOKENIZED_PREFIX;
            this.tokenizedPrefix = FieldChecker.checkPrefix(tokenizedPrefix);
            return this;
        }

        public Builder setVector(List<Double> vector) {
            Preconditions.checkArgument(this.type == null, "Field value must not be already set");
            Preconditions.checkArgument(vector != null, "Cannot set vector field to null");
            List<Double> v = ImmutableCopy.list(vector);
            FieldChecker.checkVector(v);
            this.type = FieldType.VECTOR;
            this.vector = v;
            return this;
        }

        public Builder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Field build() {
            return new Field(this);
        }
    }

    public static enum FieldType {
        TEXT,
        HTML,
        ATOM,
        DATE,
        NUMBER,
        GEO_POINT,
        UNTOKENIZED_PREFIX,
        TOKENIZED_PREFIX,
        VECTOR;

    }
}

