/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.log;

import com.google.appengine.api.internal.ImmutableCopy;
import com.google.appengine.api.internal.Repackaged;
import com.google.appengine.api.log.LogService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public final class LogQuery
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3660093076203855168L;
    static final Comparator<Version> VERSION_COMPARATOR = new VersionComparator();
    private @Nullable String offset;
    private @Nullable Long startTimeUsec;
    private @Nullable Long endTimeUsec;
    private int batchSize = 20;
    private @Nullable LogService.LogLevel minLogLevel;
    private boolean includeIncomplete = false;
    private boolean includeAppLogs = false;
    private List<String> majorVersionIds = new ArrayList<String>();
    private List<Version> versions = new ArrayList<Version>();
    private List<String> requestIds = new ArrayList<String>();
    private static final String MAJOR_VERSION_ID_REGEX = "[a-z\\d][a-z\\d\\-]{0,99}";
    private static final Pattern VERSION_PATTERN = Pattern.compile("[a-z\\d][a-z\\d\\-]{0,99}");
    private static final String REQUEST_ID_REGEX = "\\A\\p{XDigit}+\\z";
    private static final Pattern REQUEST_ID_PATTERN = Pattern.compile("\\A\\p{XDigit}+\\z");

    public LogQuery clone() {
        LogQuery clone;
        try {
            clone = (LogQuery)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.majorVersionIds = new ArrayList<String>(this.majorVersionIds);
        clone.requestIds = new ArrayList<String>(this.requestIds);
        clone.versions = new ArrayList<Version>(this.versions);
        return clone;
    }

    public LogQuery offset(String offset) {
        this.offset = offset;
        return this;
    }

    public LogQuery startTimeMillis(long startTimeMillis) {
        this.startTimeUsec = startTimeMillis * 1000L;
        return this;
    }

    public LogQuery startTimeUsec(long startTimeUsec) {
        this.startTimeUsec = startTimeUsec;
        return this;
    }

    public LogQuery endTimeMillis(long endTimeMillis) {
        this.endTimeUsec = endTimeMillis * 1000L;
        return this;
    }

    public LogQuery endTimeUsec(long endTimeUsec) {
        this.endTimeUsec = endTimeUsec;
        return this;
    }

    public LogQuery batchSize(int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize must be greater than zero");
        }
        this.batchSize = batchSize;
        return this;
    }

    public LogQuery minLogLevel(LogService.LogLevel minLogLevel) {
        this.minLogLevel = minLogLevel;
        return this;
    }

    public LogQuery includeIncomplete(boolean includeIncomplete) {
        this.includeIncomplete = includeIncomplete;
        return this;
    }

    public LogQuery includeAppLogs(boolean includeAppLogs) {
        this.includeAppLogs = includeAppLogs;
        return this;
    }

    public LogQuery majorVersionIds(List<String> versionIds) {
        if (!this.versions.isEmpty()) {
            throw new IllegalStateException("LogQuery.majorVersionIds may not be called after LogQuery.versions.");
        }
        for (String versionId : versionIds) {
            Matcher matcher = VERSION_PATTERN.matcher(versionId);
            if (matcher.matches()) continue;
            throw new IllegalArgumentException("versionIds must only contain valid major version identifiers. Version " + versionId + " is not a valid major version identifier.");
        }
        this.majorVersionIds = Repackaged.copyIfRepackagedElseOriginal(versionIds);
        return this;
    }

    public LogQuery versions(List<Version> versions) {
        if (!this.majorVersionIds.isEmpty()) {
            throw new IllegalStateException("LogQuery.versions may not be called after LogQuery.majorVersionIds.");
        }
        if (!this.requestIds.isEmpty()) {
            throw new IllegalStateException("LogQuery.versions may not be called after LogQuery.requestIds.");
        }
        this.versions.clear();
        this.versions.addAll(versions);
        return this;
    }

    public LogQuery requestIds(List<String> requestIds) {
        if (!this.versions.isEmpty()) {
            throw new IllegalStateException("LogQuery.requestIds may not be called after LogQuery.versions.");
        }
        HashSet<String> seen = new HashSet<String>();
        for (String requestId : requestIds) {
            if (!seen.add(requestId)) {
                throw new IllegalArgumentException("requestIds must be unique.");
            }
            Matcher matcher = REQUEST_ID_PATTERN.matcher(requestId);
            if (matcher.matches()) continue;
            throw new IllegalArgumentException("requestIds must only contain valid request ids. " + requestId + " is not a valid request id.");
        }
        this.requestIds = Repackaged.copyIfRepackagedElseOriginal(requestIds);
        return this;
    }

    public @Nullable String getOffset() {
        return this.offset;
    }

    public @Nullable Integer getBatchSize() {
        return this.batchSize;
    }

    public @Nullable Long getEndTimeMillis() {
        return this.endTimeUsec != null ? Long.valueOf(this.endTimeUsec / 1000L) : null;
    }

    public @Nullable Long getEndTimeUsec() {
        return this.endTimeUsec;
    }

    public Boolean getIncludeAppLogs() {
        return this.includeAppLogs;
    }

    public Boolean getIncludeIncomplete() {
        return this.includeIncomplete;
    }

    public @Nullable LogService.LogLevel getMinLogLevel() {
        return this.minLogLevel;
    }

    public @Nullable Long getStartTimeMillis() {
        return this.startTimeUsec != null ? Long.valueOf(this.startTimeUsec / 1000L) : null;
    }

    public @Nullable Long getStartTimeUsec() {
        return this.startTimeUsec;
    }

    public List<String> getMajorVersionIds() {
        return this.majorVersionIds;
    }

    public List<Version> getVersions() {
        return ImmutableCopy.list(this.versions);
    }

    public List<String> getRequestIds() {
        return this.requestIds;
    }

    private static class VersionComparator
    implements Comparator<Version> {
        private VersionComparator() {
        }

        @Override
        public int compare(Version version1, Version version2) {
            int result = version1.getModuleId().compareTo(version2.getModuleId());
            if (result == 0) {
                result = version1.getVersionId().compareTo(version2.getVersionId());
            }
            return result;
        }
    }

    public static final class Builder {
        public static LogQuery withOffset(String offset) {
            return Builder.withDefaults().offset(offset);
        }

        public static LogQuery withStartTimeMillis(long startTimeMillis) {
            return Builder.withDefaults().startTimeMillis(startTimeMillis);
        }

        public static LogQuery withStartTimeUsec(long startTimeUsec) {
            return Builder.withDefaults().startTimeUsec(startTimeUsec);
        }

        public static LogQuery withEndTimeMillis(long endTimeMillis) {
            return Builder.withDefaults().endTimeMillis(endTimeMillis);
        }

        public static LogQuery withEndTimeUsec(long endTimeUsec) {
            return Builder.withDefaults().endTimeUsec(endTimeUsec);
        }

        public static LogQuery withBatchSize(int batchSize) {
            return Builder.withDefaults().batchSize(batchSize);
        }

        public static LogQuery withMinLogLevel(LogService.LogLevel minLogLevel) {
            return Builder.withDefaults().minLogLevel(minLogLevel);
        }

        public static LogQuery withIncludeIncomplete(boolean includeIncomplete) {
            return Builder.withDefaults().includeIncomplete(includeIncomplete);
        }

        public static LogQuery withIncludeAppLogs(boolean includeAppLogs) {
            return Builder.withDefaults().includeAppLogs(includeAppLogs);
        }

        public static LogQuery withMajorVersionIds(List<String> versionIds) {
            return Builder.withDefaults().majorVersionIds(versionIds);
        }

        public static LogQuery withVersions(List<Version> versions) {
            return Builder.withDefaults().versions(versions);
        }

        public static LogQuery withRequestIds(List<String> requestIds) {
            return Builder.withDefaults().requestIds(requestIds);
        }

        public static LogQuery withDefaults() {
            return new LogQuery();
        }
    }

    public static final class Version
    implements Serializable {
        private static final long serialVersionUID = 3697597908142270764L;
        private static final String INVALID_MODULE_ID_MESSAGE_TEMPLATE = "Invalid module id '%s'";
        private static final String INVALID_VERSION_ID_MESSAGE_TEMPLATE = "Invalid version id '%s'";
        private final String moduleId;
        private final String versionId;

        public Version(String moduleId, String versionId) {
            this.moduleId = Version.verifyId(moduleId, INVALID_MODULE_ID_MESSAGE_TEMPLATE);
            this.versionId = Version.verifyId(versionId, INVALID_VERSION_ID_MESSAGE_TEMPLATE);
        }

        public String getModuleId() {
            return this.moduleId;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.moduleId == null ? 0 : this.moduleId.hashCode());
            result = 31 * result + (this.versionId == null ? 0 : this.versionId.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Version other = (Version)obj;
            if (this.moduleId == null ? other.moduleId != null : !this.moduleId.equals(other.moduleId)) {
                return false;
            }
            return !(this.versionId == null ? other.versionId != null : !this.versionId.equals(other.versionId));
        }

        public String toString() {
            return "Version: moduleId=" + this.moduleId + " versionId=" + this.versionId;
        }

        private static String verifyId(String moduleOrVersionId, String messageTemplate) {
            Matcher matcher = VERSION_PATTERN.matcher(moduleOrVersionId);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format(messageTemplate, moduleOrVersionId));
            }
            return moduleOrVersionId;
        }
    }
}

